/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IUnlistedProperty;

public class MimicProperty
implements IUnlistedProperty<IBlockState> {
    public static final MimicProperty MIMIC = new MimicProperty("mimic");
    private static int dirtLikeFlags;
    private static int sandLikeFlags;
    public static final Material[] materialOrderGrassy;
    private static final BlockPos[] searchPattern;
    private final String name;

    public static void setupSoilFlags() {
        dirtLikeFlags = DirtHelper.getSoilFlags("dirtlike");
        sandLikeFlags = DirtHelper.getSoilFlags("sandlike");
        int[] dMap = new int[]{0, -1, 1};
        int i = 0;
        for (int depth : dMap) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                MimicProperty.searchPattern[i++] = BlockPos.field_177992_a.func_177972_a(dir).func_177979_c(depth);
            }
        }
        MimicProperty.searchPattern[i++] = BlockPos.field_177992_a.func_177972_a(EnumFacing.DOWN);
    }

    public MimicProperty(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid(IBlockState value) {
        return value != null;
    }

    public Class<IBlockState> getType() {
        return IBlockState.class;
    }

    public String valueToString(IBlockState value) {
        return value.toString();
    }

    public static IBlockState getGenericMimic(IBlockAccess access, BlockPos pos, Material[] materialOrder, int soilFlags, IBlockState fallBack) {
        if (materialOrder == null) {
            for (BlockPos offset : searchPattern) {
                IBlockState soil = access.func_180495_p(pos.func_177971_a((Vec3i)offset));
                if (!DirtHelper.isSoilAcceptable(soil.func_177230_c(), soilFlags) || soil.func_177230_c() instanceof IMimic) continue;
                return soil;
            }
        } else {
            IBlockState[] cache = new IBlockState[searchPattern.length];
            for (Material material : materialOrder) {
                int i = 0;
                for (BlockPos offset : searchPattern) {
                    IBlockState soil;
                    if (cache[i] == null) {
                        cache[i] = access.func_180495_p(pos.func_177971_a((Vec3i)offset));
                    }
                    if ((soil = cache[i]).func_185904_a() == material && DirtHelper.isSoilAcceptable(soil.func_177230_c(), soilFlags) && !(soil.func_177230_c() instanceof IMimic)) {
                        return soil;
                    }
                    ++i;
                }
            }
        }
        return fallBack;
    }

    public static IBlockState getDirtMimic(IBlockAccess access, BlockPos pos) {
        return MimicProperty.getGenericMimic(access, pos, materialOrderGrassy, dirtLikeFlags, ModBlocks.blockStates.dirt);
    }

    public static IBlockState getSandMimic(IBlockAccess access, BlockPos pos) {
        return MimicProperty.getGenericMimic(access, pos, null, sandLikeFlags, ModBlocks.blockStates.sand);
    }

    static {
        materialOrderGrassy = new Material[]{Material.field_151577_b, Material.field_151578_c};
        searchPattern = new BlockPos[13];
    }

    public static interface IMimic {
        public IBlockState getMimic(IBlockAccess var1, BlockPos var2);
    }
}

