/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.capability;

import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.operation.OperationRegistry;
import ivorius.reccomplex.utils.RCPacketBuffer;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class RCEntityInfo
implements NBTCompoundObject,
PartialUpdateHandler {
    public static final String CAPABILITY_KEY = "structureEntityInfo";
    @CapabilityInject(value=RCEntityInfo.class)
    public static Capability<RCEntityInfo> CAPABILITY;
    private boolean hasChanges;
    private Operation.PreviewType previewType = Operation.PreviewType.SHAPE;
    public Operation danglingOperation;
    public boolean showGrid = false;
    private NBTTagCompound cachedExportStructureBlockDataNBT;
    private NBTTagCompound worldDataClipboard;

    @Nullable
    public static RCEntityInfo get(Object object, @Nullable EnumFacing facing) {
        if (object instanceof RCEntityInfo) {
            return (RCEntityInfo)object;
        }
        if (object instanceof ICapabilityProvider) {
            return (RCEntityInfo)((ICapabilityProvider)object).getCapability(CAPABILITY, facing);
        }
        return null;
    }

    public Operation.PreviewType getPreviewType() {
        return RecurrentComplex.isLite() ? Operation.PreviewType.NONE : this.previewType;
    }

    public void setPreviewType(Operation.PreviewType previewType) {
        this.previewType = previewType;
    }

    public void sendPreviewTypeToClients(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !RecurrentComplex.isLite()) {
            IvNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, (String)CAPABILITY_KEY, null, (String)"previewType", (SimpleNetworkWrapper)RecurrentComplex.network, (Object[])new Object[0]);
        }
    }

    public void sendOperationToClients(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !RecurrentComplex.isLite()) {
            IvNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, (String)CAPABILITY_KEY, null, (String)"operation", (SimpleNetworkWrapper)RecurrentComplex.network, (Object[])new Object[0]);
        }
    }

    public void sendOptionsToClients(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !RecurrentComplex.isLite()) {
            IvNetworkHelperServer.sendEEPUpdatePacket((Entity)entity, (String)CAPABILITY_KEY, null, (String)"options", (SimpleNetworkWrapper)RecurrentComplex.network, (Object[])new Object[0]);
        }
    }

    public NBTTagCompound getCachedExportStructureBlockDataNBT() {
        return this.cachedExportStructureBlockDataNBT;
    }

    public void setCachedExportStructureBlockDataNBT(NBTTagCompound cachedExportStructureBlockDataNBT) {
        this.cachedExportStructureBlockDataNBT = cachedExportStructureBlockDataNBT;
    }

    public NBTTagCompound getWorldDataClipboard() {
        return this.worldDataClipboard;
    }

    public void setWorldDataClipboard(NBTTagCompound worldDataClipboard) {
        this.worldDataClipboard = worldDataClipboard;
    }

    public void queueOperation(Operation operation, Entity owner) {
        this.danglingOperation = operation;
        this.sendOperationToClients(owner);
    }

    public boolean performOperation(WorldServer world, Entity owner) {
        if (this.danglingOperation != null) {
            this.danglingOperation.perform(world);
            this.danglingOperation = null;
            this.sendOperationToClients(owner);
            return true;
        }
        return false;
    }

    public boolean cancelOperation(World world, Entity owner) {
        if (this.danglingOperation != null) {
            this.danglingOperation = null;
            this.sendOperationToClients(owner);
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("previewType", this.previewType.key);
        if (RCConfig.savePlayerCache) {
            if (this.danglingOperation != null) {
                compound.func_74782_a("danglingOperation", (NBTBase)OperationRegistry.writeOperation(this.danglingOperation));
            }
            if (this.worldDataClipboard != null) {
                compound.func_74782_a("worldDataClipboard", (NBTBase)this.worldDataClipboard);
            }
        }
        compound.func_74757_a("showGrid", this.showGrid);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.previewType = Operation.PreviewType.findOrDefault(compound.func_74779_i("previewType"), Operation.PreviewType.SHAPE);
        if (RCConfig.savePlayerCache) {
            if (compound.func_150297_b("danglingOperation", 10)) {
                this.danglingOperation = OperationRegistry.readOperation(compound.func_74775_l("danglingOperation"));
            }
            if (compound.func_150297_b("worldDataClipboard", 10)) {
                this.worldDataClipboard = compound.func_74775_l("worldDataClipboard");
            }
        }
        this.showGrid = compound.func_74767_n("showGrid");
        this.hasChanges = true;
    }

    public void update(Entity entity) {
        if (this.danglingOperation != null) {
            this.danglingOperation.update(entity.field_70170_p, entity.field_70173_aa);
            if (this.danglingOperation.checkDead((ICommandSender)entity)) {
                this.danglingOperation = null;
                this.hasChanges = true;
            }
        }
        if (this.hasChanges) {
            this.sendChanges(entity);
        }
    }

    public void sendChanges(Entity entity) {
        this.hasChanges = false;
        this.sendPreviewTypeToClients(entity);
        this.sendOperationToClients(entity);
        this.sendOptionsToClients(entity);
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("previewType".equals(context)) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.previewType.key);
        } else if ("operation".equals(context)) {
            OperationRegistry.writeBestPreview(buffer, this.danglingOperation);
        } else if ("options".equals(context)) {
            buffer.writeBoolean(this.showGrid);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("previewType".equals(context)) {
            this.previewType = Operation.PreviewType.findOrDefault(ByteBufUtils.readUTF8String((ByteBuf)buffer), Operation.PreviewType.SHAPE);
        } else if ("operation".equals(context)) {
            try {
                NBTTagCompound tag = new RCPacketBuffer(buffer).readBigTag();
                this.danglingOperation = tag != null ? OperationRegistry.readOperation(tag) : null;
            }
            catch (Exception e) {
                RecurrentComplex.logger.warn("Error reading operation tag", (Throwable)e);
                this.danglingOperation = null;
            }
        } else if ("options".equals(context)) {
            this.showGrid = buffer.readBoolean();
        }
    }
}

