/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dshuds;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.orecruncher.dshuds.ModBase;

@Mod.EventBusSubscriber(modid="dshuds")
@Config(modid="dshuds", type=Config.Type.INSTANCE, name="dshuds", category="")
public class ModOptions {
    private static final String PREFIX = "config.dshuds";
    @Config.Name(value="Logging")
    @Config.Comment(value={"Options to control logging"})
    @Config.LangKey(value="config.dshuds.logging")
    public static Logging logging = new Logging();
    @Config.Name(value="PotionHud")
    @Config.LangKey(value="config.dshuds.potionhud")
    @Config.Comment(value={"Options for the Potion HUD overlay"})
    public static PotionHUD potionHUD = new PotionHUD();
    @Config.Name(value="LightLevelHud")
    @Config.LangKey(value="config.dshuds.lightlevelhud")
    @Config.Comment(value={"Options for configuring Light Level HUD"})
    public static LightLevelHUD lightLevelHUD = new LightLevelHUD();
    @Config.Name(value="CompassHud")
    @Config.LangKey(value="config.dshuds.compasshud")
    @Config.Comment(value={"Options for configuring compass HUD"})
    public static CompassHUD compassHUD = new CompassHUD();
    @Config.Name(value="ClockHud")
    @Config.LangKey(value="config.dshuds.clockhud")
    @Config.Comment(value={"Options for configuring clock HUD"})
    public static ClockHUD clockHUD = new ClockHUD();

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("dshuds")) {
            ConfigManager.sync((String)"dshuds", (Config.Type)Config.Type.INSTANCE);
            ModBase.log().setDebug(ModOptions.logging.enableLogging);
        }
    }

    public static class ClockHUD {
        private static final String PREFIX = "config.dshuds.clockhud";
        @Config.LangKey(value="config.dshuds.clockhud.enable")
        @Config.Comment(value={"Enable/disable clock HUD when clock is held"})
        public boolean enable = true;
    }

    public static class CompassHUD {
        private static final String PREFIX = "config.dshuds.compasshud";
        @Config.LangKey(value="config.dshuds.compasshud.enable")
        @Config.Comment(value={"Enable/disable compass HUD when compass is held"})
        public boolean enable = true;
        @Config.LangKey(value="config.dshuds.compasshud.style")
        @Config.Comment(value={"Style of compass bar"})
        @Config.RangeInt(min=0, max=6)
        public int style = 0;
        @Config.LangKey(value="config.dshuds.compasshud.transparency")
        @Config.Comment(value={"Compass transparency"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float transparency = 0.4f;
        @Config.LangKey(value="config.dshuds.compasshud.format")
        @Config.Comment(value={"Format string for location coordinates"})
        public String coordFormat = "x: %1$d, z: %3$d";
    }

    public static class LightLevelHUD {
        private static final String PREFIX = "config.dshuds.lightlevelhud";
        @Config.LangKey(value="config.dshuds.lightlevelhud.range")
        @Config.Comment(value={"Range from player to analyze light levels"})
        @Config.RangeInt(min=16, max=32)
        public int range = 24;
        @Config.LangKey(value="config.dshuds.lightlevelhud.mobspawnthreshold")
        @Config.Comment(value={"Light level at which mobs can spawn"})
        @Config.RangeInt(min=0, max=15)
        public int spawnThreshold = 7;
        @Config.LangKey(value="config.dshuds.lightlevelhud.displaymode")
        @Config.Comment(value={"0: Block Light, 1: Block Light + Sky Light"})
        @Config.RangeInt(min=0, max=1)
        public int displayMode = 0;
        @Config.LangKey(value="config.dshuds.lightlevelhud.hidesafe")
        @Config.Comment(value={"Hide light level information for blocks that are considered safe"})
        public boolean hideSafe = false;
        @Config.LangKey(value="config.dshuds.lightlevelhud.indicatecaution")
        @Config.Comment(value={"Indicate current light levels that will change at night which could result in mob spawns"})
        public boolean indicateCaution = true;
        @Config.LangKey(value="config.dshuds.lightlevelhud.colors")
        @Config.Comment(value={"Color set: 0 bright, 1 dark"})
        @Config.RangeInt(min=0, max=1)
        public int colors = 1;
    }

    public static class PotionHUD {
        private static final String PREFIX = "config.dshuds.potionhud";
        @Config.LangKey(value="config.dshuds.potionhud.nohud")
        @Config.Comment(value={"Disables Vanilla and Dynamic Surroundings potion HUD"})
        public boolean none = false;
        @Config.LangKey(value="config.dshuds.potionhud.enable")
        @Config.Comment(value={"Enable display of potion icons in display"})
        public boolean enabled = true;
        @Config.LangKey(value="config.dshuds.potionhud.transparency")
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Transparency factor for icons (higher more solid)"})
        public float transparency = 0.75f;
        @Config.LangKey(value="config.dshuds.potionhud.leftoffset")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Offset from left side of screen"})
        public int leftOffset = 5;
        @Config.LangKey(value="config.dshuds.potionhud.topoffset")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Offset from top of screen"})
        public int topOffset = 5;
        @Config.LangKey(value="config.dshuds.potionhud.scale")
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"Size scale of icons (lower is smaller)"})
        public float scale = 0.75f;
        @Config.LangKey(value="config.dshuds.potionhud.location")
        @Config.RangeInt(min=0, max=1)
        @Config.Comment(value={"Area of the display the Potion HUD is displayed (0 upper left, 1 upper right)"})
        public int anchor = 0;
    }

    public static class Logging {
        private static final String PREFIX = "config.dshuds.logging";
        @Config.LangKey(value="config.dshuds.logging.enableLogging")
        @Config.Comment(value={"Enables debug logging output for diagnostics"})
        public boolean enableLogging = false;
        @Config.LangKey(value="config.dshuds.logging.enableVersionCheck")
        @Config.Comment(value={"Enables display of chat messages related to newer versions", "of the mod being available."})
        public boolean enableVersionCheck = true;
        @Config.LangKey(value="config.dshuds.logging.chatnotices")
        @Config.Comment(value={"Disable display of hud toggles in chat"})
        public boolean hideChatNotices = false;
    }
}

