/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import org.minimallycorrect.tickprofiler.util.ChatFormat;
import org.minimallycorrect.tickprofiler.util.stringfillers.StringFiller;

public class TableFormatter {
    private static final int[] POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};
    public final StringBuilder sb = new StringBuilder();
    private final StringFiller stringFiller;
    private final List<String> currentHeadings = new ArrayList<String>();
    private final List<String> currentData = new ArrayList<String>();
    public String tableSeparator = "";
    private String splitter = " | ";
    private String headingSplitter = " | ";
    private String headingColour = "";
    private List<List<Map<String, String>>> tables;

    public TableFormatter(ICommandSender commandSender) {
        this(commandSender instanceof Entity ? StringFiller.CHAT : StringFiller.FIXED_WIDTH, false);
    }

    public TableFormatter(StringFiller stringFiller, boolean recordTables) {
        this.stringFiller = stringFiller;
        ArrayList arrayList = this.tables = recordTables ? new ArrayList() : null;
        if (stringFiller == StringFiller.CHAT) {
            this.headingSplitter = this.splitter = " " + (Object)((Object)ChatFormat.YELLOW) + '|' + (Object)((Object)ChatFormat.RESET) + ' ';
            this.headingColour = String.valueOf((Object)ChatFormat.DARK_GREEN);
        }
    }

    public static String formatDoubleWithPrecision(double val, int precision) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            return Double.toString(val);
        }
        StringBuilder sb = new StringBuilder();
        if (val < 0.0) {
            sb.append('-');
            val = -val;
        }
        int exp = POW10[precision];
        long lval = (long)(val * (double)exp + 0.5);
        sb.append(lval / (long)exp).append('.');
        long fval = lval % (long)exp;
        for (int p = precision - 1; p > 0 && fval < (long)POW10[p]; --p) {
            sb.append('0');
        }
        sb.append(fval);
        return sb.toString();
    }

    public TableFormatter heading(String text) {
        this.currentHeadings.add(text);
        return this;
    }

    public TableFormatter row(String data) {
        this.currentData.add(data);
        return this;
    }

    public TableFormatter row(Object data) {
        return this.row(String.valueOf(data));
    }

    public TableFormatter row(int data) {
        return this.row(String.valueOf(data));
    }

    public TableFormatter row(long data) {
        return this.row(String.valueOf(data));
    }

    public TableFormatter row(double data) {
        this.currentData.add(TableFormatter.formatDoubleWithPrecision(data, 3));
        return this;
    }

    public void finishTable() {
        int rowIndex = 0;
        int rowCount = this.currentHeadings.size();
        double[] rowLengths = new double[rowCount];
        this.getMaxLengths(rowLengths, rowIndex, rowCount, this.currentHeadings);
        this.getMaxLengths(rowLengths, rowIndex, rowCount, this.currentData);
        String cSplit = "";
        for (String heading : this.currentHeadings) {
            this.sb.append(cSplit).append(this.headingColour).append(this.stringFiller.fill(heading, rowLengths[rowIndex % rowCount]));
            cSplit = this.headingSplitter;
            ++rowIndex;
        }
        this.sb.append('\n');
        cSplit = "";
        rowIndex = 0;
        ArrayList table = null;
        if (this.tables != null) {
            table = new ArrayList();
            this.tables.add(table);
        }
        HashMap<String, String> entry = null;
        for (String data : this.currentData) {
            if (rowIndex % rowCount == 0 && table != null) {
                entry = new HashMap<String, String>();
                table.add(entry);
            }
            this.sb.append(cSplit).append(this.stringFiller.fill(data, rowLengths[rowIndex % rowCount]));
            cSplit = this.splitter;
            if (entry != null) {
                entry.put(this.currentHeadings.get(rowIndex % rowCount), data);
            }
            if (++rowIndex % rowCount != 0 || rowIndex == this.currentData.size()) continue;
            this.sb.append('\n');
            cSplit = "";
        }
        this.sb.append(this.tableSeparator);
        this.currentHeadings.clear();
        this.currentData.clear();
    }

    private void getMaxLengths(double[] rowLengths, int rowIndex, int rowCount, Iterable<String> stringIterable) {
        for (String data : stringIterable) {
            double length = this.stringFiller.getLength(data);
            if (rowLengths[rowIndex % rowCount] < length) {
                rowLengths[rowIndex % rowCount] = length;
            }
            ++rowIndex;
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    public List<List<Map<String, String>>> getTables() {
        return this.tables;
    }
}

