/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.profiling;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.minimallycorrect.tickprofiler.minecraft.profiling.Profile;
import org.minimallycorrect.tickprofiler.util.CollectionsUtil;
import org.minimallycorrect.tickprofiler.util.TableFormatter;

public class UtilisationProfiler
extends Profile {
    @Override
    public void start() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        int elements = this.parameters.getInt("elements");
        if (elements <= 0) {
            throw new IllegalArgumentException("elements must be > 0");
        }
        HashMap initialTimes = new HashMap();
        this.start(() -> {
            threadMxBean.setThreadCpuTimeEnabled(true);
            List<Long> threads = Thread.getAllStackTraces().keySet().stream().map(Thread::getId).collect(Collectors.toList());
            this.getThreadCpuTimes(threadMxBean, threads, initialTimes);
        }, () -> {
            List<Long> threads = Thread.getAllStackTraces().keySet().stream().map(Thread::getId).collect(Collectors.toList());
            HashMap<String, Long> endTimes = new HashMap<String, Long>();
            this.getThreadCpuTimes(threadMxBean, threads, endTimes);
            HashMap<String, Long> endDurations = new HashMap<String, Long>();
            for (Map.Entry<String, Long> e : endTimes.entrySet()) {
                endDurations.put(e.getKey(), e.getValue() - initialTimes.getOrDefault(e.getKey(), 0L));
            }
            this.targets.forEach(it -> {
                TableFormatter tf = it.getTableFormatter();
                double runTimeNanoSeconds = TimeUnit.SECONDS.toNanos(this.runTimeSeconds);
                tf.heading("Thread").heading("Used CPU Time (%)");
                for (String key : CollectionsUtil.sortedKeys(endDurations, elements)) {
                    tf.row(key).row(100.0 * (double)((Long)endDurations.get(key)).longValue() / runTimeNanoSeconds);
                }
                tf.finishTable();
                it.sendTables(tf);
            });
        }, () -> threadMxBean.setThreadCpuTimeEnabled(false));
    }

    private void getThreadCpuTimes(ThreadMXBean threadMxBean, List<Long> threads, HashMap<String, Long> map) {
        for (Long threadId_ : threads) {
            ThreadInfo thread;
            long threadId = threadId_;
            long time = threadMxBean.getThreadCpuTime(threadId);
            if (time < 0L || (thread = threadMxBean.getThreadInfo(threadId, 0)) == null) continue;
            map.put(thread.getThreadName(), time);
        }
    }
}

