/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreestbl.ModContent;
import maxhyper.dynamictreestbl.blocks.BlockBranchSap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.common.registries.BlockRegistry;

public class TreeSap
extends TreeFamily {
    public static Block leavesBlock = BlockRegistry.LEAVES_SAP_TREE;
    public static Block logBlock = BlockRegistry.LOG_SAP;
    public static Block saplingBlock = BlockRegistry.SAPLING_SAP;
    BlockSurfaceRoot root;

    public TreeSap() {
        super(new ResourceLocation("dynamictreestbl", "sap"));
        this.setPrimitiveLog(logBlock.func_176223_P());
        ModContent.sapLeavesProperties.setTree((TreeFamily)this);
        this.root = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 4, 0);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.root;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesSap(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.root);
        return super.getRegisterableBlocks(blockList);
    }

    public BlockBranch createBranch() {
        return new BlockBranchSap(this.getName() + "branch");
    }

    public class SpeciesSap
    extends Species {
        SpeciesSap(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.sapLeavesProperties);
            this.setBasicGrowingParameters(0.6f, 18.0f, 2, 4, 0.9f);
            this.generateSeed();
            this.addDropCreator((IDropCreator)new DropCreatorSeed(3.0f));
            this.addAcceptableSoils(new String[]{"mudlike"});
            this.addGenFeature((IGenFeature)new FeatureGenRoots(8).setScaler((inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 8 ? (float)trunkRadius.intValue() / 10.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            }));
        }

        public boolean useDefaultWailaBody() {
            return false;
        }

        private boolean isNextToTrunk(BlockPos signalPos, GrowSignal signal) {
            if (signal.numTurns != 1) {
                return false;
            }
            BlockPos rootPos = signal.rootPos;
            if (signalPos.func_177952_p() < rootPos.func_177952_p()) {
                return rootPos.func_177952_p() - signalPos.func_177952_p() == 1;
            }
            if (signalPos.func_177952_p() > rootPos.func_177952_p()) {
                return signalPos.func_177952_p() - rootPos.func_177952_p() == 1;
            }
            if (signalPos.func_177958_n() > rootPos.func_177958_n()) {
                return signalPos.func_177958_n() - rootPos.func_177958_n() == 1;
            }
            if (signalPos.func_177958_n() < rootPos.func_177958_n()) {
                return rootPos.func_177958_n() - signalPos.func_177958_n() == 1;
            }
            return false;
        }

        private EnumFacing getRelativeFace(BlockPos signalPos, BlockPos rootPos) {
            if (signalPos.func_177952_p() < rootPos.func_177952_p()) {
                return EnumFacing.NORTH;
            }
            if (signalPos.func_177952_p() > rootPos.func_177952_p()) {
                return EnumFacing.SOUTH;
            }
            if (signalPos.func_177958_n() > rootPos.func_177958_n()) {
                return EnumFacing.EAST;
            }
            if (signalPos.func_177958_n() < rootPos.func_177958_n()) {
                return EnumFacing.WEST;
            }
            return EnumFacing.UP;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            if (signal.energy > 1.0f) {
                if (!signal.isInTrunk()) {
                    signal.tapering = 0.6f;
                    EnumFacing relativePosToRoot = this.getRelativeFace(pos, signal.rootPos);
                    for (EnumFacing dir : EnumFacing.values()) {
                        if (dir == EnumFacing.DOWN) continue;
                        probMap[dir.func_176745_a()] = TreeHelper.isBranch((IBlockState)world.func_180495_p(pos.func_177972_a(dir))) ? 2 : 0;
                    }
                    boolean isBranchSide = TreeHelper.isBranch((IBlockState)world.func_180495_p(pos.func_177972_a(relativePosToRoot)));
                    boolean isBranchUp = TreeHelper.isBranch((IBlockState)world.func_180495_p(pos.func_177984_a()));
                    probMap[EnumFacing.UP.func_176745_a()] = isBranchSide && !isBranchUp ? 0 : 2;
                    int n = probMap[relativePosToRoot.func_176745_a()] = isBranchUp && !isBranchSide ? 0 : 2;
                    if (this.isNextToTrunk(pos, signal)) {
                        signal.energy = 5.0f;
                        probMap[EnumFacing.UP.func_176745_a()] = 0;
                    }
                    probMap[EnumFacing.DOWN.func_176745_a()] = 0;
                } else {
                    signal.tapering = 0.2f;
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (!TreeHelper.isBranch((IBlockState)world.func_180495_p(pos.func_177972_a(dir).func_177981_b(2))) && !TreeHelper.isBranch((IBlockState)world.func_180495_p(pos.func_177972_a(dir).func_177979_c(2)))) continue;
                        probMap[dir.func_176745_a()] = 0;
                    }
                    int n = EnumFacing.UP.func_176745_a();
                    probMap[n] = probMap[n] + 5;
                }
            }
            probMap[signal.dir.func_176734_d().ordinal()] = 0;
            return probMap;
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"sandlike"}))) {
                return ModBlocks.blockRootySand;
            }
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"mudlike"}))) {
                return ModContent.blockRootyMud;
            }
            return ModBlocks.blockRootyDirt;
        }
    }
}

