/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.Objects;
import maxhyper.dynamictreestbl.ModContent;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.common.registries.BlockRegistry;

public class TreeRubber
extends TreeFamily {
    public static Block leavesBlock = BlockRegistry.LEAVES_RUBBER_TREE;
    public static Block logBlock = BlockRegistry.LOG_RUBBER;
    public static Block saplingBlock = BlockRegistry.SAPLING_RUBBER;

    public TreeRubber() {
        super(new ResourceLocation("dynamictreestbl", "rubber"));
        this.setPrimitiveLog(logBlock.func_176223_P());
        this.setDynamicBranch(ModContent.rubberBranch);
        ModContent.rubberLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock));
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesRubber(this));
    }

    public BlockBranch createBranch() {
        return ModContent.rubberBranch;
    }

    public class SpeciesRubber
    extends Species {
        SpeciesRubber(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.rubberLeavesProperties);
            this.setBasicGrowingParameters(0.2f, 18.0f, 10, 12, 1.2f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"darkoak"));
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.WET, 1.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.1f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(12));
            this.addAcceptableSoils(new String[]{"mudlike"});
        }

        public Species.LogsAndSticks getLogsAndSticks(float volume) {
            return super.getLogsAndSticks(volume * 4.0f);
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"sandlike"}))) {
                return ModBlocks.blockRootySand;
            }
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"mudlike"}))) {
                return ModContent.blockRootyMud;
            }
            return ModBlocks.blockRootyDirt;
        }
    }
}

