/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreestbl.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class TreeNibbletwig
extends TreeFamily {
    public static Block leavesBlock = BlockRegistry.LEAVES_NIBBLETWIG_TREE;
    public static Block logBlock = BlockRegistry.LOG_NIBBLETWIG;
    public static Block saplingBlock = BlockRegistry.SAPLING_NIBBLETWIG;

    public TreeNibbletwig() {
        super(new ResourceLocation("dynamictreestbl", "nibbletwig"));
        this.setPrimitiveLog(logBlock.func_176223_P());
        this.setStick(new ItemStack(ItemRegistry.NIBBLESTICK));
        ModContent.nibbletwigLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 4, 0);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public ItemStack getStick(int qty) {
        ItemStack stack = new ItemStack(ItemRegistry.NIBBLESTICK);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesNibbletwig(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        return super.getRegisterableBlocks(blockList);
    }

    public class SpeciesNibbletwig
    extends Species {
        SpeciesNibbletwig(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.nibbletwigLeavesProperties);
            this.setSoilLongevity(3);
            this.setBasicGrowingParameters(0.2f, 20.0f, 10, 4, 0.8f);
            this.setupStandardSeedDropping();
            this.generateSeed();
            this.addAcceptableSoils(new String[]{"mudlike"});
            this.addGenFeature((IGenFeature)new FeatureGenVine().setVineBlock(BlockRegistry.POISON_IVY).setQuantity(12));
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                int n = dir.ordinal();
                probMap[n] = probMap[n] * 2;
            }
            if (signal.isInTrunk()) {
                probMap[EnumFacing.UP.ordinal()] = 0;
            }
            if (radius > 1 && !signal.isInTrunk() && signal.energy > 3.0f) {
                for (EnumFacing dir : EnumFacing.values()) {
                    if (TreeHelper.isBranch((IBlockState)world.func_180495_p(pos.func_177972_a(dir)))) continue;
                    probMap[dir.ordinal()] = 0;
                }
            }
            if (signal.rootPos.func_185332_f(pos.func_177958_n(), signal.rootPos.func_177956_o(), pos.func_177952_p()) <= 1.0 && signal.numTurns == 1) {
                EnumFacing[] otherFaces;
                BlockPos centerPos = new BlockPos(signal.rootPos.func_177958_n(), pos.func_177956_o(), signal.rootPos.func_177952_p());
                EnumFacing thisFace = this.getRelativeFace(pos, signal.rootPos);
                for (EnumFacing dir : otherFaces = new EnumFacing[]{thisFace.func_176746_e(), thisFace.func_176734_d(), thisFace.func_176735_f()}) {
                    if (!TreeHelper.isBranch((IBlockState)world.func_180495_p(centerPos.func_177972_a(dir))) || TreeHelper.getRadius((IBlockAccess)world, (BlockPos)centerPos.func_177972_a(dir)) <= 1) continue;
                    signal.energy = 1.0f;
                    break;
                }
            } else {
                probMap[EnumFacing.DOWN.ordinal()] = 0;
            }
            probMap[signal.dir.func_176734_d().ordinal()] = 0;
            return probMap;
        }

        private EnumFacing getRelativeFace(BlockPos signalPos, BlockPos rootPos) {
            if (signalPos.func_177952_p() < rootPos.func_177952_p()) {
                return EnumFacing.NORTH;
            }
            if (signalPos.func_177952_p() > rootPos.func_177952_p()) {
                return EnumFacing.SOUTH;
            }
            if (signalPos.func_177958_n() > rootPos.func_177958_n()) {
                return EnumFacing.EAST;
            }
            if (signalPos.func_177958_n() < rootPos.func_177958_n()) {
                return EnumFacing.WEST;
            }
            return EnumFacing.UP;
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"sandlike"}))) {
                return ModBlocks.blockRootySand;
            }
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"mudlike"}))) {
                return ModContent.blockRootyMud;
            }
            return ModBlocks.blockRootyDirt;
        }

        public float getEnergy(World world, BlockPos rootPos) {
            long day = world.func_82737_E() / 24000L;
            int month = (int)day / 30;
            return this.signalEnergy * this.biomeSuitability(world, rootPos) + (float)(CoordUtils.coordHashCode((BlockPos)rootPos.func_177981_b(month), (int)2) % 10);
        }
    }
}

