/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.models;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import maxhyper.dynamictreestbl.models.BakedModelBlockSurfaceRootBLEvent;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelBlockSurfaceRootBLEvent
implements IModel {
    public ResourceLocation barkTexture;
    public ResourceLocation barkTextureFrosty;
    public ResourceLocation barkTextureSpook;
    boolean hasFrosty = true;
    boolean hasSpooky = true;

    public ModelBlockSurfaceRootBLEvent(ModelBlock modelBlock) {
        this.barkTexture = new ResourceLocation(modelBlock.func_178308_c("bark"));
        this.barkTextureFrosty = new ResourceLocation(modelBlock.func_178308_c("bark_frosty"));
        this.barkTextureSpook = new ResourceLocation(modelBlock.func_178308_c("bark_spook"));
        if (this.barkTexture == this.barkTextureFrosty) {
            this.hasFrosty = false;
        }
        if (this.barkTexture == this.barkTextureSpook) {
            this.hasSpooky = false;
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Object[])new ResourceLocation[0]);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf(new HashSet<ResourceLocation>(Arrays.asList(this.barkTexture, this.barkTextureFrosty, this.barkTextureSpook)));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            return new BakedModelBlockSurfaceRootBLEvent(this.barkTexture, this.hasFrosty ? this.barkTextureFrosty : null, this.hasSpooky ? this.barkTextureSpook : null, bakedTextureGetter);
        }
        catch (Exception exception) {
            System.err.println("BakedModelBlockSurfaceRoot.bake() failed due to exception:" + exception);
            return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
        }
    }
}

