/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.models;

import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;
import thebetweenlands.common.registries.ModelRegistry;

@SideOnly(value=Side.CLIENT)
public class BakedModelBlockSurfaceRootBLEvent
implements IBakedModel {
    protected ModelBlock modelBlock;
    TextureAtlasSprite barkParticles;
    private IBakedModel[][] sleeves = new IBakedModel[4][7];
    private IBakedModel[][] cores = new IBakedModel[2][8];
    private IBakedModel[][] verts = new IBakedModel[4][8];
    private IBakedModel[][] sleevesF = new IBakedModel[4][7];
    private IBakedModel[][] coresF = new IBakedModel[2][8];
    private IBakedModel[][] vertsF = new IBakedModel[4][8];
    private IBakedModel[][] sleevesS = new IBakedModel[4][7];
    private IBakedModel[][] coresS = new IBakedModel[2][8];
    private IBakedModel[][] vertsS = new IBakedModel[4][8];
    boolean hasFrosty = true;
    boolean hasSpooky = true;

    private IBakedModel[][] getSleeves() {
        if (this.hasFrosty && ModelRegistry.WINTER_EVENT.isActive()) {
            return this.sleevesF;
        }
        if (this.hasSpooky && ModelRegistry.SPOOK_EVENT.isActive()) {
            return this.sleevesS;
        }
        return this.sleeves;
    }

    private IBakedModel[][] getCores() {
        if (this.hasFrosty && ModelRegistry.WINTER_EVENT.isActive()) {
            return this.coresF;
        }
        if (this.hasFrosty && ModelRegistry.SPOOK_EVENT.isActive()) {
            return this.coresS;
        }
        return this.cores;
    }

    private IBakedModel[][] getVerts() {
        if (this.hasFrosty && ModelRegistry.WINTER_EVENT.isActive()) {
            return this.vertsF;
        }
        if (this.hasFrosty && ModelRegistry.SPOOK_EVENT.isActive()) {
            return this.vertsS;
        }
        return this.verts;
    }

    public BakedModelBlockSurfaceRootBLEvent(ResourceLocation barkRes, ResourceLocation barkResF, ResourceLocation barkResS, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        int horIndex;
        int r;
        TextureAtlasSprite barkIcon;
        this.modelBlock = new ModelBlock(null, null, null, false, false, ItemCameraTransforms.field_178357_a, null);
        if (barkResF == null) {
            this.hasFrosty = false;
        }
        if (barkResS == null) {
            this.hasSpooky = false;
        }
        this.barkParticles = barkIcon = bakedTextureGetter.apply(barkRes);
        for (int r2 = 0; r2 < 8; ++r2) {
            int radius = r2 + 1;
            if (radius < 8) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    int horIndex2 = dir.func_176736_b();
                    this.sleeves[horIndex2][r2] = this.bakeSleeve(radius, dir, barkIcon);
                    this.verts[horIndex2][r2] = this.bakeVert(radius, dir, barkIcon);
                }
            }
            this.cores[0][r2] = this.bakeCore(radius, EnumFacing.Axis.Z, barkIcon);
            this.cores[1][r2] = this.bakeCore(radius, EnumFacing.Axis.X, barkIcon);
        }
        if (this.hasFrosty) {
            TextureAtlasSprite barkIconF = bakedTextureGetter.apply(barkResF);
            for (r = 0; r < 8; ++r) {
                int radius = r + 1;
                if (radius < 8) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        horIndex = dir.func_176736_b();
                        this.sleevesF[horIndex][r] = this.bakeSleeve(radius, dir, barkIconF);
                        this.vertsF[horIndex][r] = this.bakeVert(radius, dir, barkIconF);
                    }
                }
                this.coresF[0][r] = this.bakeCore(radius, EnumFacing.Axis.Z, barkIconF);
                this.coresF[1][r] = this.bakeCore(radius, EnumFacing.Axis.X, barkIconF);
            }
        }
        if (this.hasSpooky) {
            TextureAtlasSprite barkIconS = bakedTextureGetter.apply(barkResS);
            for (r = 0; r < 8; ++r) {
                int radius = r + 1;
                if (radius < 8) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        horIndex = dir.func_176736_b();
                        this.sleevesS[horIndex][r] = this.bakeSleeve(radius, dir, barkIconS);
                        this.vertsS[horIndex][r] = this.bakeVert(radius, dir, barkIconS);
                    }
                }
                this.coresS[0][r] = this.bakeCore(radius, EnumFacing.Axis.Z, barkIconS);
                this.coresS[1][r] = this.bakeCore(radius, EnumFacing.Axis.X, barkIconS);
            }
        }
    }

    public int getRadialHeight(int radius) {
        return radius * 2;
    }

    public IBakedModel bakeSleeve(int radius, EnumFacing dir, TextureAtlasSprite bark) {
        boolean sleeveNegative;
        int radialHeight = this.getRadialHeight(radius);
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.func_82601_c() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.func_82599_e() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.func_82601_c() * move;
        int centerZ = 16 + dir.func_82599_e() * move;
        Vector3f posFrom = new Vector3f((float)((centerX - halfSizeX) / 2), 0.0f, (float)((centerZ - halfSizeZ) / 2));
        Vector3f posTo = new Vector3f((float)((centerX + halfSizeX) / 2), (float)radialHeight, (float)((centerZ + halfSizeZ) / 2));
        boolean bl = sleeveNegative = dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            sleeveNegative = !sleeveNegative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (dir.func_176734_d() == face) continue;
            BlockFaceUV uvface = null;
            if (face.func_176740_k().func_176722_c()) {
                boolean facePositive = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                uvface = new BlockFaceUV(new float[]{facePositive ? (float)(16 - radialHeight) : 0.0f, sleeveNegative ? 16 - halfSize : 0, facePositive ? 16.0f : (float)radialHeight, sleeveNegative ? 16 : halfSize}, ModelUtils.getFaceAngle((EnumFacing.Axis)dir.func_176740_k(), (EnumFacing)face));
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, sleeveNegative ? (float)(16 - halfSize) : 0.0f, 8 + radius, sleeveNegative ? 16.0f : (float)halfSize}, ModelUtils.getFaceAngle((EnumFacing.Axis)dir.func_176740_k(), (EnumFacing)face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(bark);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            EnumFacing face = (EnumFacing)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)bark, (EnumFacing)face, (ITransformation)ModelRotation.X0_Y0, (boolean)false));
        }
        return builder.func_177645_b();
    }

    private IBakedModel bakeVert(int radius, EnumFacing dir, TextureAtlasSprite bark) {
        int radialHeight = this.getRadialHeight(radius);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(bark);
        AxisAlignedBB partBoundary = new AxisAlignedBB((double)(8 - radius), (double)radialHeight, (double)(8 - radius), (double)(8 + radius), (double)(16 + radialHeight), (double)(8 + radius)).func_72317_d((double)(dir.func_82601_c() * 7), 0.0, (double)(dir.func_82599_e() * 7));
        for (int i = 0; i < 2; ++i) {
            AxisAlignedBB pieceBoundary = partBoundary.func_191500_a(new AxisAlignedBB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).func_72317_d(0.0, (double)(16 * i), 0.0));
            for (EnumFacing face : EnumFacing.field_82609_l) {
                EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
                BlockFaceUV uvface = new BlockFaceUV(ModelUtils.modUV((float[])ModelUtils.getUVs((AxisAlignedBB)pieceBoundary, (EnumFacing)face)), ModelUtils.getFaceAngle((EnumFacing.Axis)EnumFacing.Axis.Y, (EnumFacing)face));
                mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
                Vector3f[] limits = ModelUtils.AABBLimits((AxisAlignedBB)pieceBoundary);
                BlockPart part = new BlockPart(limits[0], limits[1], (Map)mapFacesIn, null, true);
                builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)part.field_178240_c.get(face)), (TextureAtlasSprite)bark, (EnumFacing)face, (ITransformation)ModelRotation.X0_Y0, (boolean)false));
            }
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCore(int radius, EnumFacing.Axis axis, TextureAtlasSprite icon) {
        int radialHeight = this.getRadialHeight(radius);
        Vector3f posFrom = new Vector3f((float)(8 - radius), 0.0f, (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)radialHeight, (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockFaceUV uvface;
            if (face.func_176740_k().func_176722_c()) {
                boolean positive = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                uvface = new BlockFaceUV(new float[]{positive ? (float)(16 - radialHeight) : 0.0f, 8 - radius, positive ? 16.0f : (float)radialHeight, 8 + radius}, ModelUtils.getFaceAngle((EnumFacing.Axis)axis, (EnumFacing)face));
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, ModelUtils.getFaceAngle((EnumFacing.Axis)axis, (EnumFacing)face));
            }
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(icon);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            EnumFacing face = (EnumFacing)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)icon, (EnumFacing)face, (ITransformation)ModelRotation.X0_Y0, (boolean)false));
        }
        return builder.func_177645_b();
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(24);
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)blockState;
        if (blockState instanceof IExtendedBlockState) {
            boolean isGrounded;
            int[] connections;
            int coreRadius = this.getRadius(blockState);
            EnumFacing sourceDir = this.getSourceDir(coreRadius, connections = this.pollConnections(coreRadius, extendedBlockState));
            if (sourceDir == null) {
                sourceDir = EnumFacing.DOWN;
            }
            int coreDir = this.resolveCoreDir(sourceDir);
            boolean bl = isGrounded = extendedBlockState.getValue(BlockSurfaceRoot.GROUNDED) == Boolean.TRUE;
            if (isGrounded) {
                quadsList.addAll(this.getCores()[coreDir][coreRadius - 1].func_188616_a(blockState, side, rand));
            }
            if (coreRadius != 8) {
                for (EnumFacing connDir : EnumFacing.field_176754_o) {
                    int idx = connDir.func_176736_b();
                    int connRadius = connections[idx];
                    if (connRadius <= 0) continue;
                    if (isGrounded) {
                        quadsList.addAll(this.getSleeves()[idx][connRadius - 1].func_188616_a((IBlockState)extendedBlockState, side, rand));
                    }
                    if (extendedBlockState.getValue(BlockSurfaceRoot.LEVELS[idx]) != BlockSurfaceRoot.ConnectionLevel.HIGH) continue;
                    quadsList.addAll(this.getVerts()[idx][connRadius - 1].func_188616_a((IBlockState)extendedBlockState, side, rand));
                }
            }
        }
        return quadsList;
    }

    protected int[] pollConnections(int coreRadius, IExtendedBlockState extendedBlockState) {
        int[] connections = new int[4];
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int horIndex = dir.func_176736_b();
            int connection = this.getConnectionRadius(extendedBlockState, (IUnlistedProperty<Integer>)BlockSurfaceRoot.CONNECTIONS[horIndex]);
            connections[horIndex] = MathHelper.func_76125_a((int)connection, (int)0, (int)coreRadius);
        }
        return connections;
    }

    protected EnumFacing getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        EnumFacing sourceDir = null;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int horIndex = dir.func_176736_b();
            int connRadius = connections[horIndex];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(EnumFacing dir) {
        return dir.func_176740_k() == EnumFacing.Axis.X ? 1 : 0;
    }

    protected int getRadius(IBlockState blockState) {
        return ((BlockSurfaceRoot)blockState.func_177230_c()).getRadius(blockState);
    }

    protected int getConnectionRadius(IExtendedBlockState iExtendedBlockState, IUnlistedProperty<Integer> whichConnection) {
        Integer connection = (Integer)iExtendedBlockState.getValue(whichConnection);
        return connection != null ? connection : 0;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.barkParticles;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.sleeves[0][0].func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }
}

