/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.blocks;

import com.ferreusveritas.dynamictrees.blocks.BlockRootyWater;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;

public class BlockSwampWaterOverride
extends BlockSwampWater {
    private boolean isUnderwaterBlock = false;

    public BlockSwampWaterOverride(ResourceLocation name) {
        super((Fluid)FluidRegistry.SWAMP_WATER, Material.field_151586_h);
        this.setRegistryName(name);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSwampWater || state.func_177230_c() instanceof BlockRootyWater) {
            return false;
        }
        if (this.displacements.containsKey(state.func_177230_c())) {
            return (Boolean)this.displacements.get(state.func_177230_c());
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWaterOverride.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world == null || !world.func_175667_e(pos)) {
            return false;
        }
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockSwampWater || state.func_177230_c() instanceof BlockRootyWater) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (((Boolean)this.displacements.get(block)).booleanValue()) {
                block.func_176226_b(world, pos, state, 0);
                return true;
            }
            return false;
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWaterOverride.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            block.func_176226_b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    private static boolean isFluid(@Nonnull IBlockState blockstate) {
        return !(!blockstate.func_185904_a().func_76224_d() && !(blockstate.func_177230_c() instanceof IFluidBlock) || blockstate.func_177230_c() instanceof BlockSwampWaterOverride && ((BlockSwampWaterOverride)blockstate.func_177230_c()).isUnderwaterBlock);
    }

    public float getFluidHeightForRender(IBlockAccess world, BlockPos pos, @Nonnull IBlockState up) {
        IBlockState here = world.func_180495_p(pos);
        if (here.func_177230_c() instanceof BlockSwampWater) {
            if (BlockSwampWaterOverride.isFluid(up)) {
                return 1.0f;
            }
            if (((Integer)here.func_177229_b((IProperty)LEVEL)).intValue() == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        if (here.func_177230_c() instanceof BlockRootyWater) {
            if (BlockSwampWaterOverride.isFluid(up)) {
                return 1.0f;
            }
            return 0.875f;
        }
        return !here.func_185904_a().func_76220_a() && (up.func_177230_c() instanceof BlockSwampWater || up.func_177230_c() instanceof BlockRootyWater) ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public Vec3d getFlowVector(IBlockAccess world, BlockPos pos) {
        Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.func_177958_n();
            int z2 = pos.func_177952_p();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            BlockPos pos2 = new BlockPos(x2, pos.func_177956_o(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.func_180495_p(pos2).func_185904_a().func_76230_c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.func_177977_b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.func_178787_e(new Vec3d((double)((pos2.func_177958_n() - pos.func_177958_n()) * power), 0.0, (double)((pos2.func_177952_p() - pos.func_177952_p()) * power)));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.func_178787_e(new Vec3d((double)((pos2.func_177958_n() - pos.func_177958_n()) * power), 0.0, (double)((pos2.func_177952_p() - pos.func_177952_p()) * power)));
        }
        if (!this.isSourceBlock(world, pos) && (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockSwampWater || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockRootyWater)) {
            for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
                if (!this.causesDownwardCurrent(world, pos.func_177972_a(dir), dir) && !this.causesDownwardCurrent(world, pos.func_177972_a(dir).func_177984_a(), dir)) continue;
                vec = vec.func_72432_b().func_178787_e(new Vec3d(0.0, -6.0, 0.0));
                break;
            }
        }
        vec = vec.func_72432_b();
        return vec;
    }

    public int getQuantaValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSwampWaterOverride && ((BlockSwampWaterOverride)state.func_177230_c()).isUnderwaterBlock) {
            return this.quantaPerBlock;
        }
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return 0;
        }
        if (state.func_177230_c() instanceof BlockRootyWater) {
            return this.quantaPerBlock;
        }
        if (!(state.func_177230_c() instanceof BlockSwampWater)) {
            return -1;
        }
        return this.quantaPerBlock - (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    public boolean isSourceBlock(IBlockAccess world, BlockPos pos) {
        return super.isSourceBlock(world, pos);
    }

    protected boolean canFlowInto(IBlockAccess world, BlockPos pos) {
        if (world instanceof World && !((World)world).func_175667_e(pos)) {
            return false;
        }
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSwampWater || state.func_177230_c() instanceof BlockRootyWater) {
            return true;
        }
        if (this.displacements.containsKey(state.func_177230_c())) {
            return (Boolean)this.displacements.get(state.func_177230_c());
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151586_h || material == Material.field_151587_i || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWaterOverride.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.func_180501_a(pos, BlockRegistry.SWAMP_WATER.func_176194_O().func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta)), 3);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int quantaRemaining = this.quantaPerBlock - (Integer)state.func_177229_b((IProperty)LEVEL);
        if (quantaRemaining < this.quantaPerBlock && !world.func_175623_d(pos.func_177977_b())) {
            int adjacentSources = 0;
            if (this.isSourceBlock((IBlockAccess)world, pos.func_177974_f())) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, pos.func_177978_c())) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, pos.func_177968_d())) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, pos.func_177976_e())) {
                ++adjacentSources;
            }
            if (adjacentSources >= 2) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)), 2);
                quantaRemaining = this.quantaPerBlock;
            }
        }
        int expQuanta = -101;
        if (!(state.func_177230_c() instanceof BlockSwampWaterOverride) || !((BlockSwampWaterOverride)state.func_177230_c()).isUnderwaterBlock) {
            if (quantaRemaining < this.quantaPerBlock) {
                if (world.func_180495_p(pos.func_177982_a(0, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(-1, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(1, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(0, -this.densityDir, -1)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(0, -this.densityDir, 1)).func_177230_c() == this) {
                    expQuanta = this.quantaPerBlock - 1;
                } else {
                    int maxQuanta = -100;
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(-1, 0, 0), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(1, 0, 0), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, -1), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, 1), maxQuanta);
                    expQuanta = maxQuanta - 1;
                }
                if (expQuanta != quantaRemaining) {
                    quantaRemaining = expQuanta;
                    if (expQuanta <= 0) {
                        world.func_175698_g(pos);
                    } else {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                        world.func_175684_a(pos, (Block)this, this.tickRate);
                        world.func_175685_c(pos, (Block)this, true);
                    }
                }
            } else {
                world.func_180501_a(pos, this.func_176223_P(), 2);
            }
        }
        if (this.canDisplace((IBlockAccess)world, pos.func_177981_b(this.densityDir))) {
            this.flowIntoBlock(world, pos.func_177981_b(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, pos) || !this.isFlowingVertically((IBlockAccess)world, pos)) {
            boolean[] flowTo;
            if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() instanceof BlockSwampWater || world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() instanceof BlockRootyWater) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                this.flowIntoBlock(world, pos.func_177982_a(-1, 0, 0), flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, pos.func_177982_a(1, 0, 0), flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, pos.func_177982_a(0, 0, -1), flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, pos.func_177982_a(0, 0, 1), flowMeta);
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && (!this.isUnderwaterBlock || worldIn.func_180495_p(pos).func_185904_a() == Material.field_151586_h);
    }
}

