/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.blocks;

import com.ferreusveritas.dynamictrees.blocks.BlockRootyWater;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRootyWaterTBL
extends BlockRootyWater {
    private final BlockFluidBase water;
    protected float quantaFraction = 0.8888889f;
    protected int densityDir = -1;

    public BlockRootyWaterTBL(String name, Block water) {
        super(false, name);
        if (!(water instanceof BlockFluidBase)) {
            throw new IllegalArgumentException();
        }
        this.water = (BlockFluidBase)water;
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess world, BlockPos pos) {
        if (oldState instanceof IExtendedBlockState) {
            IExtendedBlockState state = (IExtendedBlockState)oldState;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                state = state.withProperty((IUnlistedProperty)RENDER_SIDES[dir.ordinal()], (Object)this.func_176225_a((IBlockState)state, world, pos, dir));
            }
            IBlockState[][] upBlockState = new IBlockState[3][3];
            float[][] height = new float[3][3];
            float[][] corner = new float[2][2];
            upBlockState[1][1] = world.func_180495_p(pos.func_177979_c(this.densityDir));
            height[1][1] = this.water.getFluidHeightForRender(world, pos, upBlockState[1][1]);
            if (height[1][1] == 1.0f) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        corner[i][j] = 1.0f;
                    }
                }
            } else {
                int j;
                int i;
                for (i = 0; i < 3; ++i) {
                    for (j = 0; j < 3; ++j) {
                        if (i == 1 && j == 1) continue;
                        BlockPos offsetPos = pos.func_177982_a(i - 1, 0, j - 1);
                        Block offsetBlock = world.func_180495_p(offsetPos).func_177230_c();
                        upBlockState[i][j] = world.func_180495_p(offsetPos.func_177979_c(this.densityDir));
                        height[i][j] = offsetBlock instanceof BlockFluidBase ? ((BlockFluidBase)offsetBlock).getFluidHeightForRender(world, offsetPos, upBlockState[i][j]) : this.water.getFluidHeightForRender(world, offsetPos, upBlockState[i][j]);
                    }
                }
                for (i = 0; i < 2; ++i) {
                    for (j = 0; j < 2; ++j) {
                        corner[i][j] = this.getFluidHeightAverage(height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]);
                    }
                }
                boolean n = BlockRootyWaterTBL.isFluid(upBlockState[0][1]);
                boolean s = BlockRootyWaterTBL.isFluid(upBlockState[2][1]);
                boolean w = BlockRootyWaterTBL.isFluid(upBlockState[1][0]);
                boolean e = BlockRootyWaterTBL.isFluid(upBlockState[1][2]);
                boolean nw = BlockRootyWaterTBL.isFluid(upBlockState[0][0]);
                boolean ne = BlockRootyWaterTBL.isFluid(upBlockState[0][2]);
                boolean sw = BlockRootyWaterTBL.isFluid(upBlockState[2][0]);
                boolean se = BlockRootyWaterTBL.isFluid(upBlockState[2][2]);
                if (nw || n || w) {
                    corner[0][0] = 1.0f;
                }
                if (ne || n || e) {
                    corner[0][1] = 1.0f;
                }
                if (sw || s || w) {
                    corner[1][0] = 1.0f;
                }
                if (se || s || e) {
                    corner[1][1] = 1.0f;
                }
            }
            state = state.withProperty((IUnlistedProperty)CORNER_HEIGHTS[0], (Object)Float.valueOf(corner[0][0]));
            state = state.withProperty((IUnlistedProperty)CORNER_HEIGHTS[1], (Object)Float.valueOf(corner[0][1]));
            state = state.withProperty((IUnlistedProperty)CORNER_HEIGHTS[2], (Object)Float.valueOf(corner[1][1]));
            state = state.withProperty((IUnlistedProperty)CORNER_HEIGHTS[3], (Object)Float.valueOf(corner[1][0]));
            return state;
        }
        return oldState;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= this.quantaFraction) {
                total += flow[i] * 10.0f;
                count += 10;
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        return total / (float)count;
    }

    private static boolean isFluid(@Nonnull IBlockState blockstate) {
        return blockstate.func_185904_a().func_76224_d() || blockstate.func_177230_c() instanceof IFluidBlock;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState newState;
        int y = fromPos.func_177956_o() - pos.func_177956_o();
        if (y < 1 && this.canFlowInto(worldIn, fromPos, newState = worldIn.func_180495_p(fromPos))) {
            newState.func_177230_c().func_176226_b(worldIn, pos, newState, 0);
            worldIn.func_180501_a(fromPos, this.water.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    private boolean canFlowInto(World worldIn, BlockPos pos, IBlockState state) {
        Material material = state.func_185904_a();
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlocked(worldIn, pos, state);
    }

    private boolean isBlocked(World worldIn, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        Material mat = state.func_185904_a();
        if (!(block instanceof BlockDoor) && block != Blocks.field_150472_an && block != Blocks.field_150468_ap && block != Blocks.field_150436_aH) {
            return mat == Material.field_151567_E || mat == Material.field_189963_J || mat.func_76230_c();
        }
        return true;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175656_a(pos, this.water.func_176223_P());
    }

    public IBlockState getMimic(IBlockAccess access, BlockPos pos) {
        return this.water.func_176223_P();
    }

    public IBlockState getDecayBlockState(IBlockAccess access, BlockPos pos) {
        return this.water.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.water.func_185484_c(state, source, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return this.water.getFogColor(world, pos, this.water.func_176223_P(), entity, originalColor, partialTicks);
    }
}

