/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.BoneMealHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyWater;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import maxhyper.dynamictreestbl.blocks.BlockBranchRubber;
import maxhyper.dynamictreestbl.blocks.BlockDynamicRubberTap;
import maxhyper.dynamictreestbl.blocks.BlockLeavesBetweenlands;
import maxhyper.dynamictreestbl.blocks.BlockRootyMud;
import maxhyper.dynamictreestbl.blocks.BlockRootyWaterTBL;
import maxhyper.dynamictreestbl.items.ItemHearthgroveSeed;
import maxhyper.dynamictreestbl.trees.TreeHearthgrove;
import maxhyper.dynamictreestbl.trees.TreeNibbletwig;
import maxhyper.dynamictreestbl.trees.TreeRubber;
import maxhyper.dynamictreestbl.trees.TreeSap;
import maxhyper.dynamictreestbl.worldgen.BiomeDataBasePopulator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.world.WorldProviderBetweenlands;

@Mod.EventBusSubscriber(modid="dynamictreestbl")
@GameRegistry.ObjectHolder(value="dynamictreestbl")
public class ModContent {
    public static BlockDynamicLeaves betweenlandsLeaves;
    public static BlockBranch rubberBranch;
    public static ILeavesProperties rubberLeavesProperties;
    public static ILeavesProperties sapLeavesProperties;
    public static ILeavesProperties hearthgroveLeavesProperties;
    public static ILeavesProperties nibbletwigLeavesProperties;
    public static Block dynamicWeedwoodRubberTap;
    public static Block dynamicSyrmoriteRubberTap;
    public static BlockRootyWater blockRootyWater;
    public static BlockRootyWater blockRootyWaterSwamp;
    public static BlockRootyWater blockRootyWaterStagnant;
    public static BlockRootyMud blockRootyMud;
    public static Seed hearthgroveSeed;
    public static ArrayList<TreeFamily> trees;

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        rubberBranch = new BlockBranchRubber();
        blockRootyWater = new BlockRootyWater(false, "rootywater");
        blockRootyWaterSwamp = new BlockRootyWaterTBL("rootywaterswamp", BlockRegistry.SWAMP_WATER);
        blockRootyWaterStagnant = new BlockRootyWaterTBL("rootywaterstagnant", BlockRegistry.STAGNANT_WATER);
        registry.register((IForgeRegistryEntry)blockRootyWater);
        registry.register((IForgeRegistryEntry)blockRootyWaterSwamp);
        registry.register((IForgeRegistryEntry)blockRootyWaterStagnant);
        blockRootyMud = new BlockRootyMud(false);
        registry.register((IForgeRegistryEntry)blockRootyMud);
        betweenlandsLeaves = new BlockLeavesBetweenlands();
        registry.register((IForgeRegistryEntry)betweenlandsLeaves);
        dynamicWeedwoodRubberTap = new BlockDynamicRubberTap(BlockRegistry.WEEDWOOD_PLANKS.func_176223_P(), 540){

            @Override
            protected ItemStack getBucket(boolean withRubber) {
                return new ItemStack((Item)(withRubber ? ItemRegistry.BL_BUCKET_RUBBER : ItemRegistry.BL_BUCKET), 1, 0);
            }
        };
        dynamicSyrmoriteRubberTap = new BlockDynamicRubberTap(BlockRegistry.SYRMORITE_BLOCK.func_176223_P(), 260){

            @Override
            protected ItemStack getBucket(boolean withRubber) {
                return new ItemStack((Item)(withRubber ? ItemRegistry.BL_BUCKET_RUBBER : ItemRegistry.BL_BUCKET), 1, 1);
            }
        };
        registry.register(dynamicWeedwoodRubberTap.setRegistryName("dynamictreestbl", "dynamic_weedwood_rubber_tap"));
        registry.register(dynamicSyrmoriteRubberTap.setRegistryName("dynamictreestbl", "dynamic_syrmorite_rubber_tap"));
        hearthgroveSeed = new ItemHearthgroveSeed("hearthgroveseed");
        rubberLeavesProperties = ModContent.setUpLeaves(TreeRubber.leavesBlock, "deciduous", 3, 13, true);
        sapLeavesProperties = ModContent.setUpLeaves(TreeSap.leavesBlock, new ResourceLocation("dynamictreestbl", "sapTree").toString(), 3, 13);
        hearthgroveLeavesProperties = ModContent.setUpLeaves(TreeHearthgrove.leavesBlock, "acacia", 4, 13);
        nibbletwigLeavesProperties = ModContent.setUpLeaves(TreeNibbletwig.leavesBlock, "conifer", 4, 13);
        rubberLeavesProperties.setDynamicLeavesState(betweenlandsLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        sapLeavesProperties.setDynamicLeavesState(betweenlandsLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(1)));
        hearthgroveLeavesProperties.setDynamicLeavesState(betweenlandsLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(2)));
        nibbletwigLeavesProperties.setDynamicLeavesState(betweenlandsLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(3)));
        betweenlandsLeaves.setProperties(0, rubberLeavesProperties);
        betweenlandsLeaves.setProperties(1, sapLeavesProperties);
        betweenlandsLeaves.setProperties(2, hearthgroveLeavesProperties);
        betweenlandsLeaves.setProperties(3, nibbletwigLeavesProperties);
        TreeRubber rubberTree = new TreeRubber();
        TreeSap sapTree = new TreeSap();
        TreeHearthgrove hearthgroveTree = new TreeHearthgrove();
        TreeNibbletwig nibbletwigTree = new TreeNibbletwig();
        Collections.addAll(trees, new TreeFamily[]{rubberTree, sapTree, hearthgroveTree, nibbletwigTree});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreestbl").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[0]));
        DirtHelper.registerSoil((Block)BlockRegistry.SWAMP_DIRT, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlockRegistry.PURIFIED_SWAMP_DIRT, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlockRegistry.COARSE_SWAMP_DIRT, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlockRegistry.SWAMP_GRASS, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlockRegistry.DEAD_GRASS, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlockRegistry.SLUDGY_DIRT, (String)"mudlike");
        DirtHelper.registerSoil((Block)BlockRegistry.SPREADING_SLUDGY_DIRT, (String)"mudlike");
        DirtHelper.registerSoil((Block)BlockRegistry.SLUDGY_DIRT, (String)"slimelike");
        DirtHelper.registerSoil((Block)BlockRegistry.SPREADING_SLUDGY_DIRT, (String)"slimelike");
        DirtHelper.registerSoil((Block)BlockRegistry.MUD, (String)"mudlike");
        DirtHelper.registerSoil((Block)BlockRegistry.COMPACTED_MUD, (String)"mudlike");
        DirtHelper.registerSoil((Block)BlockRegistry.SILT, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlockRegistry.SILT, (String)"mudlike");
        DirtHelper.registerSoil((Block)BlockRegistry.SILT, (String)"sandlike");
        DirtHelper.registerSoil((Block)BlockRegistry.PEAT, (String)"mudlike");
        DirtHelper.registerSoil((Block)BlockRegistry.SLIMY_DIRT, (String)"slimelike");
        DirtHelper.registerSoil((Block)BlockRegistry.SLIMY_GRASS, (String)"slimelike");
        DirtHelper.registerSoil((Block)BlockRegistry.SWAMP_WATER, (String)"waterlike");
        DirtHelper.registerSoil((Block)BlockRegistry.STAGNANT_WATER, (String)"waterlike");
        DirtHelper.registerSoil((Block)blockRootyWater, (String)"waterlike");
        DirtHelper.registerSoil((Block)blockRootyWaterSwamp, (String)"waterlike");
        DirtHelper.registerSoil((Block)blockRootyWaterStagnant, (String)"waterlike");
        DirtHelper.registerSoil((Block)blockRootyMud, (String)"dirtlike");
        DirtHelper.registerSoil((Block)blockRootyMud, (String)"mudlike");
    }

    public static ILeavesProperties setUpLeaves(Block leavesBlock, String cellKit, int smother, int light) {
        return ModContent.setUpLeaves(leavesBlock, cellKit, smother, light, false);
    }

    public static ILeavesProperties setUpLeaves(final Block leavesBlock, String cellKit, final int smother, final int light, final boolean foliageColors) {
        LeavesProperties leavesProperties = new LeavesProperties(leavesBlock.func_176223_P(), TreeRegistry.findCellKit((String)cellKit)){

            public int getSmotherLeavesMax() {
                return smother;
            }

            public int getLightRequirement() {
                return light;
            }

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(leavesBlock);
            }

            public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
                if (foliageColors) {
                    return super.foliageColorMultiplier(state, world, pos);
                }
                return 0xFFFFFF;
            }
        };
        return leavesProperties;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[0]));
        BoneMealHelper.replacePredicate((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (w, p, s) -> !(w.field_73011_w instanceof WorldProviderBetweenlands));
        BoneMealHelper.addItem((Item)ItemRegistry.ITEMS_CRUSHED, (int)17);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModContent.setUpSeedRecipes("rubber", new ItemStack(TreeRubber.saplingBlock, 1, 0));
        ModContent.setUpSeedRecipes("sap", new ItemStack(TreeSap.saplingBlock, 1, 0));
        ModContent.setUpSeedRecipes("hearthgrove", new ItemStack(TreeHearthgrove.saplingBlock, 1, 0));
        ModContent.setUpSeedRecipes("nibbletwig", new ItemStack(TreeNibbletwig.saplingBlock, 1, 0));
    }

    private static void setUpSeedRecipes(String name, ItemStack treeSapling) {
        Species treeSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestbl", name));
        ItemStack treeSeed = treeSpecies.getSeedStack(1);
        ItemStack treeTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), treeSpecies.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeSeed, (ItemStack)treeTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)treeSapling, (ItemStack)treeSeed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        LeavesPaging.getLeavesMapForModId((String)"dynamictreestbl").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
        ModelLoader.setCustomStateMapper((Block)blockRootyWater, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRootyWater.LIFE, BlockLiquid.field_176367_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)blockRootyWaterSwamp, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRootyWater.LIFE, BlockLiquid.field_176367_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)blockRootyWaterStagnant, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRootyWater.LIFE, BlockLiquid.field_176367_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)blockRootyMud, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRootyWater.LIFE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)betweenlandsLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a());
    }

    static {
        trees = new ArrayList();
    }
}

