/*
 * Decompiled with CFR 0.152.
 */
package meldexun.blockoverlayfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod(modid="blockoverlayfix")
public class BlockOverlayFix {
    public static final String MODID = "blockoverlayfix";

    public static void renderNearbyBlocks(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.func_70608_bn()) {
            return;
        }
        if (mc.field_71439_g.func_175149_v()) {
            return;
        }
        double error = 0.175;
        double x = mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTicks;
        double y = mc.field_71439_g.field_70137_T + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70137_T) * (double)partialTicks + (double)mc.field_71439_g.func_70047_e();
        double z = mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTicks;
        AxisAlignedBB aabb = new AxisAlignedBB(x - error, y - error, z - error, x + error, y + error, z + error);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        boolean[] startedBuilding = new boolean[1];
        BlockOverlayFix.forEachNearbyPos(x, y, z, error, pos -> {
            IBlockState state = mc.field_71441_e.func_180495_p(pos);
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE) {
                return;
            }
            if (Arrays.stream(EnumFacing.field_82609_l).noneMatch(side -> state.doesSideBlockRendering((IBlockAccess)mc.field_71441_e, pos, side))) {
                return;
            }
            ArrayList aabbs = new ArrayList();
            state.func_177230_c().func_185477_a(state, (World)mc.field_71441_e, pos, aabb, aabbs, (Entity)mc.field_71439_g, true);
            Vec3d vec = new Vec3d(x, y, z);
            if (aabbs.stream().noneMatch(aabb1 -> aabb1.func_186662_g(error).func_72318_a(vec))) {
                return;
            }
            if (!startedBuilding[0]) {
                startedBuilding[0] = true;
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                bufferBuilder.func_178969_c(-x, -(y - (double)mc.field_71439_g.func_70047_e()), -z);
            }
            IBlockState state1 = state.func_185899_b((IBlockAccess)mc.field_71441_e, pos);
            mc.func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)mc.field_71441_e, mc.func_175602_ab().func_184389_a(state1), state1, pos, bufferBuilder, false);
        });
        if (startedBuilding[0]) {
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
            tessellator.func_78381_a();
            bufferBuilder.func_178965_a();
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            if (OpenGlHelper.func_176075_f()) {
                GlStateManager.func_187410_q((int)32884);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                GlStateManager.func_187410_q((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                GlStateManager.func_187410_q((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                GlStateManager.func_187410_q((int)32886);
            }
        }
    }

    private static void forEachNearbyPos(double x, double y, double z, double error, Consumer<BlockPos> action) {
        int bx = MathHelper.func_76128_c((double)x);
        int by = MathHelper.func_76128_c((double)y);
        int bz = MathHelper.func_76128_c((double)z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int used = 0;
        for (int i = 0; i < 8; ++i) {
            double x1 = x + (double)((i >> 1 & 2) - 1) * error;
            double y1 = y + (double)((i & 2) - 1) * error;
            double z1 = z + (double)((i << 1 & 2) - 1) * error;
            pos.func_189532_c(x1, y1, z1);
            int mask = 1 << ((pos.func_177958_n() + 1 - bx) * 3 + (pos.func_177956_o() + 1 - by)) * 3 + (pos.func_177952_p() + 1 - bz);
            if ((used & mask) != 0) continue;
            used |= mask;
            action.accept((BlockPos)pos);
        }
    }
}

