/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.util;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class CollisionUtil {
    public static CollisionUtil instance = new CollisionUtil();
    private final Map<String, Double> stringReference = new ConcurrentHashMap<String, Double>();
    private final Map<Class, Double> collisionMapServer = new ConcurrentHashMap<Class, Double>();
    private final Map<Class, Double> collisionMapClient = new ConcurrentHashMap<Class, Double>();

    public void addToStringReference(Map<String, Double> sent) {
        this.stringReference.putAll(sent);
    }

    public void refreshCollisionMaps() {
        this.collisionMapServer.clear();
        this.collisionMapClient.clear();
    }

    public double getRadiusForEntity(@Nonnull Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            Double dub = this.collisionMapClient.get(entity.getClass());
            if (dub != null) {
                return dub;
            }
            dub = this.stringReference.get(entity.getClass().getName());
            if (dub == null) {
                dub = new Double(World.MAX_ENTITY_RADIUS);
            }
            if (ModConfig.server.minecraft.debug) {
                RLTweaker.logger.debug("Adding " + entity.getClass().getName() + " with radius " + dub + " to client");
            }
            this.collisionMapClient.put(entity.getClass(), Math.min(World.MAX_ENTITY_RADIUS, dub));
            return dub;
        }
        Double dub = this.collisionMapServer.get(entity.getClass());
        if (dub != null) {
            return dub;
        }
        dub = this.stringReference.get(entity.getClass().getName());
        if (dub == null) {
            dub = new Double(World.MAX_ENTITY_RADIUS);
        }
        if (ModConfig.server.minecraft.debug) {
            RLTweaker.logger.debug("Adding " + entity.getClass().getName() + " with radius " + dub + " to server");
        }
        this.collisionMapServer.put(entity.getClass(), Math.min(World.MAX_ENTITY_RADIUS, dub));
        return dub;
    }
}

