/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.handler.MinecraftHandler;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.ReflectUtil;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class RusticHandler {
    public RusticHandler() {
        if (ModConfig.server.rustic.woodHarvestToolFix) {
            this.trySetAxe(new ResourceLocation("rustic", "log"));
            this.trySetAxe(new ResourceLocation("rustic", "planks"));
        }
        RusticContainerValidator validator = new RusticContainerValidator();
        MinecraftHandler.containerValidators.put("rustic.common.tileentity.BrewingBarrel", validator);
        MinecraftHandler.containerValidators.put("rustic.common.tileentity.ContainerCondenser", validator);
        MinecraftHandler.containerValidators.put("rustic.common.tileentity.ContainerCondenserAdvanced", validator);
    }

    private void trySetAxe(ResourceLocation rs) {
        Block block;
        if (Block.field_149771_c.func_148741_d((Object)rs) && (block = (Block)Block.field_149771_c.func_82594_a((Object)rs)).getRegistryName().equals((Object)rs)) {
            RLTweaker.logger.info("Setting block " + rs.toString() + " harvest type to axe");
            block.setHarvestLevel("axe", 0);
        }
    }

    public class RusticContainerValidator
    implements MinecraftHandler.IContainerValidator {
        @Nullable
        private Class c_BrewingBarrel;
        @Nullable
        private Field f_BrewingBarrel_te;
        @Nullable
        private Class c_ContainerCondenser;
        @Nullable
        private Field f_ContainerCondenser_te;
        @Nullable
        private Class c_ContainerCondenserAdvanced;
        @Nullable
        private Field f_ContainerCondenserAdvanced_te;

        public RusticContainerValidator() {
            block2: {
                try {
                    this.c_BrewingBarrel = Class.forName("rustic.common.tileentity.ContainerBrewingBarrel");
                    this.c_ContainerCondenser = Class.forName("rustic.common.tileentity.ContainerCondenser");
                    this.c_ContainerCondenserAdvanced = Class.forName("rustic.common.tileentity.ContainerCondenserAdvanced");
                    this.f_BrewingBarrel_te = ReflectUtil.findField(this.c_BrewingBarrel, "te");
                    this.f_ContainerCondenser_te = ReflectUtil.findField(this.c_ContainerCondenser, "te");
                    this.f_ContainerCondenserAdvanced_te = ReflectUtil.findField(this.c_ContainerCondenserAdvanced, "te");
                }
                catch (Exception e) {
                    if (!ModConfig.server.rustic.validateContainers) break block2;
                    ErrorUtil.logSilent("Rustic Container Validation Reflection");
                }
            }
        }

        @Override
        public boolean isValid(Container container) {
            if (!ModConfig.server.rustic.validateContainers) {
                return true;
            }
            if (this.c_BrewingBarrel != null && this.c_BrewingBarrel.isInstance(container)) {
                return this.handleBrewingBarrel(container);
            }
            if (this.c_ContainerCondenser != null && this.c_ContainerCondenser.isInstance(container)) {
                return this.handleContainerCondenser(container);
            }
            if (this.c_ContainerCondenserAdvanced != null && this.c_ContainerCondenserAdvanced.isInstance(container)) {
                return this.handleContainerCondenserAdvanced(container);
            }
            return true;
        }

        private boolean handleBrewingBarrel(Container container) {
            if (this.f_BrewingBarrel_te == null) {
                return true;
            }
            try {
                TileEntity te = (TileEntity)this.f_BrewingBarrel_te.get(container);
                if (te != null) {
                    return !te.func_145837_r();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ErrorUtil.logSilent("Rustic Container Validation Brewing Barrel Invocation");
            }
            return true;
        }

        private boolean handleContainerCondenser(Container container) {
            if (this.f_ContainerCondenser_te == null) {
                return true;
            }
            try {
                TileEntity te = (TileEntity)this.f_ContainerCondenser_te.get(container);
                if (te != null) {
                    return !te.func_145837_r();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ErrorUtil.logSilent("Rustic Container Validation Condenser Invocation");
            }
            return true;
        }

        private boolean handleContainerCondenserAdvanced(Container container) {
            if (this.f_ContainerCondenserAdvanced_te == null) {
                return true;
            }
            try {
                TileEntity te = (TileEntity)this.f_ContainerCondenserAdvanced_te.get(container);
                if (te != null) {
                    return !te.func_145837_r();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ErrorUtil.logSilent("Rustic Container Validation Condenser Advanced Invocation");
            }
            return true;
        }
    }
}

