/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mods.octarinecore.Utils;
import mods.octarinecore.client.render.BlockData;
import mods.octarinecore.common.Double3;
import mods.octarinecore.common.GeometryKt;
import mods.octarinecore.common.Int3;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\n \u001f*\u0004\u0018\u00010\f0\f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!J\u0016\u0010$\u001a\n \u001f*\u0004\u0018\u00010%0%2\u0006\u0010 \u001a\u00020!J\u001a\u0010&\u001a\u00020'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020'0)J\u000e\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bJ\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0-2\u0006\u0010.\u001a\u00020\b\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00062"}, d2={"Lmods/octarinecore/client/render/BlockContext;", "", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)V", "biomeId", "", "getBiomeId", "()I", "block", "Lnet/minecraft/block/Block;", "getBlock", "()Lnet/minecraft/block/Block;", "blockCenter", "Lmods/octarinecore/common/Double3;", "getBlockCenter", "()Lmods/octarinecore/common/Double3;", "cameraDistance", "getCameraDistance", "chunkBase", "getChunkBase", "getPos", "()Lnet/minecraft/util/math/BlockPos;", "setPos", "(Lnet/minecraft/util/math/BlockPos;)V", "getWorld", "()Lnet/minecraft/world/IBlockAccess;", "setWorld", "(Lnet/minecraft/world/IBlockAccess;)V", "kotlin.jvm.PlatformType", "offset", "Lmods/octarinecore/common/Int3;", "blockData", "Lmods/octarinecore/client/render/BlockData;", "blockState", "Lnet/minecraft/block/state/IBlockState;", "isSurroundedBy", "", "predicate", "Lkotlin/Function1;", "random", "seed", "semiRandomArray", "", "num", "(I)[Ljava/lang/Integer;", "set", "", "BetterFoliage-MC1.12"})
public final class BlockContext {
    @Nullable
    private IBlockAccess world;
    @NotNull
    private BlockPos pos;

    public final void set(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.world = world;
        this.pos = pos;
    }

    @NotNull
    public final Block getBlock() {
        Block block = this.block(Int3.Companion.getZero());
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"block(Int3.zero)");
        return block;
    }

    public final Block block(@NotNull Int3 offset) {
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        IBlockState iBlockState = this.blockState(offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState(offset)");
        return iBlockState.func_177230_c();
    }

    public final IBlockState blockState(@NotNull Int3 offset) {
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        BlockPos blockPos = GeometryKt.plus(this.pos, offset);
        boolean bl = false;
        boolean bl2 = false;
        BlockPos it = blockPos;
        boolean bl3 = false;
        IBlockAccess iBlockAccess = this.world;
        if (iBlockAccess == null) {
            Intrinsics.throwNpe();
        }
        return iBlockAccess.func_180495_p(it);
    }

    @NotNull
    public final BlockData blockData(@NotNull Int3 offset) {
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        BlockPos blockPos = GeometryKt.plus(this.pos, offset);
        boolean bl = false;
        boolean bl2 = false;
        BlockPos pos = blockPos;
        boolean bl3 = false;
        IBlockAccess iBlockAccess = this.world;
        if (iBlockAccess == null) {
            Intrinsics.throwNpe();
        }
        IBlockState iBlockState = iBlockAccess.func_180495_p(pos);
        boolean bl4 = false;
        boolean bl5 = false;
        IBlockState state = iBlockState;
        boolean bl6 = false;
        IBlockState iBlockState2 = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"state");
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        BlockColors blockColors = minecraft.func_184125_al();
        IBlockAccess iBlockAccess2 = this.world;
        if (iBlockAccess2 == null) {
            Intrinsics.throwNpe();
        }
        int n = blockColors.func_186724_a(state, iBlockAccess2, pos, 0);
        Block block = state.func_177230_c();
        IBlockAccess iBlockAccess3 = this.world;
        if (iBlockAccess3 == null) {
            Intrinsics.throwNpe();
        }
        return new BlockData(iBlockState2, n, block.func_185484_c(state, iBlockAccess3, pos));
    }

    public final int getBiomeId() {
        IBlockAccess iBlockAccess = this.world;
        if (iBlockAccess == null) {
            Intrinsics.throwNpe();
        }
        return Biome.func_185362_a((Biome)iBlockAccess.func_180494_b(this.pos));
    }

    @NotNull
    public final Double3 getBlockCenter() {
        return new Double3((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
    }

    @NotNull
    public final Double3 getChunkBase() {
        int cX = this.pos.func_177958_n() >= 0 ? this.pos.func_177958_n() / 16 : (this.pos.func_177958_n() + 1) / 16 - 1;
        int cY = this.pos.func_177956_o() / 16;
        int cZ = this.pos.func_177952_p() >= 0 ? this.pos.func_177952_p() / 16 : (this.pos.func_177952_p() + 1) / 16 - 1;
        return new Double3((double)cX * 16.0, (double)cY * 16.0, (double)cZ * 16.0);
    }

    public final boolean isSurroundedBy(@NotNull Function1<? super IBlockState, Boolean> predicate) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            Iterable $this$all$iv = GeometryKt.getForgeDirOffsets();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Int3 it = (Int3)element$iv;
                    boolean bl2 = false;
                    IBlockState iBlockState = this.blockState(it);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState(it)");
                    if (((Boolean)predicate.invoke((Object)iBlockState)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final int random(int seed) {
        return Utils.semiRandom(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), seed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Integer[] semiRandomArray(int num) {
        Integer[] integerArray = new Integer[num];
        int n = 0;
        while (n < num) {
            void it;
            Integer n2;
            int n3 = n;
            int n4 = n++;
            Integer[] integerArray2 = integerArray;
            boolean bl = false;
            integerArray2[n4] = n2 = Integer.valueOf(this.random((int)it));
        }
        return integerArray;
    }

    public final int getCameraDistance() {
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        Entity entity = minecraft.func_175606_aa();
        if (entity == null) {
            return 0;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"Minecraft.getMinecraft()\u2026derViewEntity ?: return 0");
        Entity camera = entity;
        int n = this.pos.func_177958_n() - MathHelper.func_76128_c((double)camera.field_70165_t);
        boolean bl = false;
        int n2 = Math.abs(n);
        n = this.pos.func_177956_o() - MathHelper.func_76128_c((double)camera.field_70163_u);
        int n3 = n2;
        bl = false;
        int n4 = Math.abs(n);
        n = this.pos.func_177952_p() - MathHelper.func_76128_c((double)camera.field_70161_v);
        n3 += n4;
        bl = false;
        n4 = Math.abs(n);
        return n3 + n4;
    }

    @Nullable
    public final IBlockAccess getWorld() {
        return this.world;
    }

    public final void setWorld(@Nullable IBlockAccess iBlockAccess) {
        this.world = iBlockAccess;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    public final void setPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"<set-?>");
        this.pos = blockPos;
    }

    public BlockContext(@Nullable IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.world = world;
        this.pos = pos;
    }

    public /* synthetic */ BlockContext(IBlockAccess iBlockAccess, BlockPos blockPos, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iBlockAccess = null;
        }
        if ((n & 2) != 0) {
            BlockPos blockPos2 = BlockPos.field_177992_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"BlockPos.ORIGIN");
            blockPos = blockPos2;
        }
        this(iBlockAccess, blockPos);
    }

    public BlockContext() {
        this(null, null, 3, null);
    }
}

