/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.advanced_fishing.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nightkosh.advanced_fishing.core.CatchManager;
import nightkosh.advanced_fishing.core.MaterialManager;
import nightkosh.advanced_fishing.core.ParticlesManager;
import nightkosh.advanced_fishing.entity.item.EntityFireproofItem;
import nightkosh.advanced_fishing.entity.projectile.AbstractFishHook;

public class EntityCustomFishHook
extends AbstractFishHook {
    protected boolean field_146051_au;
    protected int field_146049_av;
    protected int field_146047_aw;
    protected int field_146045_ax;
    protected int field_146040_ay;
    protected int field_146038_az;
    protected float field_146054_aA;

    public EntityCustomFishHook(World world) {
        super(world);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityCustomFishHook(World world, EntityPlayer player, double x, double y, double z) {
        super(world, player, x, y, z);
    }

    public EntityCustomFishHook(World world, EntityPlayer player) {
        super(world, player);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.func_190619_l() == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.func_190625_o()) {
            if (this.field_146051_au) {
                ++this.field_146049_av;
                if (this.field_146049_av >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos pos = new BlockPos((Entity)this);
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            boolean isInLiquid = MaterialManager.MATERIAL_SET.contains(state.func_185904_a());
            if (state.func_185904_a() == Material.field_151587_i && !this.field_70178_ae) {
                this.func_70106_y();
            }
            if (isInLiquid) {
                f = BlockLiquid.func_190973_f((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)pos);
            }
            if (this.field_190627_av == EntityFishHook.State.FLYING) {
                if (this.field_146043_c != null) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_190627_av = EntityFishHook.State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.field_190627_av = EntityFishHook.State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_190624_r();
                }
                if (!(this.field_146051_au || this.field_70122_E || this.field_70123_F)) {
                    ++this.field_146047_aw;
                } else {
                    this.field_146047_aw = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.field_190627_av == EntityFishHook.State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.field_190627_av = EntityFishHook.State.FLYING;
                        } else {
                            this.field_70165_t = this.field_146043_c.field_70165_t;
                            double d2 = this.field_146043_c.field_70131_O;
                            this.field_70163_u = this.field_146043_c.func_174813_aQ().field_72338_b + d2 * 0.8;
                            this.field_70161_v = this.field_146043_c.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.field_190627_av == EntityFishHook.State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)pos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.func_190621_a(pos);
                    }
                }
            }
            if (!isInLiquid) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.func_190623_q();
            this.field_70159_w *= 0.92;
            this.field_70181_x *= 0.92;
            this.field_70179_y *= 0.92;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected boolean func_190625_o() {
        ItemStack mainStack = this.func_190619_l().func_184614_ca();
        ItemStack offStack = this.func_190619_l().func_184592_cb();
        boolean flag = this.isFishingPoleStack(mainStack);
        boolean flag1 = this.isFishingPoleStack(offStack);
        if (!this.func_190619_l().field_70128_L && this.func_190619_l().func_70089_S() && (flag || flag1) && this.func_70068_e((Entity)this.func_190619_l()) <= 1024.0) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    protected void func_190621_a(BlockPos pos) {
        WorldServer worldserver = (WorldServer)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = pos.func_177984_a();
        if ((double)this.field_70146_Z.nextFloat() < 0.25 && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if ((double)this.field_70146_Z.nextFloat() < 0.5 && !this.field_70170_p.func_175678_i(blockpos)) {
            --i;
        }
        if (this.field_146045_ax > 0) {
            --this.field_146045_ax;
            if (this.field_146045_ax <= 0) {
                this.field_146040_ay = 0;
                this.field_146038_az = 0;
            } else {
                this.field_70181_x -= 0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat();
            }
        } else if (this.field_146038_az > 0) {
            this.field_146038_az -= i;
            int minY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            Block liquidBlock = worldserver.func_180495_p(new BlockPos(this.field_70165_t, (double)minY, this.field_70161_v)).func_177230_c();
            if (this.field_146038_az > 0) {
                this.field_146054_aA = (float)((double)this.field_146054_aA + this.field_70146_Z.nextGaussian() * 4.0);
                float angle = this.field_146054_aA * 0.0175f;
                float sin = MathHelper.func_76126_a((float)angle);
                float cos = MathHelper.func_76134_b((float)angle);
                double xPos = this.field_70165_t + (double)(sin * (float)this.field_146038_az) * 0.1;
                double yPos = minY + 1;
                double zPos = this.field_70161_v + (double)(cos * (float)this.field_146038_az) * 0.1;
                if (MaterialManager.MATERIAL_SET.contains(worldserver.func_180495_p(new BlockPos(xPos, (double)minY, zPos)).func_185904_a())) {
                    if ((double)this.field_70146_Z.nextFloat() < 0.15) {
                        ParticlesManager.INSTANCE.getBubbleParticles(liquidBlock).spawn(worldserver, xPos, yPos - 0.1, zPos, 1, sin, 0.1, cos, 0.0);
                    }
                    float zOffset = sin * 0.04f;
                    float xOffset = cos * 0.04f;
                    ParticlesManager.INSTANCE.getWakeParticles(liquidBlock).spawn(worldserver, xPos, yPos, zPos, 0, xOffset, 0.01, -zOffset, 1.0);
                    ParticlesManager.INSTANCE.getWakeParticles(liquidBlock).spawn(worldserver, xPos, yPos, zPos, 0, -xOffset, 0.01, zOffset, 1.0);
                }
            } else {
                this.field_70181_x = -0.4 * (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                ParticlesManager.INSTANCE.getBubbleParticles(liquidBlock).spawn(worldserver, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), this.field_70130_N, 0.0, this.field_70130_N, 0.2);
                ParticlesManager.INSTANCE.getWakeParticles(liquidBlock).spawn(worldserver, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), this.field_70130_N, 0.0, this.field_70130_N, 0.2);
                this.field_146045_ax = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.field_146040_ay > 0) {
            this.field_146040_ay -= i;
            float f5 = 0.15f;
            if (this.field_146040_ay < 20) {
                f5 += (float)(20 - this.field_146040_ay) * 0.05f;
            } else if (this.field_146040_ay < 40) {
                f5 += (float)(40 - this.field_146040_ay) * 0.02f;
            } else if (this.field_146040_ay < 60) {
                f5 += (float)(60 - this.field_146040_ay) * 0.01f;
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                int minY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
                double xPos = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7) * 0.1;
                double yPos = minY + 1;
                double zPos = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7) * 0.1;
                if (MaterialManager.MATERIAL_SET.contains(worldserver.func_180495_p(new BlockPos(xPos, (double)minY, zPos)).func_185904_a())) {
                    ParticlesManager.INSTANCE.getSplashParticles(worldserver.func_180495_p(new BlockPos(this.field_70165_t, (double)minY, this.field_70161_v)).func_177230_c()).spawn(worldserver, this.field_70146_Z, xPos, yPos, zPos);
                }
            }
            if (this.field_146040_ay <= 0) {
                this.field_146054_aA = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.field_146038_az = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.field_146040_ay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.field_146040_ay -= this.field_191519_ax * 20 * 5;
        }
    }

    protected void func_71061_d_() {
        EntityCustomFishHook entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
        float f = entity == this ? 0.2f : 0.9f;
        float f1 = MathHelper.func_76133_a((double)(((Entity)entity).field_70159_w * ((Entity)entity).field_70159_w * 0.2 + ((Entity)entity).field_70181_x * ((Entity)entity).field_70181_x + ((Entity)entity).field_70179_y * ((Entity)entity).field_70179_y * 0.2)) * f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        this.func_184185_a(this.func_184181_aa(), f1, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        if (!this.field_70170_p.field_72995_K) {
            float minY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            Block liquidBlock = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, (double)minY, this.field_70161_v)).func_177230_c();
            int i = 0;
            while ((float)i < 1.0f + this.field_70130_N * 20.0f) {
                float f3 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                float f4 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                ParticlesManager.INSTANCE.getBubbleParticles(liquidBlock).spawn((WorldServer)this.field_70170_p, this.field_70165_t + (double)f3, minY + 1.0f, this.field_70161_v + (double)f4, 1, this.field_70159_w, this.field_70181_x - (double)(this.field_70146_Z.nextFloat() * 0.2f), this.field_70179_y, 0.0);
                ++i;
            }
            int j = 0;
            while ((float)j < 1.0f + this.field_70130_N * 20.0f) {
                float f5 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                float f6 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                ParticlesManager.INSTANCE.getSplashParticles(liquidBlock).spawn((WorldServer)this.field_70170_p, this.field_70146_Z, this.field_70165_t + (double)f5, minY + 1.0f, this.field_70161_v + (double)f6);
                ++j;
            }
        }
    }

    public int func_146034_e() {
        if (!this.field_70170_p.field_72995_K && this.func_190619_l() != null) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.field_146043_c != null) {
                this.func_184527_k();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.field_146043_c instanceof EntityItem ? 3 : 5;
            } else if (this.field_146045_ax > 0) {
                List<ItemStack> result = this.getCatch();
                event = new ItemFishedEvent(result, this.field_146051_au ? 2 : 1, (EntityFishHook)this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.func_70106_y();
                    return event.getRodDamage();
                }
                for (ItemStack stack : result) {
                    EntityItem entityitem = this.getCatchEntityItem(stack);
                    double d0 = this.func_190619_l().field_70165_t - this.field_70165_t;
                    double d1 = this.func_190619_l().field_70163_u - this.field_70163_u;
                    double d2 = this.func_190619_l().field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    entityitem.field_70159_w = d0 * 0.1;
                    entityitem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityitem.field_70179_y = d2 * 0.1;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                    this.func_190619_l().field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.func_190619_l().field_70170_p, this.func_190619_l().field_70165_t, this.func_190619_l().field_70163_u + 0.5, this.func_190619_l().field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    Item item = stack.func_77973_b();
                    if (item != Items.field_151115_aP && item != Items.field_179566_aV && item != nightkosh.advanced_fishing.core.Items.FISH) continue;
                    this.func_190619_l().func_71064_a(StatList.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.field_146051_au) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    protected EntityItem getCatchEntityItem(ItemStack stack) {
        return new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, stack);
    }

    protected EntityItem getFireproofCatchEntityItem(ItemStack stack) {
        return new EntityFireproofItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, stack);
    }

    protected List<ItemStack> getCatch() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(1);
        Block liquidBlock = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v)).func_177230_c();
        List<ItemStack> tempList = CatchManager.INSTANCE.getCatch(liquidBlock).getCatch(this.field_70170_p, this.func_180425_c(), ((float)this.field_191518_aw + this.func_190619_l().func_184817_da()) * 1.5f);
        result.add(tempList.get(this.field_70146_Z.nextInt(tempList.size())));
        return result;
    }
}

