/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.advanced_fishing.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import nightkosh.advanced_fishing.api.fishing_catch.ICatch;
import nightkosh.advanced_fishing.api.fishing_catch.ICatchManager;
import nightkosh.advanced_fishing.api.fishing_catch.IWaterCatch;
import nightkosh.advanced_fishing.api.fishing_catch.IWaterCondition;
import nightkosh.advanced_fishing.core.Config;
import nightkosh.advanced_fishing.core.LootTables;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CatchManager
implements ICatchManager {
    public static final CatchManager INSTANCE = new CatchManager();
    private static final Logger LOGGER = LogManager.getLogger((String)"advanced-fishing");
    private static final Map<Block, ICatch> CATCH = new HashMap<Block, ICatch>();
    private static final Map<IWaterCondition, IWaterCatch> CATCH_WATER = new HashMap<IWaterCondition, IWaterCatch>();

    @Override
    public void addCatch(Block block, ICatch fishingCatch) {
        CATCH.put(block, fishingCatch);
    }

    @Override
    public void addWaterCatch(IWaterCondition condition, IWaterCatch waterCatch) {
        CATCH_WATER.put(condition, waterCatch);
    }

    @Override
    public ICatch getCatch(Block block) {
        if (Config.debugMode) {
            LOGGER.log(Level.INFO, "Fishing in : " + block.toString());
        }
        return CATCH.getOrDefault(block, CatchManager::getWaterCatch);
    }

    public static List<ItemStack> getWaterCatch(World world, BlockPos pos, float luck) {
        int chance = world.field_73012_v.nextInt(100) + Math.round(luck);
        if (chance < 10) {
            if (Config.debugMode) {
                LOGGER.log(Level.INFO, "junk");
            }
            return CatchManager.getCatch(world, LootTableList.field_186388_am, luck);
        }
        if (chance < 90) {
            List<ItemStack> list = new ArrayList<ItemStack>();
            if (!world.func_175710_j(pos) && (chance = world.field_73012_v.nextInt(100) + Math.round(luck)) >= 95) {
                if (Config.debugMode) {
                    LOGGER.log(Level.INFO, "Fishing in cave.");
                }
                if (pos.func_177956_o() < 50) {
                    list.addAll(CatchManager.getCatch(world, LootTables.FISHING_CAVE_50, luck));
                    if (Config.debugMode) {
                        LOGGER.log(Level.INFO, "< 50");
                    }
                    if (pos.func_177956_o() < 40) {
                        list.addAll(CatchManager.getCatch(world, LootTables.FISHING_CAVE_40, luck));
                        if (Config.debugMode) {
                            LOGGER.log(Level.INFO, "< 40");
                        }
                        if (pos.func_177956_o() < 25) {
                            list.addAll(CatchManager.getCatch(world, LootTables.FISHING_CAVE_25, luck));
                            if (Config.debugMode) {
                                LOGGER.log(Level.INFO, "< 25");
                            }
                        }
                    }
                }
            }
            if (list.isEmpty()) {
                Biome biome = world.func_180494_b(pos);
                Set biomeTypesList = BiomeDictionary.getTypes((Biome)biome);
                if (Config.debugMode) {
                    LOGGER.log(Level.INFO, biome.func_185359_l());
                    LOGGER.log(Level.INFO, biomeTypesList.toString());
                }
                for (IWaterCondition condition : CATCH_WATER.keySet()) {
                    if (!condition.shouldGetCatch(world, pos, biome, biomeTypesList, luck)) continue;
                    list = CATCH_WATER.get(condition).getCatch(world, pos, biome, biomeTypesList, luck);
                    break;
                }
                if (list.isEmpty()) {
                    list = CatchManager.getCatch(world, LootTables.FISHING, luck);
                    if (Config.debugMode) {
                        LOGGER.log(Level.INFO, "No catch! Trying to get default catch.");
                    }
                }
            }
            return list;
        }
        if (Config.debugMode) {
            LOGGER.log(Level.INFO, "treasure");
        }
        return CatchManager.getCatch(world, LootTableList.field_186389_an, luck);
    }

    public static boolean getOceanCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.OCEAN);
    }

    public static boolean getBeachCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.BEACH);
    }

    public static boolean getEndCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.END);
    }

    public static boolean getSandyCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.MESA) || biomeTypesList.contains(BiomeDictionary.Type.SAVANNA);
    }

    public static boolean getSnowyCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.SNOWY) || biomeTypesList.contains(BiomeDictionary.Type.CONIFEROUS);
    }

    public static boolean getSwampCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.SWAMP);
    }

    public static boolean getJungleCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.JUNGLE);
    }

    public static boolean getMushroomCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM);
    }

    public static boolean getDeadCondition(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return biomeTypesList.contains(BiomeDictionary.Type.DEAD);
    }

    public static List<ItemStack> getOceanCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        if (biome == Biomes.field_150575_M) {
            return CatchManager.getCatch(world, LootTables.FISHING_OCEAN_DEEP, luck);
        }
        return CatchManager.getCatch(world, LootTables.FISHING_OCEAN, luck);
    }

    public static List<ItemStack> getBeachCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return CatchManager.getCatch(world, LootTables.FISHING_OCEAN, luck);
    }

    public static List<ItemStack> getEndCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return CatchManager.getCatch(world, LootTables.FISHING_END, luck);
    }

    public static List<ItemStack> getSandyCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return CatchManager.getCatch(world, LootTables.FISHING_SANDY, luck);
    }

    public static List<ItemStack> getSnowyCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return CatchManager.getCatch(world, LootTables.FISHING_SNOWY, luck);
    }

    public static List<ItemStack> getSwampCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return CatchManager.getCatch(world, LootTables.FISHING_SWAMP, luck);
    }

    public static List<ItemStack> getJungleCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return CatchManager.getCatch(world, LootTables.FISHING_JUNGLE, luck);
    }

    public static List<ItemStack> getMushroomCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return CatchManager.getCatch(world, LootTables.FISHING_MUSHROOM, luck);
    }

    public static List<ItemStack> getDeadCatch(World world, BlockPos pos, Biome biome, Set<BiomeDictionary.Type> biomeTypesList, float luck) {
        return CatchManager.getCatch(world, LootTables.FISHING_DEAD, luck);
    }

    public static List<ItemStack> getLavaCatch(World world, BlockPos pos, float luck) {
        Biome biome = world.func_180494_b(pos);
        Set biomeTypesList = BiomeDictionary.getTypes((Biome)biome);
        if (Config.debugMode) {
            LOGGER.log(Level.INFO, biome.func_185359_l());
            LOGGER.log(Level.INFO, biomeTypesList.toString());
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            int chance = world.field_73012_v.nextInt(100) + Math.round(luck);
            if (chance < 95) {
                return CatchManager.getCatch(world, LootTables.FISHING_LAVA_NETHER, luck);
            }
            return CatchManager.getCatch(world, LootTables.FISHING_LAVA_NETHER_TREASURE, luck);
        }
        return CatchManager.getCatch(world, LootTables.FISHING_LAVA, luck);
    }

    public static List<ItemStack> getCatch(World world, ResourceLocation lootTable, float luck) {
        LootContext.Builder lootContextBuilder = new LootContext.Builder((WorldServer)world);
        lootContextBuilder.func_186469_a(luck);
        return world.func_184146_ak().func_186521_a(lootTable).func_186462_a(world.field_73012_v, lootContextBuilder.func_186471_a());
    }

    static {
        CATCH.put((Block)Blocks.field_150355_j, CatchManager::getWaterCatch);
        CATCH.put((Block)Blocks.field_150358_i, CatchManager::getWaterCatch);
        CATCH.put((Block)Blocks.field_150353_l, CatchManager::getLavaCatch);
        CATCH.put((Block)Blocks.field_150356_k, CatchManager::getLavaCatch);
        CATCH_WATER.put(CatchManager::getOceanCondition, CatchManager::getOceanCatch);
        CATCH_WATER.put(CatchManager::getBeachCondition, CatchManager::getBeachCatch);
        CATCH_WATER.put(CatchManager::getEndCondition, CatchManager::getEndCatch);
        CATCH_WATER.put(CatchManager::getSandyCondition, CatchManager::getSandyCatch);
        CATCH_WATER.put(CatchManager::getSnowyCondition, CatchManager::getSnowyCatch);
        CATCH_WATER.put(CatchManager::getSwampCondition, CatchManager::getSwampCatch);
        CATCH_WATER.put(CatchManager::getJungleCondition, CatchManager::getJungleCatch);
        CATCH_WATER.put(CatchManager::getMushroomCondition, CatchManager::getMushroomCatch);
        CATCH_WATER.put(CatchManager::getDeadCondition, CatchManager::getDeadCatch);
    }
}

