/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import svenhjol.meson.helper.WorldHelper;

public class EntityHelper {
    public static Biome[] getBiomesWithMob(Class<? extends Entity> clazz) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        block0: for (Biome b : Biome.field_185377_q) {
            List spawnList = b.func_76747_a(EnumCreatureType.MONSTER);
            for (Biome.SpawnListEntry e : spawnList) {
                if (e.field_76300_b != clazz) continue;
                biomes.add(b);
                continue block0;
            }
        }
        return biomes.toArray(new Biome[0]);
    }

    public static boolean canMobsSpawnInPos(World world, BlockPos pos) {
        if (world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && !world.func_175677_d(pos, false) && !world.func_175677_d(pos.func_177984_a(), false) && !world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            IBlockState state = world.func_180495_p(pos);
            int lightLevel = world.func_175642_b(EnumSkyBlock.BLOCK, pos);
            return lightLevel < 8 && (world.func_175623_d(pos) || state.func_185890_d((IBlockAccess)world, pos) == null);
        }
        return false;
    }

    public static boolean itemHasEntityTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("EntityTag") && tag.func_74775_l("EntityTag").func_74764_b("id");
    }

    public static void spawnEntityFromItem(ItemStack stack, World world, BlockPos pos) {
        Entity entityFromId;
        Entity entity;
        if (world.field_72995_K) {
            return;
        }
        if (!EntityHelper.itemHasEntityTag(stack)) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        String s = tag.func_74775_l("EntityTag").func_74779_i("id");
        ResourceLocation id = new ResourceLocation(s);
        if (EntityList.field_75627_a.containsKey(id) && (entity = EntityHelper.spawnEntity(entityFromId = EntityList.func_188429_b((ResourceLocation)id, (World)world), world, pos)) instanceof EntityLivingBase && stack.func_82837_s()) {
            entity.func_96094_a(stack.func_82833_r());
        }
    }

    public static void spawnEntityItem(World world, BlockPos pos, ItemStack stack) {
        EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        item.func_70012_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), 0.0f, 0.0f);
        world.func_72838_d((Entity)item);
    }

    public static void spawnEntityNearPlayer(EntityPlayer player, int range, ResourceLocation entityName) {
        EntityHelper.spawnEntityNearPlayer(player, 0, range, entityName);
    }

    public static void spawnEntityNearPlayer(EntityPlayer player, int minDistance, int range, ResourceLocation entityName) {
        World world = player.field_70170_p;
        Entity entity = EntityList.func_188429_b((ResourceLocation)entityName, (World)world);
        if (entity instanceof EntityLiving) {
            ArrayList shuffled = new ArrayList();
            Iterable positions = BlockPos.func_177980_a((BlockPos)player.func_180425_c().func_177982_a(-range, -range, -range), (BlockPos)player.func_180425_c().func_177982_a(range, range, range));
            positions.forEach(shuffled::add);
            Collections.shuffle(shuffled);
            for (BlockPos p : shuffled) {
                if (!(WorldHelper.getDistanceSq(player.func_180425_c(), p) > (double)minDistance) || !EntityHelper.canMobsSpawnInPos(world, p)) continue;
                EntityHelper.spawnEntity(entity, world, new BlockPos((double)((float)p.func_177958_n() + 0.5f), (double)p.func_177956_o(), (double)((float)p.func_177952_p() + 0.5f)));
                break;
            }
        }
    }

    @Nullable
    public static Entity spawnEntity(Entity entity, World world, BlockPos pos) {
        if (entity == null) {
            return null;
        }
        entity.func_70012_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            living.field_70759_as = living.field_70177_z;
            living.field_70761_aq = living.field_70177_z;
            living.func_180482_a(world.func_175649_E(new BlockPos((Entity)living)), null);
            world.func_72838_d((Entity)living);
            living.func_70642_aH();
            return living;
        }
        world.func_72838_d(entity);
        return entity;
    }

    public static Entity spawnEntity(ResourceLocation name, World world, BlockPos pos) {
        Entity entity = EntityList.func_188429_b((ResourceLocation)name, (World)world);
        if (entity == null) {
            return null;
        }
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        return EntityHelper.spawnEntity(entity, world, new BlockPos(x, y, z));
    }

    public static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        WorldProvider pOld = oldWorld.field_73011_w;
        WorldProvider pNew = newWorld.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double x = entity.field_70165_t * moveFactor;
        double z = entity.field_70161_v * moveFactor;
        oldWorld.field_72984_F.func_76320_a("placing");
        x = MathHelper.func_151237_a((double)x, (double)-2.9999872E7, (double)2.9999872E7);
        z = MathHelper.func_151237_a((double)z, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(x, entity.field_70163_u, z, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        oldWorld.field_72984_F.func_76319_b();
        entity.func_70029_a((World)newWorld);
    }
}

