/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.handlers;

import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import rlmixins.RLMixins;

@Config(modid="rlmixins")
public class ForgeConfigHandler {
    private static List<String> netherBaneMobs;
    private static List<String> netherBaneWeapons;
    @Config.Comment(value={"Additional Server-Side Options"})
    @Config.Name(value="Server Options")
    public static final ServerConfig server;
    @Config.Comment(value={"Additional Client-Side Options"})
    @Config.Name(value="Client Options")
    public static final ClientConfig client;
    @Config.Comment(value={"Enable/Disable Tweaks and Patches"})
    @Config.Name(value="Toggle Mixins")
    public static final MixinConfig mixinConfig;
    private static File configFile;
    private static String configBooleanString;

    public static List<String> getNetherBaneMobs() {
        if (netherBaneMobs == null) {
            netherBaneMobs = Arrays.asList(ForgeConfigHandler.server.netherBaneMobs);
        }
        return netherBaneMobs;
    }

    public static List<String> getNetherBaneWeapons() {
        if (netherBaneWeapons == null) {
            netherBaneWeapons = Arrays.asList(ForgeConfigHandler.server.netherBaneWeapons);
        }
        return netherBaneWeapons;
    }

    public static boolean getBoolean(String name) {
        if (configFile == null && (configFile = new File("config", "rlmixins.cfg")).exists() && configFile.isFile()) {
            try (Stream<String> stream = Files.lines(configFile.toPath());){
                configBooleanString = stream.filter(s -> s.trim().startsWith("B:")).collect(Collectors.joining());
            }
            catch (Exception ex) {
                RLMixins.LOGGER.log(Level.ERROR, "Failed to parse RLMixins config: " + ex);
            }
        }
        return configBooleanString.contains("B:\"" + name + "\"=true");
    }

    static {
        server = new ServerConfig();
        client = new ClientConfig();
        mixinConfig = new MixinConfig();
        configBooleanString = "";
    }

    @Mod.EventBusSubscriber(modid="rlmixins")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("rlmixins")) {
                netherBaneMobs = null;
                netherBaneWeapons = null;
                ConfigManager.sync((String)"rlmixins", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ClientConfig {
        @Config.Comment(value={"Requires Spooky Dragons Mixin to be enabled"})
        @Config.Name(value="Spooky Dragons")
        public boolean spookyDragons = false;
    }

    public static class ServerConfig {
        @Config.Comment(value={"Item Blacklist for the Hungry Farmer trait."})
        @Config.Name(value="Hungry Farmer Blacklist")
        public String[] hungryFarmerBlacklist = new String[]{""};
        @Config.Comment(value={"Potion Blacklist for Tipped Arrows."})
        @Config.Name(value="Tipped Arrow Blacklist")
        public String[] tippedArrowBlacklist = new String[]{""};
        @Config.Comment(value={"Percentage of Flame particles to ignore for Fire Dragon explosions"})
        @Config.Name(value="Fire Dragon Explosion Flame Percent")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double fireDragonExplosionFlame = 0.9;
        @Config.Comment(value={"Percentage of Snow particles to ignore for Ice Dragon explosions"})
        @Config.Name(value="Ice Dragon Explosion Snow Percent")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double iceDragonExplosionSnow = 0.8;
        @Config.Comment(value={"Percentage of Smoke particles to ignore for Fire Dragon explosions"})
        @Config.Name(value="Fire Dragon Explosion Smoke Percent")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double fireDragonExplosionSmoke = 0.95;
        @Config.Comment(value={"Percentage of Smoke particles to ignore for Ice Dragon explosions"})
        @Config.Name(value="Ice Dragon Explosion Smoke Percent")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double iceDragonExplosionSmoke = 0.95;
        @Config.Comment(value={"How many blocks to reduce fall distance by per tick in water"})
        @Config.Name(value="Fall Distance Reduction in Water")
        @Config.RangeDouble(min=1.0, max=100.0)
        public double fallDistanceReduction = 4.0;
        @Config.Comment(value={"Effect that drinking Ale should give"})
        @Config.Name(value="Ale Effect")
        public String aleEffect = "lycanitesmobs:immunization";
        @Config.Comment(value={"Effect that drinking Cider should give"})
        @Config.Name(value="Cider Effect")
        public String ciderEffect = "potioncore:magic_shield";
        @Config.Comment(value={"Effect that drinking Mead should give"})
        @Config.Name(value="Mead Effect")
        public String meadEffect = "lycanitesmobs:rejuvenation";
        @Config.Comment(value={"Register the Encumbered potion effect (Requires PotionCore)"})
        @Config.Name(value="Register Encumbered")
        @Config.RequiresMcRestart
        public boolean registerEncumbered = false;
        @Config.Comment(value={"Add and register Steel armor with custom models"})
        @Config.Name(value="Register Steel Armor")
        @Config.RequiresMcRestart
        public boolean registerSteelArmor = false;
        @Config.Comment(value={"Add and register Scarlite armor with custom models"})
        @Config.Name(value="Register Scarlite Armor")
        @Config.RequiresMcRestart
        public boolean registerScarliteArmor = false;
        @Config.Comment(value={"Add and register Cleansing Talisman, a recipe for crafting a Curse Break book, and the Curse Break potion"})
        @Config.Name(value="Register Cleansing Talisman (Charm)")
        @Config.RequiresMcRestart
        public boolean registerCleansingTalisman = false;
        @Config.Comment(value={"Register the Lesser Fire Resistance potion effect"})
        @Config.Name(value="Register Lesser Fire Resistance")
        @Config.RequiresMcRestart
        public boolean registerLesserFireResistance = false;
        @Config.Comment(value={"Enables the Nether Bane weapon effect to deal bonus damage to nether mobs"})
        @Config.Name(value="Enable Nether Bane (Requires RLCombat)")
        @Config.RequiresMcRestart
        public boolean enableNetherBane = false;
        @Config.Comment(value={"List of mobs to be classed as nether-mobs for the Nether Bane effect"})
        @Config.Name(value="Nether Bane Mob List")
        public String[] netherBaneMobs = new String[]{"minecraft:wither_skeleton", "minecraft:zombie_pigman", "minecraft:blaze", "minecraft:magma_cube", "minecraft:wither"};
        @Config.Comment(value={"List of weapons to have the Nether Bane effect"})
        @Config.Name(value="Nether Bane Weapon List")
        public String[] netherBaneWeapons = new String[]{""};
        @Config.Comment(value={"If true, Nether Bane effect will multiply damage, if false, additive"})
        @Config.Name(value="Nether Bane Multiply/Add")
        public boolean netherBaneMultiply = false;
        @Config.Comment(value={"Value to either multiply damage by or add to damage for the Nether Bane effect"})
        @Config.Name(value="Nether Bane Damage Value")
        public double netherBaneValue = 4.0;
        @Config.Comment(value={"If true, Cobalt Shield will cancel knockback events, instead of only applying an attribute"})
        @Config.Name(value="Cobalt Shield Cancels Knockback (Bountiful Bauble)")
        @Config.RequiresMcRestart
        public boolean cobaltShieldCancelsKnockback = false;
        @Config.Comment(value={"Fixes squid and cow milking cooldowns"})
        @Config.Name(value="Milking Cooldown Fix (Inspirations)")
        @Config.RequiresMcRestart
        public boolean milkingFix = false;
        @Config.Comment(value={"Registers the Cow Potion effect"})
        @Config.Name(value="Register Cow Potion")
        @Config.RequiresMcRestart
        public boolean registerCowPotion = false;
        @Config.Comment(value={"Maximum Modifier for Nunchaku (Damage * (1+this))"})
        @Config.Name(value="Nunchaku Combo Max Modifier")
        public float nunchakuComboMaxModifier = 1.0f;
        @Config.Comment(value={"Makes the Ice/Fire blood recipes retain enchantments and repair cost, optional compatibility for BetterSurvival (Except for Spear) and SpartanFire (You will still need to remove the original recipes with CraftTweaker.)"})
        @Config.Name(value="Register Enchantment Sensitive Flame/Ice Weapon Recipes (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean registerEnchantmentSensitiveFlameIceWeapon = false;
        @Config.Comment(value={"Makes Advanced Mending incompatible with Infinity (Requires SME Overhaul Mixin)"})
        @Config.Name(value="Advanced Mending Infinity Restriction")
        @Config.RequiresMcRestart
        public boolean advMendingInfinityRestrict = true;
        @Config.Comment(value={"Makes Advanced Mending prioritize damaged items first (Requires SME Overhaul Mixin)"})
        @Config.Name(value="Advanced Mending Damaged Priority")
        @Config.RequiresMcRestart
        public boolean advMendingDamagedPriority = true;
        @Config.Comment(value={"Effect given by Scarlite Sword when hitting an entity."})
        @Config.Name(value="Scarlite Sword Effect")
        public String scarliteSwordEffect = "lycanitesmobs:leech";
        @Config.Comment(value={"Duration of effect given by Scarlite Sword when hitting an entity"})
        @Config.Name(value="Scarlite Sword Effect Duration")
        @Config.RangeInt(min=1, max=1200)
        public int scarliteSwordDuration = 20;
        @Config.Comment(value={"Amplifier of effect given by Scarlite Sword when hitting an entity"})
        @Config.Name(value="Scarlite Sword Effect Amplifier")
        @Config.RangeInt(min=0, max=10)
        public int scarliteSwordAmplifier = 1;
        @Config.Comment(value={"Effect given by Parasite Cleaver when hitting an entity."})
        @Config.Name(value="Parasite Cleaver Effect")
        public String parasiteCleaverEffect = "potioncore:vulnerable";
        @Config.Comment(value={"Amplifier given by Living Cleaver when hitting an entity."})
        @Config.Name(value="Living Cleaver Amplifier")
        @Config.RangeInt(min=0, max=10)
        public int livingCleaverAmplifier = 0;
        @Config.Comment(value={"Amplifier given by Sentient Cleaver when hitting an entity."})
        @Config.Name(value="Sentient Cleaver Amplifier")
        @Config.RangeInt(min=0, max=10)
        public int sentientCleaverAmplifier = 1;
    }

    public static class MixinConfig {
        @Config.Comment(value={"MC-119971 patch, created by EigenCraft Unofficial Patch"})
        @Config.Name(value="Outdated Chunk Data (Vanilla)")
        @Config.RequiresMcRestart
        public boolean outdatedChunkData = false;
        @Config.Comment(value={"Force Thorn and Arthropod enchantment methods to check for offhand packets, as well as Fire Aspect and Knockback with SME compat."})
        @Config.Name(value="Offhand Enchants (Vanilla/RLCombat)")
        @Config.RequiresMcRestart
        public boolean arthropodOffhandSensitivity = false;
        @Config.Comment(value={"Disallow Infernal/Blight/Champion mobs from entering Minecarts and Boats (Does not require all mods to be loaded.)"})
        @Config.Name(value="Boss Cart/Boat Cheese (Vanilla/InfernalMobs/ScalingHealth/Champions)")
        @Config.RequiresMcRestart
        public boolean bossCartCheesePatch = false;
        @Config.Comment(value={"Force EntityLivingBase#attemptTeleport to cancel under the effects of AntiWarp"})
        @Config.Name(value="AntiWarp Handling (Vanilla/BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean antiwarpImprovement = false;
        @Config.Comment(value={"Makes fall distance reduction per tick in water configurable"})
        @Config.Name(value="Configurable Fall (Vanilla)")
        @Config.RequiresMcRestart
        public boolean configurableFallDistance = false;
        @Config.Comment(value={"Lower the player's eye height while crouching to be more like newer versions"})
        @Config.Name(value="Lowered Crouch (Vanilla)")
        @Config.RequiresMcRestart
        public boolean lowerEyeHeight = false;
        @Config.Comment(value={"Patches issues with player health attributes being lowered between packets causing desynced death"})
        @Config.Name(value="Health Desync Patch (Vanilla)")
        @Config.RequiresMcRestart
        public boolean healthAttributePatch = false;
        @Config.Comment(value={"Smooth eye height when crouching, created by RandomPatches"})
        @Config.Name(value="Smoothed Crouching (Vanilla)")
        @Config.RequiresMcRestart
        public boolean smoothCrouch = false;
        @Config.Comment(value={"Force Mending to prioritize damaged items first, instead of randomly picking"})
        @Config.Name(value="Mending Priorities (Vanilla)")
        @Config.RequiresMcRestart
        public boolean mendingPriorities = false;
        @Config.Comment(value={"Makes Chunk Animator stop animating around the player temporarily when using F3+A or changing render distance, to stop easy xray"})
        @Config.Name(value="ChunkAnimator XRay (Vanilla/ChunkAnimator)")
        @Config.RequiresMcRestart
        public boolean chunkAnimatorXRay = false;
        @Config.Comment(value={"Stops Anvils from displaying \"Too Expensive\" for compatibility with AnvilPatchLawful"})
        @Config.Name(value="Anvil Too Expensive (Vanilla/AnvilPatch)")
        @Config.RequiresMcRestart
        public boolean anvilTooExpensiveFix = false;
        @Config.Comment(value={"Directly modify Item attributes for certain SoManyEnchantments Enchantments"})
        @Config.Name(value="Enchantment Item Attributes (Vanilla/SME)")
        @Config.RequiresMcRestart
        public boolean enchantmentsModifyItemAttributes = false;
        @Config.Comment(value={"Directly modify ItemStack damage for certain SoManyEnchantments Enchantments"})
        @Config.Name(value="Enchantment ItemStack Damage (Vanilla/SME)")
        @Config.RequiresMcRestart
        public boolean enchantmentsModifyItemStackDamage = false;
        @Config.Comment(value={"MC-92916 patch, created by EigenCraft Unofficial Patch"})
        @Config.Name(value="Entity Tracker Desync (Vanilla)")
        @Config.RequiresMcRestart
        public boolean entityTrackerDesyncPatch = false;
        @Config.Comment(value={"Fixes certain particles sent to the client from serverside never actually rendering, created by RandomPatches"})
        @Config.Name(value="Missing Particle Rendering (Vanilla)")
        @Config.RequiresMcRestart
        public boolean particleRenderPatch = false;
        @Config.Comment(value={"MC-108469 patch, created by EigenCraft Unofficial Patch"})
        @Config.Name(value="Chunk Entity List (Vanilla)")
        @Config.RequiresMcRestart
        public boolean chunkEntityListUpdate = false;
        @Config.Comment(value={"Overhaul a bunch of SoManyEnchantments Enchantment handlers to fix lag/bugs/offhand issues"})
        @Config.Name(value="Overhaul SME (Vanilla/SME/RLCombat)")
        @Config.RequiresMcRestart
        public boolean overhaulEnchants = false;
        @Config.Comment(value={"Force gathering rain into a canteen to give purified water instead of dirty water"})
        @Config.Name(value="Purified Rain Water (SimpleDifficulty)")
        @Config.RequiresMcRestart
        public boolean purifyRainWater = false;
        @Config.Comment(value={"Makes Coffee from Charm reduce the effects of Inebriation from Rustic instead of water"})
        @Config.Name(value="Coffee Cures Hangover (Rustic/Charm)")
        @Config.RequiresMcRestart
        public boolean coffeeInebriation = false;
        @Config.Comment(value={"Replace the effects of Ale, Cider, and Mead with config-defined effects"})
        @Config.Name(value="Config Alcohol Effects (Rustic)")
        @Config.RequiresMcRestart
        public boolean alcoholConfig = false;
        @Config.Comment(value={"Fixes Reskillable losing track of the player when returning from the end, causing baubles with level requirements to be lost"})
        @Config.Name(value="Player Tracking Patch (Reskillable)")
        @Config.RequiresMcRestart
        public boolean playerTrackingPatch = false;
        @Config.Comment(value={"Allows SeedFood to bypass being locked by Reskillable (Allows eating Potatos/Carrots but not planting them)"})
        @Config.Name(value="SeedFood Bypass Lock (Reskillable)")
        @Config.RequiresMcRestart
        public boolean seedFoodBypass = false;
        @Config.Comment(value={"Makes Golden Osmosis perk also repair Golden Book Wyrm armor"})
        @Config.Name(value="Wyrm Osmosis (Reskillable/DefiledLands)")
        @Config.RequiresMcRestart
        public boolean goldenBookWyrmOsmosis = false;
        @Config.Comment(value={"Adds a config defined blacklist for the Hungry Farmer perk"})
        @Config.Name(value="HungryFarmer Blacklist (Reskillable)")
        @Config.RequiresMcRestart
        public boolean hungryFarmerBlacklistAbility = false;
        @Config.Comment(value={"Reworks Undershirt perk to work properly with FirstAid"})
        @Config.Name(value="Undershirt Rework (Reskillable/FirstAid)")
        @Config.RequiresMcRestart
        public boolean undershirtRework = false;
        @Config.Comment(value={"Patches Dupe bug with Stonelings"})
        @Config.Name(value="Stoneling Dupe Patch (Quark)")
        @Config.RequiresMcRestart
        public boolean stonelingPatch = false;
        @Config.Comment(value={"Replaces Launch potion's effect from PotionCore with Delayed Launch, for compatibility with knockback effects"})
        @Config.Name(value="Delayed Launch (PotionCore)")
        @Config.RequiresMcRestart
        public boolean delayedLaunch = false;
        @Config.Comment(value={"Halves the effect of Reach potion"})
        @Config.Name(value="Half Reach (PotionCore)")
        @Config.RequiresMcRestart
        public boolean halfReach = false;
        @Config.Comment(value={"Modify the render bounding boxes of some Lycanite mobs to fix under/oversized render boxes"})
        @Config.Name(value="Lycanite Render Box (LycanitesMobs)")
        @Config.RequiresMcRestart
        public boolean lycaniteRenderBoxResize = false;
        @Config.Comment(value={"Stops Lycanite mobs from attempting to target mobs that are stone statues, or tagged with NoAI"})
        @Config.Name(value="Lycanite Targetting (LycanitesMobs/IceAndFire)")
        @Config.RequiresMcRestart
        public boolean lycaniteTargettingPatch = false;
        @Config.Comment(value={"Makes ItemPhysics use the player's reach attribute instead of a hardcoded value"})
        @Config.Name(value="Item Reach Attribute (ItemPhysics)")
        @Config.RequiresMcRestart
        public boolean itemReachAttribute = false;
        @Config.Comment(value={"Makes incorrectly mixing potions in an Inspirations cauldron turn into Mundane instead of Thick potion"})
        @Config.Name(value="Cauldron Failure Mundane (Inspirations)")
        @Config.RequiresMcRestart
        public boolean inspirationsMundaneCauldron = false;
        @Config.Comment(value={"Prevents Champion mobs from turning into Infernals as well"})
        @Config.Name(value="No Infernal Champions (Champions/InfernalMobs)")
        @Config.RequiresMcRestart
        public boolean preventChampionInfernals = false;
        @Config.Comment(value={"Stops Infernal Mobs from spamming particles while the game is paused"})
        @Config.Name(value="Infernal Particle Spam (InfernalMobs)")
        @Config.RequiresMcRestart
        public boolean infernalParticleSpam = false;
        @Config.Comment(value={"Modify the render bounding boxes of some Ice and Fire mobs to fix undersized render boxes"})
        @Config.Name(value="IceAndFire Render Box (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean iceAndFireRenderBoxResize = false;
        @Config.Comment(value={"Cancels Ice and Fire's multipart mob handling to allow RLCombat to handle it instead"})
        @Config.Name(value="InF Multipart Handling (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean cancelIceAndFireMultipartHandling = false;
        @Config.Comment(value={"Allows for reducing the amount of particles generated by dragon explosions (These normally aren't rendered without Missing Particle Rendering Patch)"})
        @Config.Name(value="Explosion Particle Reduction (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean dragonParticleReduction = false;
        @Config.Comment(value={"Cancels Ice and Fire's handling of weapon bonuses, allowing for RLCombat to properly handle it instead"})
        @Config.Name(value="InF Bonus Handling (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean cancelIceAndFireBonusHandling = false;
        @Config.Comment(value={"Fix issues with Dragon Skull, Dragon Egg, Dragon Horn, and Myrmex Egg deleting items or duping when used in offhand"})
        @Config.Name(value="InF Offhand Items (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean patchIceAndFireOffhand = false;
        @Config.Comment(value={"Fix Food Expansion foods deleting the entire stack when eaten if their stack size is increased"})
        @Config.Name(value="Food Stack Size (FoodExpansion)")
        @Config.RequiresMcRestart
        public boolean foodExpansionStackSizeFix = false;
        @Config.Comment(value={"Fix Food Expansion's Nether Wart Soup crashing the game when eaten on a server"})
        @Config.Name(value="Nether Wart Soup Crash (FoodExpansion)")
        @Config.RequiresMcRestart
        public boolean netherWartSoupCrashFix = false;
        @Config.Comment(value={"Adds the ability to define Dynamic Surroundings entity chat messages in a config file"})
        @Config.Name(value="Chat Bubble Config (DSurroundings)")
        @Config.RequiresMcRestart
        public boolean entityChatBubbleConfig = false;
        @Config.Comment(value={"Tags mobs spawned from Infested Champions as summoned, allowing for Trinkets and Baubles to cancel their xp/item drops"})
        @Config.Name(value="Infested Summon Tag (Champions/TrinketsAndBaubles)")
        @Config.RequiresMcRestart
        public boolean infestedSummonTags = false;
        @Config.Comment(value={"Increases the time that Jailer Champions apply the Jailed effect for, since the original mixes up seconds and ticks"})
        @Config.Name(value="Jailer Champion Time (Champions)")
        @Config.RequiresMcRestart
        public boolean jailerTimeFix = false;
        @Config.Comment(value={"Replace and rework the flare gun entity and handling"})
        @Config.Name(value="Flare Gun Rework (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean flareGunRework = false;
        @Config.Comment(value={"Rework the Broken Heart trinket to work with FirstAid"})
        @Config.Name(value="Broken Heart Rework (BountifulBaubles/FirstAid)")
        @Config.RequiresMcRestart
        public boolean brokenHeartRework = false;
        @Config.Comment(value={"Prevents trumpets from triggering the Gluttony amulet effect"})
        @Config.Name(value="Trumpet Gluttony (BountifulBaubles/TrumpetSkeleton)")
        @Config.RequiresMcRestart
        public boolean trumpetGluttonFix = false;
        @Config.Comment(value={"Rework Obsidian Skull/Shield fire resistance handling to be less buggy"})
        @Config.Name(value="Obsidian Skull/Shield Rework (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean obsidianResistanceRework = false;
        @Config.Comment(value={"Prevents the player from removing armor cursed with Binding in the reforging station"})
        @Config.Name(value="Reforging Binding Fix (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean reforgingBindingFix = false;
        @Config.Comment(value={"Replaces SRParasites Living and Sentient armor models with custom models"})
        @Config.Name(value="Replace Parasite Armor Models (SRParasites)")
        @Config.RequiresMcRestart
        public boolean replaceParasiteArmorModel = false;
        @Config.Comment(value={"Attempts to stop the ability to cheese dragons on the edge of render distance"})
        @Config.Name(value="Enable AntiDragon Cheese (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean enableInFDragonCheese = false;
        @Config.Comment(value={"Makes dragons bite the player for the same amount as they bite other mobs, and heal on bites"})
        @Config.Name(value="Enable Better Dragon Bites (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean enableBetterDragonBites = false;
        @Config.Comment(value={"Cancels SRParasites manually packet handling for reach bonuses"})
        @Config.Name(value="Cancel Parasite Reach Packet (SRParasites)")
        @Config.RequiresMcRestart
        public boolean cancelParasiteReachPacket = false;
        @Config.Comment(value={"Makes Champions death messages use the Champion's name"})
        @Config.Name(value="Champion Death Message Tweak (Champions)")
        @Config.RequiresMcRestart
        public boolean championDeathMessage = false;
        @Config.Comment(value={"Makes Champions with potions use invisible particles"})
        @Config.Name(value="Champion Potion Invis (Champions)")
        @Config.RequiresMcRestart
        public boolean championPotionInvis = false;
        @Config.Comment(value={"Makes dragons start flying if they're stuck in water while they have a target"})
        @Config.Name(value="Enable Dragon Water Flying (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean enableDragonWaterFlight = false;
        @Config.Comment(value={"Stops the player from being able to dismount dragons and cyclops while they are being shaken."})
        @Config.Name(value="Enable Dragon Dismount Fix (Vanilla/IceAndFire)")
        @Config.RequiresMcRestart
        public boolean enableDragonDismountFix = false;
        @Config.Comment(value={"Blacklists PotionCore Revival/1UP potion from affecting non-players, to prevent duping."})
        @Config.Name(value="Prevent Revival Potion on Non-Players (PotionCore)")
        @Config.RequiresMcRestart
        public boolean revivalPotionPlayerOnly = false;
        @Config.Comment(value={"Prevents Charm Crates from being inserted into Shulker Boxes, manually and by hopper."})
        @Config.Name(value="Prevent Shulker Crate Insertion (Vanilla/Charm)")
        @Config.RequiresMcRestart
        public boolean shulkerCrateInsertion = false;
        @Config.Comment(value={"Cancels Parasites attempting to run a custom spawn tick check. (Seems to help performance/spawning)"})
        @Config.Name(value="Parasite Spawn Fix (SRParasites)")
        @Config.RequiresMcRestart
        public boolean parasiteSpawnFix = false;
        @Config.Comment(value={"Makes parasite spawning ignore all light level if the ignore sunlight option is true."})
        @Config.Name(value="Parasite Light Level (SRParasites)")
        @Config.RequiresMcRestart
        public boolean parasiteLightLevel = false;
        @Config.Comment(value={"Makes nether portals not spawn zombie pigmen, to prevent farming."})
        @Config.Name(value="Stop Pigmen Portal Spawning (Vanilla)")
        @Config.RequiresMcRestart
        public boolean stopPigmenPortalSpawning = false;
        @Config.Comment(value={"Fixes BetterNether's food bowls from deleting whole stacks when eaten."})
        @Config.Name(value="Stalagnate Bowl Fix (BetterNether)")
        @Config.RequiresMcRestart
        public boolean stalagnateBowlFix = false;
        @Config.Comment(value={"Adds a blacklist to prevent certain potion effects from working on tipped arrows."})
        @Config.Name(value="Tipped Arrow Blacklist (Vanilla)")
        @Config.RequiresMcRestart
        public boolean tippedArrowBlacklist = false;
        @Config.Comment(value={"Modifies the Bountiful Baubles Cobalt Shield Knockback Resistance Attribute from 10 -> 1000."})
        @Config.Name(value="Cobalt Shield Increased Resistance (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean cobaltShieldIncreasedResistance = false;
        @Config.Comment(value={"Skips checking oversized AABB for collisions when teleporting long distances, causing extreme lag."})
        @Config.Name(value="EXPERIMENTAL: Teleporting Lag Patch (Vanilla)")
        @Config.RequiresMcRestart
        public boolean teleportCollisionPatch = false;
        @Config.Comment(value={"Makes feathers not passively drop from chickens if they're stoned"})
        @Config.Name(value="Stoned Chicken Feather Fix (Quark/IceAndFire)")
        @Config.RequiresMcRestart
        public boolean chickenStonedFix = false;
        @Config.Comment(value={"Fixes some dupe bugs with stoned InF mobs"})
        @Config.Name(value="Tamed Mob Stone Dupe (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean tameStoneDupe = false;
        @Config.Comment(value={"Tweaks the values of the Education enchant."})
        @Config.Name(value="Education Tweak (BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean educationTweak = false;
        @Config.Comment(value={"Removes the ability to add protection enchant to shields"})
        @Config.Name(value="Remove Shield Protection Enchant (Inspirations)")
        @Config.RequiresMcRestart
        public boolean inspirationsShieldEnchantRemove = false;
        @Config.Comment(value={"Attempts to fix a desync caused by ScalingHealth when a mob dies in the same tick it is spawned"})
        @Config.Name(value="ScalingHealth Death Desync (ScalingHealth)")
        @Config.RequiresMcRestart
        public boolean scalingHealthDesync = false;
        @Config.Comment(value={"Forces Quark's Right-Click sign edit to sync the config value from server to client to prevent desyncs (Thanks to Venom)"})
        @Config.Name(value="Sync Sign Edit Config (Quark)")
        @Config.RequiresMcRestart
        public boolean fixRightClickSignEdit = false;
        @Config.Comment(value={"Rehandles the Sentient Scythe's AOE effect to make it less ridiculous and more compatible with other effects"})
        @Config.Name(value="Rehandle Sentient Scythe Effect (SRParasites/RLCombat)")
        @Config.RequiresMcRestart
        public boolean rehandleSentientScythe = false;
        @Config.Comment(value={"Makes Strays and Husks ignore whether or not they can see the sky when spawning"})
        @Config.Name(value="Stray/Husk Sky Spawning Fix (Vanilla)")
        @Config.RequiresMcRestart
        public boolean strayHuskSpawningFix = false;
        @Config.Comment(value={"Makes curing Zombie Villagers count as a kill for Mob Spawner Control spawners"})
        @Config.Name(value="Zombie Curing Ticks Spawners (Vanilla/MobSpawnerControl)")
        @Config.RequiresMcRestart
        public boolean curingTicksSpawners = false;
        @Config.Comment(value={"Fixes Dragonbone Bow duping arrows with the BetterSurvival Multishot enchant"})
        @Config.Name(value="InF Bow Multishot patch (IceAndFire/BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean dragonboneBowMultishot = false;
        @Config.Comment(value={"Allows for modifying the combo multiplier of Nunchaku"})
        @Config.Name(value="Changeable Nunchaku Combo (BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean nunchakuComboModifier = false;
        @Config.Comment(value={"Fixes Vampirism from Better Survival healing the player when hitting non-living entities"})
        @Config.Name(value="Vampirism Cheese Patch (BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean vampirismCheese = false;
        @Config.Comment(value={"Fixes Quark boat chests duping"})
        @Config.Name(value="Quark Chest Boat Dupe (Quark)")
        @Config.RequiresMcRestart
        public boolean quarkChestBoatDupe = false;
        @Config.Comment(value={"Fixes multiple InF entities such as eggs and dragons randomly despawning"})
        @Config.Name(value="InF Entity Despawn Patch (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean infDespawn = false;
        @Config.Comment(value={"Fixes dupe issues with the Locks keyring"})
        @Config.Name(value="Locks Keyring GUI Dupe Patch (Locks)")
        @Config.RequiresMcRestart
        public boolean locksGuiDupe = false;
        @Config.Comment(value={"Fixes dupe issues with the ToolBelt belt"})
        @Config.Name(value="ToolBelt Belt GUI Dupe Patch (ToolBelt)")
        @Config.RequiresMcRestart
        public boolean toolbeltGuiDupe = false;
        @Config.Comment(value={"Fixes dragons being breedable when still a child or not tamed"})
        @Config.Name(value="Dragon OverBreeding Patch (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean dragonBreedingPatch = false;
        @Config.Comment(value={"Enabled the \"Spooky Dragons\" config option in client config"})
        @Config.Name(value="Spooky Dragons Mixin (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean spookyDragonsMixin = false;
        @Config.Comment(value={"Fixes not being able to use Iron Canteen and Dragon Canteen on Rain Collectors"})
        @Config.Name(value="Rain Collector Canteen Fix (SimpleDifficulty)")
        @Config.RequiresMcRestart
        public boolean canteenFix = false;
        @Config.Comment(value={"Fixes the clay tool from NTP being abusable for guaranteed unbreaking enchantments"})
        @Config.Name(value="Clay Tool Enchant Patch (NoTreePunching)")
        @Config.RequiresMcRestart
        public boolean clayToolPatch = false;
        @Config.Comment(value={"Fixes the mattock from NTP not breaking when tilling ground"})
        @Config.Name(value="Mattock Breaking Patch (NoTreePunching)")
        @Config.RequiresMcRestart
        public boolean mattockPatch = false;
        @Config.Comment(value={"Fixes the quivers from Switchbow not closing when the quiver is dropped"})
        @Config.Name(value="Switchbow Quiver Patch (Switchbow)")
        @Config.RequiresMcRestart
        public boolean switchbowQuiverPatch = false;
        @Config.Comment(value={"Fix ForgottenItems vein pickaxe mining tile entities and bypassing protection"})
        @Config.Name(value="Vein Pickaxe Patch (ForgottenItems)")
        @Config.RequiresMcRestart
        public boolean veinPickaxePatch = false;
        @Config.Comment(value={"Fix Hippogrpyhs being breedable with wheat"})
        @Config.Name(value="Hippogrpyh Wheat Breeding Fix (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean hippogrpyhWheatBreeding = false;
        @Config.Comment(value={"Fix Reskillable cancelling indirect self damage"})
        @Config.Name(value="Reskillable Indirect Self Damage Patch (Reskillable)")
        @Config.RequiresMcRestart
        public boolean reskillableIndirectSelfDamage = false;
        @Config.Comment(value={"Replace the effect from the Scarlite Sword with a config-able effect"})
        @Config.Name(value="Scarlite Sword Config Effect (DefiledLands)")
        @Config.RequiresMcRestart
        public boolean scarliteSwordConfigEffect = false;
        @Config.Comment(value={"Fixes abusable Myrmex trades resulting in duping and infinite xp"})
        @Config.Name(value="Myrmex Abusable Trade Dupe (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean myrmexTradeDupe = false;
        @Config.Comment(value={"Fixes abusable Gorgon head using offhand swapping"})
        @Config.Name(value="Gorgon Head Offhand Abuse Patch (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean gorgonHeadOffhandAbuse = false;
        @Config.Comment(value={"Fixes Disenchanting table crashing when broken while someone is still in the GUI"})
        @Config.Name(value="Disenchanting Table Crash Patch (Disenchanter)")
        @Config.RequiresMcRestart
        public boolean disenchantingCrash = false;
        @Config.Comment(value={"Fixes crashes caused by Quark's chat linking when items with large nbt are linked"})
        @Config.Name(value="Quark Chat Link NBT Crash (Quark)")
        @Config.RequiresMcRestart
        public boolean chatLinkCrash = false;
        @Config.Comment(value={"Makes potion effects actually display their values above amplifier 3 in the inventory"})
        @Config.Name(value="Potion Amplifier Visibility (Vanilla)")
        @Config.RequiresMcRestart
        public boolean potionAmplifierVisibility = false;
        @Config.Comment(value={"Makes potion effects actually display their values above amplifier 3 in dshud's display"})
        @Config.Name(value="Potion Amplifier Visibility (DSHuds)")
        @Config.RequiresMcRestart
        public boolean potionAmplifierVisibilityDSHud = false;
        @Config.Comment(value={"Replaces the Parasite Cleaver effect with a config defined effect"})
        @Config.Name(value="Parasite Cleaver Effect Config (SRParasites)")
        @Config.RequiresMcRestart
        public boolean parasiteCleaverCustomEffect = false;
        @Config.Comment(value={"Stops Better Foliage's enable toggle from Chunk Animator XRaying"})
        @Config.Name(value="Better Foliage Chunk XRay (BetterFoliage/ChunkAnimator)")
        @Config.RequiresMcRestart
        public boolean betterFoliageChunkXRay = false;
        @Config.Comment(value={"Stops CarryOn from being able to pickup chests that have not had their loot generated"})
        @Config.Name(value="CarryOn Ungenerated Chest Patch (CarryOn)")
        @Config.RequiresMcRestart
        public boolean carryOnUngeneratedChest = false;
        @Config.Comment(value={"Stops CarryOn from being able to pickup pigs that still have saddles equipped"})
        @Config.Name(value="CarryOn Pig Saddle Patch (CarryOn)")
        @Config.RequiresMcRestart
        public boolean carryOnPigSaddlePatch = false;
        @Config.Comment(value={"Fixes CorpseComplex improperly using ExperienceTotal for calculating XP returns and restoring player XP on death when it shouldnt"})
        @Config.Name(value="CorpseComplex XP Death Fix (CorpseComplex)")
        @Config.RequiresMcRestart
        public boolean corpseComplexXPDeathFix = false;
    }
}

