/*
 * Decompiled with CFR 0.152.
 */
package blockynoob.waterskin.common.main;

import blockynoob.waterskin.common.main.TANDrinkData;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import toughasnails.api.TANPotions;
import toughasnails.api.item.ItemDrink;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.api.thirst.WaterType;
import toughasnails.config.json.DrinkData;
import toughasnails.config.json.ItemPredicate;
import toughasnails.init.ModConfig;
import toughasnails.item.ItemCanteen;
import toughasnails.thirst.ThirstHandler;

public class ThirstManager {
    private int lastThirst;
    private float lastHydration;

    public static DrinkData getDrinkData(ItemStack stack) {
        if (stack.func_77973_b().equals(Items.field_151068_bn)) {
            if (PotionUtils.func_185190_b((ItemStack)stack).isEmpty()) {
                return new DrinkData(new ItemPredicate(stack.func_77973_b()), WaterType.NORMAL.getThirst(), WaterType.NORMAL.getHydration(), WaterType.NORMAL.getPoisonChance());
            }
            return new DrinkData(new ItemPredicate(stack.func_77973_b()), 4, 0.3f, 0.0f);
        }
        if (stack.func_77973_b() instanceof ItemDrink) {
            if (stack.func_77973_b() instanceof ItemCanteen && stack.func_77952_i() == 0) {
                return null;
            }
            return TANDrinkData.getDataByName(stack.func_77977_a());
        }
        String registryName = stack.func_77973_b().getRegistryName().toString();
        if (ModConfig.drinkData.containsKey(registryName)) {
            for (DrinkData drinkData : (List)ModConfig.drinkData.get(registryName)) {
                if (!drinkData.getPredicate().apply(stack)) continue;
                return drinkData;
            }
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ThirstHandler thirstHandler = (ThirstHandler)ThirstHelper.getThirstData((EntityPlayer)player);
            this.lastThirst = thirstHandler.getThirst();
            this.lastHydration = thirstHandler.getHydration();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemUseFinishAgain(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = player.func_184586_b(player.func_184600_cs());
            ThirstHandler thirstHandler = (ThirstHandler)ThirstHelper.getThirstData((EntityPlayer)player);
            thirstHandler.setHydration(this.lastHydration);
            thirstHandler.setThirst(this.lastThirst);
            if (thirstHandler.isThirsty()) {
                boolean zeroStack = false;
                if (stack.func_190916_E() <= 0) {
                    stack.func_190920_e(1);
                    zeroStack = true;
                }
                DrinkData data = null;
                data = ThirstManager.getDrinkData(stack);
                if (data != null) {
                    int thirst = Math.min(20, thirstHandler.getThirst() + data.getThirstRestored());
                    float hydration = Math.min(20.0f, thirstHandler.getHydration() + data.getHydrationRestored());
                    thirstHandler.setThirst(thirst);
                    thirstHandler.setHydration(hydration);
                    Random random = new Random();
                    if (random.nextDouble() <= (double)data.getPoisonChance()) {
                        event.getEntityLiving().func_70690_d(new PotionEffect(TANPotions.thirst, 600));
                    }
                }
                if (zeroStack) {
                    stack.func_190920_e(0);
                }
            }
        }
    }
}

