/*
 * Decompiled with CFR 0.152.
 */
package blockynoob.waterskin.client;

import blockynoob.waterskin.common.main.WaterSkin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.TANCapabilities;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.thirst.ThirstHandler;
import toughasnails.util.RenderUtils;

@SideOnly(value=Side.CLIENT)
public class HydrationHUD {
    protected static final int BAR_WIDTH = 81;
    protected static final int BAR_HEIGHT = 9;
    protected static final float MAX_EXHAUSTION = 4.0f;
    protected static final int LEFT_OFFSET = 91;
    protected static final int TOP_OFFSET = -49;
    protected static final int ATLAS_HEIGHT = 18;
    protected static final int DROPLET_WIDTH = 9;
    protected static final int DROPLET_HEIGHT = 9;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPostRenderOverlayLast(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_THIRST)) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution resolution = event.getResolution();
            int width = resolution.func_78326_a();
            int height = resolution.func_78328_b();
            EntityPlayerSP player = mc.field_71439_g;
            WaterSkin.proxy.updateHydration((EntityPlayer)player);
            ThirstHandler thirstStats = (ThirstHandler)player.getCapability(TANCapabilities.THIRST, null);
            float thirstHydrationLevel = thirstStats.getHydration();
            float thirstHydration = thirstStats.getHydration();
            float thirstExhaustion = thirstStats.getExhaustion();
            thirstHydrationLevel = Math.max(0.0f, thirstHydrationLevel - 0.25f * thirstExhaustion);
            if (thirstHydration > 0.0f) {
                thirstExhaustion = thirstExhaustion % 2.0f * 2.0f;
            }
            mc.func_110434_K().func_110577_a(new ResourceLocation("waterskin", "textures/gui/overlay/thirst_overlay.png"));
            if (mc.field_71442_b.func_78763_f()) {
                HydrationHUD.drawExhaustion(width, height, thirstExhaustion, thirstHydrationLevel);
                HydrationHUD.drawHydration(width, height, thirstHydrationLevel);
            }
        }
    }

    private static void drawExhaustion(int width, int height, float exhaustion, float hydration) {
        Minecraft mc = Minecraft.func_71410_x();
        float maxExhaustion = 4.0f;
        int barWidth = 81;
        int barHeight = 9;
        int left = (width >> 1) + 91;
        int top = height + -49;
        float emptyRatio = (maxExhaustion - exhaustion) / maxExhaustion;
        float filledRatio = exhaustion / maxExhaustion;
        int emptyTex = (int)((float)barWidth * emptyRatio);
        int filledTex = (int)((float)barWidth * filledRatio);
        int x = left - filledTex;
        int y = top;
        mc.field_71456_v.func_73729_b(x, y, emptyTex, 18, filledTex, barHeight);
    }

    private static void drawHydration(int width, int height, float thirstHydrationLevel) {
        int dropletWidth = 9;
        int dropletHeight = 9;
        int left = (width >> 1) + 91;
        int top = height + -49;
        int x = left - dropletWidth;
        int y = top;
        int i = 0;
        while ((float)(2 * i) < thirstHydrationLevel) {
            float rem = thirstHydrationLevel - (float)(2 * i);
            if (rem < 2.0f) {
                RenderUtils.drawTexturedModalRect((int)(x - (dropletWidth - 1) * i), (int)y, (int)(dropletWidth * (int)(rem * 2.0f - 1.0f)), (int)0, (int)dropletWidth, (int)dropletHeight);
            } else {
                RenderUtils.drawTexturedModalRect((int)(x - (dropletWidth - 1) * i), (int)y, (int)(dropletWidth * 3), (int)0, (int)dropletWidth, (int)dropletHeight);
            }
            ++i;
        }
    }
}

