/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util.phys;

import net.minecraft.util.math.MathHelper;
import thebetweenlands.util.phys.Simulation;

public final class PendulumSimulation
implements Simulation {
    private static final float G = 9.8f;
    private final float length;
    private final float friction;
    private float moveAngle;
    private float moveForce;
    public float[] state = new float[3];

    public PendulumSimulation(float length, float friction) {
        this.length = length;
        this.friction = friction;
        this.moveForce = 0.0f;
        this.moveAngle = 0.0f;
    }

    public float getAngle() {
        return this.state[0];
    }

    public void move(float x, float y) {
        if (x != 0.0f || y != 0.0f) {
            this.moveAngle = -((float)MathHelper.func_181159_b((double)x, (double)(-y)));
            this.moveForce = MathHelper.func_76129_c((float)(x * x + y * y));
        } else {
            this.moveAngle = 0.0f;
            this.moveForce = 0.0f;
        }
    }

    @Override
    public float[] getState() {
        return this.state;
    }

    @Override
    public void evaluate(float[] state, float[] rate) {
        float theta = state[0];
        float omega = state[1];
        float alpha = -(this.moveForce / this.length) * MathHelper.func_76126_a((float)(theta + this.moveAngle)) - 9.8f / this.length * MathHelper.func_76126_a((float)theta) - this.friction * this.length * omega;
        rate[0] = omega;
        rate[1] = alpha;
        rate[2] = 1.0f;
    }
}

