/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class FogGenerator {
    private int lastCX;
    private int lastCZ;
    private NoiseGeneratorPerlin fogNoiseGen;
    private double[] fogChunkNoise = new double[256];
    private double scaleX;
    private double scaleZ;
    private double octaveScale;
    private long seed;

    public FogGenerator(int octaves, double scaleX, double scaleZ, double octaveScale, long seed) {
        this.seed = seed;
        Random rnd = new Random();
        rnd.setSeed(seed);
        this.fogNoiseGen = new NoiseGeneratorPerlin(rnd, octaves);
        this.scaleX = scaleX;
        this.scaleZ = scaleZ;
        this.octaveScale = octaveScale;
    }

    public FogGenerator(long seed) {
        this(4, 0.003, 0.003, 0.003, seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public float[] getFogRange(float min, float max) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return new float[]{min, max};
        }
        double x = Minecraft.func_71410_x().field_71439_g.field_70165_t;
        double z = Minecraft.func_71410_x().field_71439_g.field_70161_v;
        int cx = (int)((x - (double)((int)Math.floor(x) & 0xF)) / 16.0) - 1;
        int cz = (int)((z - (double)((int)Math.floor(z) & 0xF)) / 16.0);
        if (this.fogChunkNoise == null || this.lastCX != cx || this.lastCZ != cz) {
            this.lastCX = cx;
            this.lastCZ = cz;
            this.fogChunkNoise = this.fogNoiseGen.func_151599_a(this.fogChunkNoise, (double)(cx * 16), (double)(cz * 16), 16, 16, this.scaleX, this.scaleZ, this.octaveScale);
        }
        int ix = (int)Math.floor(x) & 0xF;
        int iz = (int)Math.floor(z) & 0xF;
        double noise = Math.abs(this.fogChunkNoise[iz * 16 + ix]);
        float diff = max - min;
        float newMax = (float)Math.max((double)min, (double)min + (double)diff * (1.0 - noise));
        diff = (newMax - min) / 2.0f;
        float newMin = (float)(noise < 0.75 ? (double)(min + diff / 2.0f) : (double)min + (double)(diff / 2.0f) * (1.0 - (noise - 0.75) * 2.0));
        return new float[]{newMin, newMax};
    }
}

