/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.smoking_rack;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.recipes.ISmokingRackRecipe;
import thebetweenlands.common.recipe.misc.SmokingRackRecipe;
import thebetweenlands.common.registries.BlockRegistry;

public class SmokingRackRecipeJEI
implements IRecipeWrapper {
    private ItemStack input;
    private ItemStack output;
    private int smokingTime;

    public SmokingRackRecipeJEI(SmokingRackRecipe recipe) {
        this.input = recipe.getInput();
        this.output = recipe.getOutput(this.input);
        this.smokingTime = recipe.getSmokingTime(this.input);
    }

    public SmokingRackRecipeJEI(ISmokingRackRecipe recipe) {
        this.input = recipe.getInput();
        this.output = recipe.getOutput(this.input);
        this.smokingTime = recipe.getSmokingTime(this.input);
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        inputs.add(this.input);
        inputs.add(new ItemStack(BlockRegistry.FALLEN_LEAVES));
        ingredients.setInputs(VanillaTypes.ITEM, inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String time = String.format("%ds", Math.max(10, 10 * this.smokingTime));
        int x = 66;
        minecraft.field_71466_p.func_175063_a(time, (float)(x -= minecraft.field_71466_p.func_78256_a(time) / 2), 8.0f, 0xFFFFFF);
    }
}

