/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.item.misc.ItemGem;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.RecipeRegistry;
import thebetweenlands.compat.jei.BetweenlandsJEIPlugin;

public class CircleGemsRecipeJEI
implements ICraftingRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private static List<ItemStack> applicableItems = NonNullList.func_191196_a();
    private final ICraftingGridHelper craftingGridHelper;

    public CircleGemsRecipeJEI(IGuiHelper guiHelper) {
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public static void updateApplicableItems() {
        applicableItems.clear();
        for (ItemStack stack : BetweenlandsJEIPlugin.ingredientRegistry.getAllIngredients(VanillaTypes.ITEM)) {
            if (stack.func_190926_b() || !CircleGemHelper.isApplicable(stack.func_77973_b()) || !BetweenlandsConfig.COMPATIBILITY.showNonBLGemRecipes && !"thebetweenlands".equals(stack.func_77973_b().getRegistryName().func_110624_b())) continue;
            applicableItems.add(stack);
        }
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return RecipeRegistry.CIRCLE_GEMS;
    }

    public void getIngredients(IIngredients ingredients) {
        CircleGemsRecipeJEI.updateApplicableItems();
        ArrayList inputLists = new ArrayList();
        ArrayList outputLists = new ArrayList();
        ItemStack[] gems = new ItemStack[]{new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM), new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM), new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM)};
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> gemInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack stack : applicableItems) {
            for (int i = 0; i < 3; ++i) {
                ItemStack result = stack.func_77946_l();
                ItemStack gem = gems[i];
                CircleGemType appliedGem = ((ItemGem)gem.func_77973_b()).type;
                CircleGemHelper.setGem(result, appliedGem);
                inputs.add(stack);
                gemInputs.add(gem);
                outputs.add(result);
            }
        }
        inputLists.add(inputs);
        inputLists.add(gemInputs);
        outputLists.add(outputs);
        ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
        ingredients.setOutputLists(VanillaTypes.ITEM, outputLists);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        recipeLayout.setShapeless();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IFocus focus = recipeLayout.getFocus();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (focus != null && focus.getValue() instanceof ItemStack && (CircleGemHelper.isApplicable(((ItemStack)focus.getValue()).func_77973_b()) || ((ItemStack)focus.getValue()).func_77973_b() instanceof ItemGem)) {
            if (focus.getMode() == IFocus.Mode.INPUT) {
                if (!(((ItemStack)focus.getValue()).func_77973_b() instanceof ItemGem)) {
                    ((List)outputs.get(0)).removeIf(stack -> stack.func_77973_b() != ((ItemStack)focus.getValue()).func_77973_b());
                } else if (((ItemStack)focus.getValue()).func_77973_b() instanceof ItemGem) {
                    Iterator outIterator = ((List)outputs.get(0)).iterator();
                    Iterator inIterator = ((List)inputs.get(0)).iterator();
                    while (outIterator.hasNext()) {
                        ItemStack stack2 = (ItemStack)outIterator.next();
                        inIterator.next();
                        if (CircleGemHelper.getGem(stack2) == ((ItemGem)((ItemStack)focus.getValue()).func_77973_b()).type) continue;
                        outIterator.remove();
                        inIterator.remove();
                    }
                }
            } else {
                ((List)inputs.get(0)).removeIf(stack -> stack.func_77973_b() != ((ItemStack)focus.getValue()).func_77973_b() || CircleGemHelper.getGem(stack) != CircleGemType.NONE);
                ((List)inputs.get(1)).removeIf(stack -> CircleGemHelper.getGem((ItemStack)focus.getValue()) != CircleGemType.NONE && ((ItemGem)stack.func_77973_b()).type != CircleGemHelper.getGem((ItemStack)focus.getValue()));
                ((List)outputs.get(0)).removeIf(stack -> stack.func_77973_b() != ((ItemStack)focus.getValue()).func_77973_b());
                if (CircleGemHelper.getGem((ItemStack)focus.getValue()) != CircleGemType.NONE) {
                    ((List)outputs.get(0)).removeIf(stack -> CircleGemHelper.getGem((ItemStack)focus.getValue()) != CircleGemHelper.getGem(stack));
                }
            }
        }
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        guiItemStacks.setOverrideDisplayFocus(null);
        guiItemStacks.set(0, (List)outputs.get(0));
        BetweenlandsJEIPlugin.addRecipeName(this.getRegistryName(), guiItemStacks, 0);
    }
}

