/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.fishbait;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.item.herblore.ItemCrushed;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.RecipeRegistry;
import thebetweenlands.compat.jei.BetweenlandsJEIPlugin;
import thebetweenlands.util.NBTHelper;

public class FishBaitRecipeJEI
implements ICraftingRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final ICraftingGridHelper craftingGridHelper;

    public FishBaitRecipeJEI(IGuiHelper guiHelper) {
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return RecipeRegistry.FISH_BAIT;
    }

    public ItemStack baitModifierWrapper(ItemStack modifier) {
        ItemStack resultItem = new ItemStack(ItemRegistry.FISH_BAIT);
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(resultItem);
        nbt.func_74768_a("sink_speed", 3);
        nbt.func_74768_a("dissolve_time", 200);
        nbt.func_74768_a("range", 1);
        nbt.func_74757_a("glowing", false);
        resultItem.func_77982_d(nbt);
        int addSinkSpeed = 0;
        int addDissolveTime = 0;
        int addRange = 0;
        boolean addGlowing = false;
        boolean minusGlowing = false;
        if (ItemCrushed.EnumItemCrushed.GROUND_BETWEENSTONE_PEBBLE.isItemOf(modifier)) {
            ++addSinkSpeed;
        } else if (ItemMisc.EnumItemMisc.TAR_DRIP.isItemOf(modifier)) {
            ++addDissolveTime;
        } else if (modifier.func_77973_b() == ItemRegistry.CRAB_STICK) {
            ++addRange;
        } else if (ItemCrushed.EnumItemCrushed.GROUND_BULB_CAPPED_MUSHROOM.isItemOf(modifier)) {
            addGlowing = true;
        } else if (ItemCrushed.EnumItemCrushed.GROUND_BLADDERWORT_STALK.isItemOf(modifier)) {
            --addSinkSpeed;
        } else if (ItemCrushed.EnumItemCrushed.GROUND_MILKWEED.isItemOf(modifier)) {
            --addDissolveTime;
        } else if (modifier.func_77973_b() == ItemRegistry.SAP_SPIT) {
            --addRange;
        } else if (modifier.func_77973_b() == ItemRegistry.SLUDGE_BALL) {
            minusGlowing = true;
        }
        if (resultItem.func_77978_p().func_74762_e("sink_speed") + addSinkSpeed > 0) {
            resultItem.func_77978_p().func_74768_a("sink_speed", resultItem.func_77978_p().func_74762_e("sink_speed") + addSinkSpeed);
        }
        if (resultItem.func_77978_p().func_74762_e("dissolve_time") + addDissolveTime * 20 >= 0) {
            resultItem.func_77978_p().func_74768_a("dissolve_time", resultItem.func_77978_p().func_74762_e("dissolve_time") + addDissolveTime * 20);
        }
        if (resultItem.func_77978_p().func_74762_e("range") + addRange > 0) {
            resultItem.func_77978_p().func_74768_a("range", resultItem.func_77978_p().func_74762_e("range") + addRange);
        }
        if (addGlowing) {
            resultItem.func_77978_p().func_74757_a("glowing", true);
        }
        if (minusGlowing) {
            resultItem.func_77978_p().func_74757_a("glowing", false);
        }
        return resultItem;
    }

    public void getIngredients(IIngredients ingredients) {
        NonNullList modifierItems = NonNullList.func_191196_a();
        modifierItems.add(ItemCrushed.EnumItemCrushed.GROUND_BETWEENSTONE_PEBBLE.create(1));
        modifierItems.add(ItemMisc.EnumItemMisc.TAR_DRIP.create(1));
        modifierItems.add(new ItemStack(ItemRegistry.CRAB_STICK));
        modifierItems.add(ItemCrushed.EnumItemCrushed.GROUND_BULB_CAPPED_MUSHROOM.create(1));
        modifierItems.add(ItemCrushed.EnumItemCrushed.GROUND_BLADDERWORT_STALK.create(1));
        modifierItems.add(ItemCrushed.EnumItemCrushed.GROUND_MILKWEED.create(1));
        modifierItems.add(new ItemStack(ItemRegistry.SAP_SPIT));
        modifierItems.add(new ItemStack(ItemRegistry.SLUDGE_BALL));
        NonNullList baitItems = NonNullList.func_191196_a();
        ItemStack baitItem = new ItemStack(ItemRegistry.FISH_BAIT);
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(baitItem);
        nbt.func_74768_a("sink_speed", 3);
        nbt.func_74768_a("dissolve_time", 200);
        nbt.func_74768_a("range", 1);
        nbt.func_74757_a("glowing", false);
        baitItem.func_77982_d(nbt);
        for (ItemStack modifier : modifierItems) {
            baitItems.add(this.baitModifierWrapper(modifier));
        }
        System.out.println(baitItems.size());
        ArrayList<NonNullList> inputLists = new ArrayList<NonNullList>(2);
        inputLists.add(NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{baitItem}));
        inputLists.add(modifierItems);
        ArrayList<NonNullList> outputLists = new ArrayList<NonNullList>(1);
        outputLists.add(baitItems);
        ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
        ingredients.setOutputLists(VanillaTypes.ITEM, outputLists);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        recipeLayout.setShapeless();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.setOverrideDisplayFocus(null);
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        guiItemStacks.set(0, (List)outputs.get(0));
        BetweenlandsJEIPlugin.addRecipeName(this.getRegistryName(), guiItemStacks, 0);
    }
}

