/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import thebetweenlands.api.loot.ISharedLootPool;
import thebetweenlands.api.network.IGenericDataManagerAccess;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.loot.shared.SharedLootPool;
import thebetweenlands.common.world.storage.LocalStorageImpl;

public class SharedLootPoolStorage
extends LocalStorageImpl {
    private Map<ResourceLocation, SharedLootPool> sharedLootPools = new HashMap<ResourceLocation, SharedLootPool>();
    private TObjectIntMap<ResourceLocation> lootInventories = new TObjectIntHashMap();
    private long lootSeed;

    public SharedLootPoolStorage(IWorldStorage worldStorage, StorageID id, LocalRegion region) {
        super(worldStorage, id, region);
    }

    public SharedLootPoolStorage(IWorldStorage worldStorage, StorageID id, LocalRegion region, long lootSeed) {
        super(worldStorage, id, region);
        this.lootSeed = lootSeed;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public IGenericDataManagerAccess getDataManager() {
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        if (!this.sharedLootPools.isEmpty()) {
            NBTTagList sharedLootPoolsNbt = new NBTTagList();
            for (SharedLootPool sharedLootPool : this.sharedLootPools.values()) {
                sharedLootPoolsNbt.func_74742_a((NBTBase)sharedLootPool.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("sharedLootPools", (NBTBase)sharedLootPoolsNbt);
        }
        if (!this.lootInventories.isEmpty()) {
            NBTTagList lootInventoriesNbt = new NBTTagList();
            this.lootInventories.forEachEntry((table, count) -> {
                NBTTagCompound entryNbt = new NBTTagCompound();
                entryNbt.func_74778_a("table", table.toString());
                entryNbt.func_74768_a("count", count);
                lootInventoriesNbt.func_74742_a((NBTBase)entryNbt);
                return true;
            });
            nbt.func_74782_a("lootInventories", (NBTBase)lootInventoriesNbt);
        }
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.sharedLootPools.clear();
        NBTTagList sharedLootPoolsNbt = nbt.func_150295_c("sharedLootPools", 10);
        for (int i = 0; i < sharedLootPoolsNbt.func_74745_c(); ++i) {
            SharedLootPool sharedLootPool = new SharedLootPool(sharedLootPoolsNbt.func_150305_b(i), this);
            ResourceLocation lootTable = sharedLootPool.getLootTable();
            if (lootTable == null) continue;
            this.sharedLootPools.put(lootTable, sharedLootPool);
        }
        this.lootInventories.clear();
        NBTTagList lootInventoriesNbt = nbt.func_150295_c("lootInventories", 10);
        for (int i = 0; i < lootInventoriesNbt.func_74745_c(); ++i) {
            NBTTagCompound entryNbt = lootInventoriesNbt.func_150305_b(i);
            this.lootInventories.put((Object)new ResourceLocation(entryNbt.func_74779_i("table")), entryNbt.func_74762_e("count"));
        }
    }

    public int getSharedLootInventories(ResourceLocation lootTable) {
        return this.lootInventories.get((Object)lootTable);
    }

    public void registerSharedLootInventory(BlockPos pos, ResourceLocation lootTable) {
        this.lootInventories.adjustOrPutValue((Object)lootTable, 1, 1);
        this.linkChunkSafely(new ChunkPos(pos));
        this.markDirty();
    }

    @Nullable
    public ISharedLootPool getSharedLootPool(ResourceLocation lootTable) {
        return this.sharedLootPools.get(lootTable);
    }

    @Nullable
    public ISharedLootPool getOrCreateSharedLootPool(ResourceLocation lootTable) {
        ISharedLootPool pool = this.getSharedLootPool(lootTable);
        if (pool != null) {
            return pool;
        }
        SharedLootPool newPool = new SharedLootPool(lootTable, this.lootSeed, this);
        this.sharedLootPools.put(lootTable, newPool);
        this.markDirty();
        return newPool;
    }

    @Nullable
    public ISharedLootPool removeSharedLootPool(ResourceLocation lootTable) {
        ISharedLootPool pool = this.sharedLootPools.remove(lootTable);
        if (pool != null) {
            this.markDirty();
        }
        return pool;
    }

    public Set<ResourceLocation> getSharedLootPoolKeys() {
        return this.sharedLootPools.keySet();
    }
}

