/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import com.google.common.base.Predicate;
import gnu.trove.iterator.TObjectLongIterator;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.api.network.IGenericDataManagerAccess;
import thebetweenlands.api.storage.IChunkStorage;
import thebetweenlands.api.storage.IDeferredStorageOperation;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.api.storage.ILocalStorageHandle;
import thebetweenlands.api.storage.ILocalStorageHandler;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.LocalStorageReference;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.clientbound.MessageSyncLocalStorageData;
import thebetweenlands.common.registries.StorageRegistry;
import thebetweenlands.common.world.storage.LocalRegionCache;
import thebetweenlands.common.world.storage.LocalRegionData;
import thebetweenlands.common.world.storage.LocalStorageHandleImpl;
import thebetweenlands.common.world.storage.LocalStorageSaveHandler;

public class LocalStorageHandlerImpl
implements ILocalStorageHandler {
    private final IWorldStorage worldStorage;
    private final World world;
    private final File localStorageDir;
    private final Map<StorageID, ILocalStorage> localStorage = new HashMap<StorageID, ILocalStorage>();
    private final List<ILocalStorage> tickableLocalStorage = new ArrayList<ILocalStorage>();
    private final List<ILocalStorage> pendingUnreferencedStorages = new ArrayList<ILocalStorage>();
    private final TObjectLongMap<LocalRegionData> pendingUnreferencedRegions = new TObjectLongHashMap();
    private final LocalRegionCache regionCache;
    private final LocalStorageSaveHandler saveHandler = new LocalStorageSaveHandler();

    public LocalStorageHandlerImpl(IWorldStorage worldStorage) {
        this.worldStorage = worldStorage;
        this.world = worldStorage.getWorld();
        String dimFolder = this.world.field_73011_w.getSaveFolder();
        this.localStorageDir = new File(this.world.func_72860_G().func_75765_b(), (dimFolder != null && dimFolder.length() > 0 ? dimFolder + File.separator : "") + "data" + File.separator + "local_storage" + File.separator);
        this.regionCache = new LocalRegionCache(this, new File(this.localStorageDir, "region"));
    }

    @Override
    public IWorldStorage getWorldStorage() {
        return this.worldStorage;
    }

    @Override
    public boolean addLocalStorage(ILocalStorage storage) {
        return this.addLocalStorageInternal(storage, true);
    }

    protected boolean addLocalStorageInternal(ILocalStorage storage, boolean isInitialAdd) {
        if (!this.localStorage.containsKey(storage.getID())) {
            this.localStorage.put(storage.getID(), storage);
            if (storage instanceof ITickable) {
                this.tickableLocalStorage.add(storage);
            }
            if (isInitialAdd) {
                storage.onAdded();
            }
            storage.onLoaded();
            boolean isReferenced = false;
            for (ChunkPos referenceChunk : storage.getLinkedChunks()) {
                LocalStorageReference reference;
                IChunkStorage chunkStorage;
                Chunk chunk = this.world.func_72863_F().func_186026_b(referenceChunk.field_77276_a, referenceChunk.field_77275_b);
                if (chunk == null || (chunkStorage = this.worldStorage.getChunkStorage(chunk)) == null || (reference = chunkStorage.getReference(storage.getID())) == null) continue;
                isReferenced = true;
                if (storage.getLoadedReferences().contains(reference)) continue;
                storage.loadReference(reference);
            }
            if (!isReferenced && isInitialAdd && !this.world.field_72995_K) {
                this.pendingUnreferencedStorages.add(storage);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLocalStorage(ILocalStorage storage) {
        if (this.localStorage.containsKey(storage.getID())) {
            LocalRegion region;
            storage.onRemoving();
            if (!this.world.field_72995_K) {
                storage.unlinkAllChunks();
            }
            this.localStorage.remove(storage.getID());
            Iterator<ILocalStorage> tickableIt = this.tickableLocalStorage.iterator();
            while (tickableIt.hasNext()) {
                ILocalStorage tickableStorage = tickableIt.next();
                if (!storage.getID().equals(tickableStorage.getID())) continue;
                tickableIt.remove();
            }
            Iterator<ILocalStorage> pendingIt = this.pendingUnreferencedStorages.iterator();
            while (pendingIt.hasNext()) {
                ILocalStorage pendingStorage = pendingIt.next();
                if (!storage.getID().equals(pendingStorage.getID())) continue;
                pendingIt.remove();
            }
            boolean wasSavedToRegion = false;
            if (!this.world.field_72995_K) {
                wasSavedToRegion = this.deleteLocalStorageFileInternal(storage);
            }
            storage.onUnloaded();
            storage.onRemoved();
            if (wasSavedToRegion && !this.world.field_72995_K && (region = storage.getRegion()) != null) {
                this.decrRegionRef(this.regionCache.getCachedRegion(region), null, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public ILocalStorage getLocalStorage(StorageID id) {
        return this.localStorage.get(id);
    }

    @Override
    public <T extends ILocalStorage> List<T> getLocalStorages(Class<T> type, double x, double z, @Nullable Predicate<T> filter) {
        ArrayList<ILocalStorage> storages = new ArrayList<ILocalStorage>();
        int cx = MathHelper.func_76128_c((double)x) >> 4;
        int cz = MathHelper.func_76128_c((double)z) >> 4;
        Chunk chunk = this.world.func_72964_e(cx, cz);
        IChunkStorage chunkStorage = this.getWorldStorage().getChunkStorage(chunk);
        if (chunkStorage != null) {
            for (LocalStorageReference ref : chunkStorage.getLocalStorageReferences()) {
                ILocalStorage localStorage = this.getLocalStorage(ref.getID());
                if (localStorage == null || localStorage.getBoundingBox() == null || !type.isAssignableFrom(localStorage.getClass()) || filter != null && !filter.apply((Object)localStorage) || storages.contains(localStorage)) continue;
                storages.add(localStorage);
            }
        }
        return storages;
    }

    @Override
    public <T extends ILocalStorage> List<T> getLocalStorages(Class<T> type, AxisAlignedBB aabb, @Nullable Predicate<T> filter) {
        ArrayList<ILocalStorage> storages = new ArrayList<ILocalStorage>();
        int sx = MathHelper.func_76128_c((double)aabb.field_72340_a) >> 4;
        int sz = MathHelper.func_76128_c((double)aabb.field_72339_c) >> 4;
        int ex = MathHelper.func_76128_c((double)aabb.field_72336_d) >> 4;
        int ez = MathHelper.func_76128_c((double)aabb.field_72334_f) >> 4;
        for (int cx = sx; cx <= ex; ++cx) {
            for (int cz = sz; cz <= ez; ++cz) {
                Chunk chunk = this.world.func_72964_e(cx, cz);
                IChunkStorage chunkStorage = this.getWorldStorage().getChunkStorage(chunk);
                if (chunkStorage == null) continue;
                for (LocalStorageReference ref : chunkStorage.getLocalStorageReferences()) {
                    ILocalStorage localStorage = this.getLocalStorage(ref.getID());
                    if (localStorage == null || localStorage.getBoundingBox() == null || !type.isAssignableFrom(localStorage.getClass()) || !localStorage.getBoundingBox().func_72326_a(aabb) || filter != null && !filter.apply((Object)localStorage) || storages.contains(localStorage)) continue;
                    storages.add(localStorage);
                }
            }
        }
        return storages;
    }

    @Override
    public void deleteLocalStorageFile(ILocalStorage storage) {
        this.deleteLocalStorageFileInternal(storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteLocalStorageFileInternal(ILocalStorage storage) {
        if (storage.getRegion() == null) {
            File file = new File(this.getLocalStorageDirectory(), storage.getID().getStringID() + ".dat");
            this.saveHandler.queueLocalStorage(file, null);
        } else {
            LocalRegionData data = this.regionCache.getOrCreateRegion(storage.getRegion(), false);
            if (data != null) {
                this.incrRegionRef(data);
                try {
                    boolean bl = data.deleteLocalStorage(this.regionCache.getDir(), storage.getID());
                    return bl;
                }
                finally {
                    this.decrRegionRef(data, null, true);
                }
            }
        }
        return false;
    }

    @Override
    public void saveLocalStorageFile(ILocalStorage storage) {
        this.saveLocalStorageFile(storage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveLocalStorageFile(ILocalStorage storage, boolean skipRegionUnloading) {
        boolean isNewStorage;
        LocalRegionData data;
        block5: {
            NBTTagCompound nbt = this.saveLocalStorageToNBT(new NBTTagCompound(), storage);
            if (storage.getRegion() == null) {
                File file = new File(this.getLocalStorageDirectory(), storage.getID().getStringID() + ".dat");
                this.saveHandler.queueLocalStorage(file, nbt);
                return;
            }
            LocalRegion region = storage.getRegion();
            data = this.regionCache.getOrCreateRegion(region);
            boolean isLoaded = !storage.getLoadedReferences().isEmpty() && this.getLocalStorage(storage.getID()) != null;
            boolean isFromRegion = data.getLocalStorageNBT(storage.getID()) != null;
            isNewStorage = isLoaded && !isFromRegion;
            this.incrRegionRef(data);
            try {
                data.setLocalStorageNBT(storage.getID(), nbt);
                if (!skipRegionUnloading) break block5;
                this.decrRegionRef(data, null, false);
            }
            catch (Throwable throwable) {
                if (skipRegionUnloading) {
                    this.decrRegionRef(data, null, false);
                    throw throwable;
                } else {
                    if (isNewStorage || !this.decrRegionRef(data, null, true)) throw throwable;
                    TheBetweenlands.logger.warn(String.format("Saving local storage with ID %s, but its region %s was not loaded. This should not happen...", storage.getID().getStringID(), data.getID()));
                }
                throw throwable;
            }
            return;
        }
        if (isNewStorage || !this.decrRegionRef(data, null, true)) return;
        TheBetweenlands.logger.warn(String.format("Saving local storage with ID %s, but its region %s was not loaded. This should not happen...", storage.getID().getStringID(), data.getID()));
    }

    @Nullable
    private ILocalStorage loadLocalStorageUnsafe(LocalStorageReference reference) {
        if (!this.world.field_72995_K) {
            try {
                ILocalStorage storage = this.createLocalStorageFromFile(reference);
                if (storage != null) {
                    this.addLocalStorageInternal(storage, false);
                    LocalRegion region = storage.getRegion();
                    if (region != null) {
                        LocalRegionData data = this.regionCache.getOrCreateRegion(region);
                        this.incrRegionRef(data);
                    }
                }
                return storage;
            }
            catch (Exception ex) {
                TheBetweenlands.logger.error(String.format("Failed loading local storage with ID %s at %s", reference.getID().getStringID(), "[x=" + reference.getChunk().field_77276_a + ", z=" + reference.getChunk().field_77275_b + "]"), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public ILocalStorage loadLocalStorage(LocalStorageReference reference) {
        return this.loadLocalStorageUnsafe(reference);
    }

    @Override
    public ILocalStorageHandle getOrLoadLocalStorage(LocalStorageReference reference) {
        ILocalStorage storage = this.getLocalStorage(reference.getID());
        if (storage == null && !this.world.field_72995_K) {
            storage = this.loadLocalStorageUnsafe(reference);
        }
        if (storage != null) {
            return new LocalStorageHandleImpl(storage, reference);
        }
        return null;
    }

    @Nullable
    private ILocalStorage createLocalStorageFromFile(LocalStorageReference reference) {
        if (!reference.hasRegion()) {
            File file = new File(this.getLocalStorageDirectory(), reference.getID().getStringID() + ".dat");
            try {
                NBTTagCompound nbt = this.saveHandler.loadFileNbt(file);
                if (nbt != null) {
                    return this.createLocalStorageFromNBT(nbt, null);
                }
            }
            catch (Exception ex) {
                TheBetweenlands.logger.error(String.format("Failed reading local storage %s from file: %s", reference.getID().getStringID(), file.getAbsolutePath()), (Throwable)ex);
            }
        } else {
            LocalRegionData region = this.regionCache.getOrCreateRegion(reference.getRegion());
            NBTTagCompound nbt = region.getLocalStorageNBT(reference.getID());
            if (nbt != null) {
                return this.createLocalStorageFromNBT(nbt, reference.getRegion());
            }
        }
        return null;
    }

    private void incrRegionRef(@Nullable LocalRegionData data) {
        if (data != null) {
            data.incrRefCounter();
            if (data.hasReferences()) {
                this.pendingUnreferencedRegions.remove((Object)data);
            }
        }
    }

    private boolean decrRegionRef(@Nullable LocalRegionData data, @Nullable StorageID checkID, boolean saveAndUnload) {
        if (data != null && (checkID == null || data.getLocalStorageNBT(checkID) != null)) {
            data.decrRefCounter();
            if (!data.hasReferences()) {
                if (saveAndUnload) {
                    this.pendingUnreferencedRegions.put((Object)data, this.world.func_82737_E());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean unloadLocalStorage(ILocalStorage storage) {
        if (this.localStorage.containsKey(storage.getID())) {
            LocalRegion region;
            if (!this.world.field_72995_K && storage.isDirty()) {
                this.saveLocalStorageFile(storage, true);
                storage.setDirty(false);
            }
            this.localStorage.remove(storage.getID());
            Iterator<ILocalStorage> tickableIt = this.tickableLocalStorage.iterator();
            while (tickableIt.hasNext()) {
                ILocalStorage tickableStorage = tickableIt.next();
                if (!storage.getID().equals(tickableStorage.getID())) continue;
                tickableIt.remove();
            }
            Iterator<ILocalStorage> pendingIt = this.pendingUnreferencedStorages.iterator();
            while (pendingIt.hasNext()) {
                ILocalStorage pendingStorage = pendingIt.next();
                if (!storage.getID().equals(pendingStorage.getID())) continue;
                pendingIt.remove();
            }
            storage.onUnloaded();
            if (!this.world.field_72995_K && (region = storage.getRegion()) != null) {
                this.decrRegionRef(this.regionCache.getCachedRegion(region), storage.getID(), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<ILocalStorage> getLoadedStorages() {
        return Collections.unmodifiableCollection(this.localStorage.values());
    }

    @Override
    public File getLocalStorageDirectory() {
        return this.localStorageDir;
    }

    @Override
    public void update() {
        ILocalStorage localStorage;
        int i;
        for (i = 0; i < this.tickableLocalStorage.size(); ++i) {
            localStorage = this.tickableLocalStorage.get(i);
            ((ITickable)localStorage).func_73660_a();
            IGenericDataManagerAccess dataManager = localStorage.getDataManager();
            if (dataManager == null) continue;
            dataManager.func_73660_a();
            if (!dataManager.isDirty()) continue;
            MessageSyncLocalStorageData message = new MessageSyncLocalStorageData(localStorage, false);
            for (EntityPlayerMP watcher : localStorage.getWatchers()) {
                TheBetweenlands.networkWrapper.sendTo((IMessage)message, watcher);
            }
        }
        if (!this.world.field_72995_K) {
            for (i = 0; i < this.pendingUnreferencedStorages.size(); ++i) {
                localStorage = this.pendingUnreferencedStorages.get(i);
                if (!localStorage.getLoadedReferences().isEmpty() || this.getLocalStorage(localStorage.getID()) == null) continue;
                this.unloadLocalStorage(localStorage);
            }
            TObjectLongIterator pendingUnreferencedRegionsIT = this.pendingUnreferencedRegions.iterator();
            while (pendingUnreferencedRegionsIT.hasNext()) {
                pendingUnreferencedRegionsIT.advance();
                if (this.world.func_82737_E() - pendingUnreferencedRegionsIT.value() <= 20L) continue;
                LocalRegionData data = (LocalRegionData)pendingUnreferencedRegionsIT.key();
                pendingUnreferencedRegionsIT.remove();
                if (data.isDirty()) {
                    data.saveRegion(this.regionCache.getDir());
                }
                this.regionCache.removeRegion(data.getRegion());
            }
        }
        this.pendingUnreferencedStorages.clear();
    }

    @Override
    public ILocalStorage createLocalStorageFromNBT(NBTTagCompound nbt, @Nullable LocalRegion region) {
        ResourceLocation type = new ResourceLocation(nbt.func_74779_i("type"));
        StorageID id = StorageID.readFromNBT(nbt);
        ILocalStorage storage = this.createLocalStorage(type, id, region);
        storage.readFromNBT(nbt.func_74775_l("data"));
        return storage;
    }

    @Override
    public ILocalStorage createLocalStorage(ResourceLocation type, StorageID id, @Nullable LocalRegion region) {
        StorageRegistry.Factory<? extends ILocalStorage> factory = StorageRegistry.getStorageFactory(type);
        if (factory == null) {
            throw new RuntimeException("Local storage type not mapped: " + type);
        }
        return factory.create(this.worldStorage, id, region);
    }

    @Override
    public NBTTagCompound saveLocalStorageToNBT(NBTTagCompound nbt, ILocalStorage storage) {
        ResourceLocation type = StorageRegistry.getStorageId(storage.getClass());
        if (type == null) {
            throw new RuntimeException("Local storage type not mapped: " + storage);
        }
        nbt.func_74778_a("type", type.toString());
        storage.getID().writeToNBT(nbt);
        nbt.func_74782_a("data", (NBTBase)storage.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueDeferredOperation(ChunkPos chunk, IDeferredStorageOperation operation) {
        Chunk loadedChunk = this.getWorldStorage().getWorld().func_72863_F().func_186026_b(chunk.field_77276_a, chunk.field_77275_b);
        if (loadedChunk != null) {
            IChunkStorage chunkStorage = this.getWorldStorage().getChunkStorage(loadedChunk);
            operation.apply(chunkStorage);
            return;
        }
        LocalRegion region = LocalRegion.getFromBlockPos(chunk.field_77276_a * 16, chunk.field_77275_b * 16);
        LocalRegionData data = this.regionCache.getOrCreateRegion(region);
        this.incrRegionRef(data);
        try {
            NBTTagCompound chunkNbt = data.getChunkNBT(chunk);
            if (chunkNbt == null) {
                chunkNbt = new NBTTagCompound();
            }
            NBTTagList operationsNbt = chunkNbt.func_150295_c("DeferredOperations", 10);
            ResourceLocation type = StorageRegistry.getDeferredOperationId(operation.getClass());
            if (type == null) {
                throw new RuntimeException("Deferred storage operation type not mapped: " + operation);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("type", type.toString());
            nbt.func_74782_a("data", (NBTBase)operation.writeToNBT(new NBTTagCompound()));
            operationsNbt.func_74742_a((NBTBase)nbt);
            chunkNbt.func_74782_a("DeferredOperations", (NBTBase)operationsNbt);
            data.setChunkNBT(chunk, chunkNbt);
        }
        finally {
            this.decrRegionRef(data, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDeferredOperations(IChunkStorage storage) {
        ChunkPos chunk = storage.getChunk().func_76632_l();
        LocalRegion region = LocalRegion.getFromBlockPos(chunk.field_77276_a * 16, chunk.field_77275_b * 16);
        LocalRegionData data = this.regionCache.getOrCreateRegion(region, false);
        if (data != null) {
            this.incrRegionRef(data);
            try {
                NBTTagCompound chunkNbt = data.getChunkNBT(chunk);
                if (chunkNbt != null && chunkNbt.func_150297_b("DeferredOperations", 9)) {
                    NBTTagList operationsNbt = chunkNbt.func_150295_c("DeferredOperations", 10);
                    for (int i = 0; i < operationsNbt.func_74745_c(); ++i) {
                        NBTTagCompound nbt = operationsNbt.func_150305_b(i);
                        ResourceLocation type = new ResourceLocation(nbt.func_74779_i("type"));
                        Supplier<? extends IDeferredStorageOperation> factory = StorageRegistry.getDeferredOperationFactory(type);
                        if (factory == null) {
                            TheBetweenlands.logger.error("Deferred storage operation type not mapped: " + type + ". Skipping...");
                            continue;
                        }
                        IDeferredStorageOperation operation = factory.get();
                        operation.readFromNBT(nbt.func_74775_l("data"));
                        operation.apply(storage);
                    }
                    chunkNbt.func_82580_o("DeferredOperations");
                    data.setChunkNBT(chunk, chunkNbt);
                }
            }
            finally {
                this.decrRegionRef(data, null, true);
            }
        }
    }

    public LocalStorageSaveHandler getSaveHandler() {
        return this.saveHandler;
    }

    @Override
    public void saveAll() {
        for (ILocalStorage localStorage : this.getLoadedStorages()) {
            if (!localStorage.isDirty()) continue;
            this.saveLocalStorageFile(localStorage);
            localStorage.setDirty(false);
        }
        for (LocalRegionData data : this.pendingUnreferencedRegions.keySet()) {
            if (data.isDirty()) {
                data.saveRegion(this.regionCache.getDir());
            }
            this.regionCache.removeRegion(data.getRegion());
        }
        this.pendingUnreferencedRegions.clear();
        this.regionCache.saveAllRegions();
    }
}

