/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationPortal;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlands.util.MathUtils;

public class AmateMapData
extends MapData {
    public final Int2ObjectMap<BLMapDecoration> decorations = new Int2ObjectOpenHashMap();
    private final IntSet occupiedSpots = new IntOpenHashSet();

    public AmateMapData(String mapname) {
        super(mapname);
    }

    public void addDecoration(BLMapDecoration deco) {
        byte y;
        byte x = deco.func_176112_b();
        int index = x + (y = deco.func_176113_c()) * 128 << 8 | deco.location.id;
        if (!this.decorations.containsKey(index)) {
            int gridSize = 3;
            int area = 24 >> gridSize;
            boolean occupied = false;
            block0: for (int i = -area; i <= area; ++i) {
                for (int j = -area; j <= area; ++j) {
                    int offsetIndex;
                    if (i * i + j * j > area * area || !this.occupiedSpots.contains(offsetIndex = (x >> gridSize) + i + ((y >> gridSize) + j) * (128 >> gridSize) << 8 | deco.location.id)) continue;
                    occupied = true;
                    continue block0;
                }
            }
            if (!occupied) {
                this.occupiedSpots.add((x >> gridSize) + (y >> gridSize) * (128 >> gridSize) << 8 | deco.location.id);
                this.decorations.put(index, (Object)deco);
            } else {
                this.decorations.put(index, (Object)new BLMapDecoration(BLMapDecoration.Location.SMALL_MARKER, deco.func_176112_b(), deco.func_176113_c(), deco.func_176111_d()));
            }
        }
    }

    public void updateMapTexture() {
        MapItemRenderer mapItemRenderer = Minecraft.func_71410_x().field_71460_t.func_147701_i();
        MapItemRenderer.Instance instance = mapItemRenderer.func_148248_b((MapData)this);
        for (int i = 0; i < 16384; ++i) {
            int j = this.field_76198_e[i] & 0xFF;
            instance.field_148241_e[i] = j / 4 == 0 ? this.changeColor((i + i / 128 & 1) * 8 + 16 << 24) : this.changeColor(MapColor.field_76281_a[j / 4].func_151643_b(j & 3));
        }
        instance.field_148243_c.func_110564_a();
    }

    private int changeColor(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int rs = MathHelper.func_76125_a((int)((int)((0.293 * (double)r + 0.269 * (double)g + 0.089 * (double)b) * 5.0)), (int)0, (int)255);
        int rg = MathHelper.func_76125_a((int)((int)((0.049 * (double)r + 0.386 * (double)g + 0.128 * (double)b) * 5.0)), (int)0, (int)255);
        int rb = MathHelper.func_76125_a((int)((int)((0.072 * (double)r + 0.034 * (double)g + 0.111 * (double)b) * 5.0)), (int)0, (int)255);
        return rs << 16 | rg << 8 | rb | rgb >> 24 & 0xFF000000;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        super.func_76184_a(nbt);
        byte[] locationStorage = nbt.func_74770_j("locations");
        if (locationStorage.length > 0) {
            this.deserializeLocations(locationStorage);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound = super.func_189551_b(compound);
        if (this.decorations.size() > 0) {
            compound.func_74773_a("locations", this.serializeLocations());
        }
        return compound;
    }

    public void deserializeLocations(byte[] arr) {
        this.decorations.clear();
        this.occupiedSpots.clear();
        for (int i = 0; i < arr.length / 3; ++i) {
            byte id = arr[i * 3];
            byte mapX = arr[i * 3 + 1];
            byte mapZ = arr[i * 3 + 2];
            byte mapRotation = 8;
            this.addDecoration(new BLMapDecoration(BLMapDecoration.Location.byId(id), mapX, mapZ, mapRotation));
        }
    }

    public byte[] serializeLocations() {
        byte[] storage = new byte[this.decorations.size() * 3];
        int i = 0;
        for (BLMapDecoration location : this.decorations.values()) {
            storage[i * 3] = location.location.id;
            storage[i * 3 + 1] = location.func_176112_b();
            storage[i * 3 + 2] = location.func_176113_c();
            ++i;
        }
        return storage;
    }

    public static class BLMapDecoration
    extends MapDecoration
    implements Comparable<BLMapDecoration> {
        private static final ResourceLocation MAP_ICONS = new ResourceLocation("thebetweenlands", "textures/gui/map_icon_sheet.png");
        private final Location location;

        public BLMapDecoration(Location location, byte xIn, byte yIn, byte rotationIn) {
            super(MapDecoration.Type.TARGET_X, xIn, yIn, rotationIn);
            this.location = location;
        }

        public boolean render(int index) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(MAP_ICONS);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(0.0f + (float)this.func_176112_b() / 2.0f + 64.0f), (float)(0.0f + (float)this.func_176113_c() / 2.0f + 64.0f), (float)-0.02f);
            GlStateManager.func_179114_b((float)((float)(this.func_176111_d() * 360) / 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)this.location.scale, (float)this.location.scale, (float)1.0f);
            GlStateManager.func_179132_a((boolean)false);
            float f1 = this.location.x;
            float f2 = this.location.y;
            float f3 = this.location.x2;
            float f4 = this.location.y2;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(-1.0, 1.0, 0.0).func_187315_a((double)f3, (double)f2).func_181675_d();
            bufferbuilder.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)f1, (double)f2).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 0.0).func_187315_a((double)f1, (double)f4).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 0.0).func_187315_a((double)f3, (double)f4).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BLMapDecoration)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BLMapDecoration that = (BLMapDecoration)o;
            return this.location == that.location;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.location});
        }

        @Override
        public int compareTo(BLMapDecoration o) {
            return Integer.compare(this.location.ordinal(), o.location.ordinal());
        }

        public static enum Location {
            NONE(0, 0, 0, 0, 0, 4.0f),
            SMALL_MARKER(12, 32, 16, 16, 16, 4.0f),
            PORTAL(1, 0, 0, 16, 16, 4.0f),
            SPAWN(2, 16, 0, 16, 16, 4.0f),
            SHRINE(3, 32, 0, 16, 16, 4.0f),
            GIANT_TREE(4, 48, 0, 16, 16, 4.0f),
            RUINS(5, 64, 0, 16, 16, 4.0f),
            TOWER(6, 80, 0, 16, 16, 4.0f),
            IDOL(7, 96, 0, 16, 16, 4.0f),
            WAYSTONE(8, 112, 0, 16, 16, 4.0f),
            BURIAL_MOUND(9, 0, 16, 16, 16, 4.0f),
            SPIRIT_TREE(10, 16, 16, 16, 16, 4.0f),
            FORTRESS(11, 0, 104, 24, 24, 6.0f),
            SLUDGE_WORM_DUNGEON(13, 24, 96, 32, 32, 8.0f),
            FLOATING_ISLAND(14, 48, 16, 16, 16, 4.0f),
            CHECK(127, 0, 32, 16, 16, 4.0f);

            private float x;
            private float y;
            private float x2;
            private float y2;
            private float scale;
            private final byte id;
            public static final ImmutableList<Location> VALUES;

            private Location(int id, int x, int y, int width, int height, float scale) {
                this.id = (byte)id;
                this.x = MathUtils.linearTransformf(x, 0.0f, 128.0f, 0.0f, 1.0f);
                this.y = MathUtils.linearTransformf(y, 0.0f, 128.0f, 0.0f, 1.0f);
                this.x2 = MathUtils.linearTransformf(width + x, 0.0f, 128.0f, 0.0f, 1.0f);
                this.y2 = MathUtils.linearTransformf(height + y, 0.0f, 128.0f, 0.0f, 1.0f);
                this.scale = scale;
            }

            public static Location byId(int id) {
                for (Location location : VALUES) {
                    if (location.id != id) continue;
                    return location;
                }
                return NONE;
            }

            public static Location getLocation(LocationStorage storage) {
                String name;
                if (storage instanceof LocationPortal) {
                    return PORTAL;
                }
                if (storage.getType() == EnumLocationType.WAYSTONE) {
                    return WAYSTONE;
                }
                switch (name = storage.getName()) {
                    case "small_dungeon": {
                        return SHRINE;
                    }
                    case "giant_tree": {
                        return GIANT_TREE;
                    }
                    case "abandoned_shack": 
                    case "ruins": {
                        return RUINS;
                    }
                    case "cragrock_tower": {
                        return TOWER;
                    }
                    case "idol_head": {
                        return IDOL;
                    }
                    case "wight_tower": {
                        return FORTRESS;
                    }
                    case "spirit_tree": {
                        return SPIRIT_TREE;
                    }
                    case "sludge_worm_dungeon": {
                        return SLUDGE_WORM_DUNGEON;
                    }
                    case "floating_island": {
                        return FLOATING_ISLAND;
                    }
                }
                return NONE;
            }

            static {
                VALUES = ImmutableList.copyOf((Object[])Location.values());
            }
        }
    }
}

