/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.block.terrain.BlockLeavesBetweenlands;
import thebetweenlands.common.block.terrain.BlockLogBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.feature.WorldGenHelper;
import thebetweenlands.util.CatmullRomSpline;

public class WorldGenHearthgroveTree
extends WorldGenHelper {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int height = rand.nextInt(4) + 9;
        int canopySize = (int)(rand.nextDouble() * (double)height / 12.0 * 4.0 + 5.0);
        if (!this.rotatedCubeCantReplace(world, x, y + 2, z, 0, 0, 0, 1, height, 1, 0) && !this.rotatedCubeCantReplace(world, x, y + 2, z, -canopySize + 2, 0, -canopySize + 2, canopySize * 2 - 4, height, canopySize * 2 - 4, 0)) {
            IBlockState log = BlockRegistry.LOG_HEARTHGROVE.func_176223_P().func_177226_a((IProperty)BlockLogBetweenlands.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
            IBlockState logY = BlockRegistry.LOG_HEARTHGROVE.func_176223_P().func_177226_a((IProperty)BlockLogBetweenlands.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
            IBlockState leaves = BlockRegistry.LEAVES_HEARTHGROVE_TREE.func_176223_P().func_177226_a((IProperty)BlockLeavesBetweenlands.field_176236_b, (Comparable)Boolean.valueOf(false));
            IBlockState hangers = BlockRegistry.HANGER.func_176223_P();
            int rootHeight = rand.nextInt(3) + 1;
            int canopyStart = canopySize / 2 - 1;
            for (int i = rootHeight; i <= height - canopyStart - 1; ++i) {
                this.func_175903_a(world, pos.func_177981_b(i), logY);
            }
            ArrayList<BlockPos> blobs = new ArrayList<BlockPos>();
            for (int i = 0; i < 4; ++i) {
                blobs.add(new BlockPos(x + rand.nextInt(canopySize * 2) - canopySize, y + height - canopyStart / 2, z + rand.nextInt(canopySize * 2) - canopySize));
            }
            double circumference = Math.PI * (double)(canopySize - 1);
            int branches = (int)(circumference / 4.0) + 1;
            double angleStep = Math.PI * 2 / (double)(branches - 1);
            ArrayList<Pair> leavesSupportPoints = new ArrayList<Pair>();
            ArrayList<BlockPos> subbranchEndpoints = new ArrayList<BlockPos>();
            if (canopySize > 3) {
                for (int i = 0; i < branches; ++i) {
                    BlockPos branchStart = pos.func_177981_b(height - canopyStart - 2);
                    double randRot = rand.nextDouble() * angleStep / 3.0;
                    BlockPos branchEnd = pos.func_177963_a(Math.cos(Math.PI * 2 / (double)(branches - 1) * (double)i + randRot) * (double)(canopySize - 4), (double)(height - canopyStart), Math.sin(Math.PI * 2 / (double)(branches - 1) * (double)i + randRot) * (double)(canopySize - 4));
                    ArrayList<Vec3d> branchPoints = new ArrayList<Vec3d>();
                    branchPoints.add(new Vec3d((Vec3i)branchStart.func_177984_a()));
                    branchPoints.add(new Vec3d((Vec3i)branchStart));
                    branchPoints.add(new Vec3d((Vec3i)branchEnd));
                    branchPoints.add(new Vec3d((Vec3i)branchEnd.func_177984_a()));
                    CatmullRomSpline spline = new CatmullRomSpline(branchPoints.toArray(new Vec3d[0]));
                    BlockPos setBranchPos = null;
                    boolean support = false;
                    int steps = 30;
                    for (int j = 0; j < steps; ++j) {
                        BlockPos branchPos = new BlockPos(spline.interpolate(1.0f / (float)(steps - 1) * (float)j).func_72441_c(0.5, 0.5, 0.5));
                        if (!branchPos.equals(setBranchPos) && world.func_175623_d(branchPos)) {
                            this.func_175903_a(world, branchPos, log);
                            if (!support && branchPos.func_177954_c((double)x, (double)branchPos.func_177956_o(), (double)z) >= 2.5) {
                                EnumFacing supportDir = EnumFacing.func_176737_a((float)(branchPos.func_177958_n() - x), (float)0.0f, (float)(branchPos.func_177952_p() - z));
                                int supportYO = 0;
                                int supportXO = 0;
                                int supportZO = 0;
                                int supportHeight = height - (branchPos.func_177956_o() - y) + (canopySize <= 6 ? -1 : 0);
                                for (int k = 0; k < supportHeight; ++k) {
                                    this.func_175903_a(world, branchPos.func_177982_a(supportXO, 1 + supportYO, supportZO), logY);
                                    if ((k + 1) % 3 == 0) {
                                        supportXO += supportDir.func_82601_c();
                                        supportZO += supportDir.func_82599_e();
                                        ++k;
                                    }
                                    ++supportYO;
                                }
                                leavesSupportPoints.add(Pair.of((Object)branchPos.func_177982_a(supportXO, 1 + supportYO, supportZO), (Object)Float.valueOf(6.0f)));
                                support = true;
                            }
                        }
                        setBranchPos = branchPos;
                    }
                    if (setBranchPos == null) continue;
                    leavesSupportPoints.add(Pair.of(setBranchPos, (Object)Float.valueOf(10.0f)));
                    if (canopySize < 5) continue;
                    subbranchEndpoints.add(setBranchPos);
                }
            }
            float centerSquashX = 0.8f + rand.nextFloat() * 0.4f;
            float centerSquashZ = 0.8f + rand.nextFloat() * 0.4f;
            for (int i = 0; i < canopyStart + 2; ++i) {
                int k = i;
                this.generateCanopyLayer(world, pos.func_177981_b(height - canopyStart + i), canopySize - i, leaves, p -> {
                    boolean nearSupport = false;
                    Random supportRand = new Random();
                    for (Pair support : leavesSupportPoints) {
                        BlockPos supportPos = (BlockPos)support.getKey();
                        supportRand.setSeed(MathHelper.func_180187_c((int)supportPos.func_177958_n(), (int)supportPos.func_177956_o(), (int)supportPos.func_177952_p()));
                        float squashX = 0.6f + supportRand.nextFloat() * 1.2f;
                        float squashY = 0.6f + supportRand.nextFloat() * 1.2f;
                        float squashZ = 0.6f + supportRand.nextFloat() * 1.2f;
                        if (!((float)((supportPos.func_177958_n() - p.func_177958_n()) * (supportPos.func_177958_n() - p.func_177958_n())) * squashX + (float)((supportPos.func_177956_o() - p.func_177956_o()) * (supportPos.func_177956_o() - p.func_177956_o())) * squashY + (float)((supportPos.func_177952_p() - p.func_177952_p()) * (supportPos.func_177952_p() - p.func_177952_p())) * squashZ <= ((Float)support.getValue()).floatValue() + rand.nextFloat() * 0.8f)) continue;
                        nearSupport = true;
                        break;
                    }
                    if (!nearSupport) {
                        return false;
                    }
                    return world.func_175623_d(p) && (k > 1 || canopySize - k < 4 || Math.sqrt((float)((p.func_177958_n() - x) * (p.func_177958_n() - x)) * centerSquashX + (float)((p.func_177952_p() - z) * (p.func_177952_p() - z)) * centerSquashZ) >= (double)((float)(canopySize - k - 3) - rand.nextFloat() * 0.8f));
                }, p -> {
                    if (k == 0 && rand.nextInt(6) == 0) {
                        BlockPos hangerPos;
                        int hangerLength = rand.nextInt(5) + 1;
                        for (int yo = 0; yo < hangerLength && world.func_175623_d(hangerPos = p.func_177979_c(1 + yo)); ++yo) {
                            this.func_175903_a(world, hangerPos, hangers);
                        }
                    }
                });
            }
            for (BlockPos endpoint : subbranchEndpoints) {
                EnumFacing branchDir = EnumFacing.func_176737_a((float)(endpoint.func_177958_n() - x), (float)0.0f, (float)(endpoint.func_177952_p() - z));
                BlockPos branch1 = endpoint.func_177972_a(branchDir).func_177972_a(branchDir.func_176746_e());
                BlockPos branch2 = endpoint.func_177972_a(branchDir).func_177972_a(branchDir.func_176735_f());
                if (world.func_175623_d(branch1)) {
                    this.func_175903_a(world, branch1, log);
                }
                if (!world.func_175623_d(branch2)) continue;
                this.func_175903_a(world, branch2, log);
            }
            boolean[] generatedRoots = new boolean[25];
            int roots = 0;
            for (int i = 0; i < 50 && roots < 3; ++i) {
                int rootX = rand.nextInt(3) - 1;
                int rootZ = rand.nextInt(3) - 1;
                if (rootX == 0 && rootZ == 0) continue;
                int rootIndex = rootX + 1 + 1 + (rootZ + 1 + 1) * 5;
                int rootIndexN = rootIndex - 5;
                int rootIndexS = rootIndex + 5;
                int rootIndexE = rootIndex + 1;
                int rootIndexW = rootIndex - 1;
                if (generatedRoots[rootIndex] || generatedRoots[rootIndexN] || generatedRoots[rootIndexS] || generatedRoots[rootIndexE] || generatedRoots[rootIndexW]) continue;
                int rootXO = 0;
                int rootZO = 0;
                for (int j = rootHeight; j >= -4; --j) {
                    BlockPos rootPos;
                    if (j < rootHeight && rand.nextInt(3) == 0) {
                        EnumFacing offset = EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length)];
                        rootXO += rootX * Math.abs(offset.func_82601_c());
                        rootZO += rootZ * Math.abs(offset.func_82599_e());
                    }
                    if (!world.func_180495_p(rootPos = pos.func_177982_a(rootX + rootXO, j, rootZ + rootZO)).func_177230_c().func_176200_f((IBlockAccess)world, rootPos)) break;
                    this.func_175903_a(world, rootPos, log);
                }
                generatedRoots[rootIndex] = true;
                ++roots;
            }
            return true;
        }
        return false;
    }

    protected void generateCanopyLayer(World world, BlockPos center, int size, IBlockState leaves, @Nullable Predicate<BlockPos> pred, @Nullable Consumer<BlockPos> postprocessor) {
        int x = center.func_177958_n();
        int y = center.func_177956_o();
        int z = center.func_177952_p();
        switch (size) {
            default: {
                int radius = size - 1;
                int span = MathHelper.func_76141_d((float)((float)size / 2.0f));
                span += (span - 1) % 2;
                boolean[] setStates = new boolean[size * 2 * (size * 2)];
                Predicate<BlockPos> fullPred = pos -> {
                    if (pred.test((BlockPos)pos)) {
                        int zo;
                        int xo = pos.func_177958_n() - x;
                        int index = xo + radius + 1 + ((zo = pos.func_177952_p() - z) + radius + 1) * (size * 2);
                        return !setStates[index];
                    }
                    return false;
                };
                Consumer<BlockPos> consumer = pos -> {
                    int zo;
                    int xo = pos.func_177958_n() - x;
                    int index = xo + radius + 1 + ((zo = pos.func_177952_p() - z) + radius + 1) * (size * 2);
                    if (!setStates[index]) {
                        setStates[index] = true;
                    }
                    if (postprocessor != null) {
                        postprocessor.accept((BlockPos)pos);
                    }
                };
                for (int i = 0; i <= span; ++i) {
                    this.rotatedCubeVolume(world, fullPred, x, y, z, -(radius - i), 0, -(span + 2 * i - 1) / 2, leaves, (radius - i) * 2 + 1, 1, span + 2 * i, 0, consumer);
                    this.rotatedCubeVolume(world, fullPred, x, y, z, -(span + 2 * i - 1) / 2, 0, -(radius - i), leaves, span + 2 * i, 1, (radius - i) * 2 + 1, 0, consumer);
                }
                break;
            }
            case 4: {
                this.rotatedCubeVolume(world, pred, x, y, z, -2, 0, -2, leaves, 5, 1, 5, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, -3, 0, 0, leaves, 1, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, 3, 0, 0, leaves, 1, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, 0, 0, -3, leaves, 1, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, 0, 0, 3, leaves, 1, 1, 1, 0, postprocessor);
                break;
            }
            case 3: {
                this.rotatedCubeVolume(world, pred, x, y, z, -1, 0, -1, leaves, 3, 1, 3, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, -2, 0, 0, leaves, 1, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, 2, 0, 0, leaves, 1, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, 0, 0, -2, leaves, 1, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, 0, 0, 2, leaves, 1, 1, 1, 0, postprocessor);
                break;
            }
            case 2: {
                this.rotatedCubeVolume(world, pred, x, y, z, 0, 0, 0, leaves, 2, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, -1, 0, 0, leaves, 1, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, 0, 0, 1, leaves, 1, 1, 1, 0, postprocessor);
                this.rotatedCubeVolume(world, pred, x, y, z, 0, 0, -1, leaves, 1, 1, 1, 0, postprocessor);
                break;
            }
            case 1: {
                this.rotatedCubeVolume(world, pred, x, y, z, 0, 0, 0, leaves, 1, 1, 1, 0, postprocessor);
            }
        }
    }
}

