/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.plant.BlockMoss;

public class WorldGenMossCluster
extends WorldGenerator {
    private final IBlockState blockState;
    private final Block block;
    private final int offset;
    private final int attempts;

    public WorldGenMossCluster(IBlockState blockState, int offset, int attempts) {
        this.blockState = blockState;
        this.block = blockState.func_177230_c();
        this.offset = offset;
        this.attempts = attempts;
    }

    public WorldGenMossCluster(IBlockState blockState) {
        this(blockState, 8, 256);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        boolean generated = false;
        IBlockState iblockstate = worldIn.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, position)) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            iblockstate = worldIn.func_180495_p(position);
        }
        BlockPos.PooledMutableBlockPos mutablePos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < this.attempts; ++i) {
            mutablePos.func_181079_c(position.func_177958_n() + rand.nextInt(this.offset) - rand.nextInt(this.offset), position.func_177956_o() + rand.nextInt(this.offset / 2 + 1) - rand.nextInt(this.offset / 2 + 1), position.func_177952_p() + rand.nextInt(this.offset) - rand.nextInt(this.offset));
            if (!worldIn.func_175697_a((BlockPos)mutablePos, 1) || !worldIn.func_175623_d((BlockPos)mutablePos) || !this.block.func_176196_c(worldIn, (BlockPos)mutablePos)) continue;
            EnumFacing facing = EnumFacing.func_82600_a((int)rand.nextInt(EnumFacing.field_82609_l.length));
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing oppositeFacing = facing.func_176734_d();
            boolean isInvalid = false;
            if (axis.func_176722_c() && !worldIn.isSideSolid(mutablePos.func_177972_a(oppositeFacing), facing, true)) {
                isInvalid = true;
            } else if (axis.func_176720_b() && !this.canPlaceOn(worldIn, mutablePos.func_177972_a(oppositeFacing))) {
                isInvalid = true;
            }
            if (isInvalid) continue;
            IBlockState state = this.blockState.func_177226_a((IProperty)BlockMoss.field_176387_N, (Comparable)facing);
            this.func_175903_a(worldIn, mutablePos.func_185334_h(), state);
            generated = true;
        }
        mutablePos.func_185344_t();
        return generated;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }
}

