/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.decorator;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.terrain.BlockCragrock;
import thebetweenlands.common.registries.BlockRegistry;

public enum SurfaceType implements Predicate<IBlockState>
{
    GRASS((List<Predicate<IBlockState>>)ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)Blocks.field_150349_c), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150391_bh), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SWAMP_GRASS), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.DUG_PURIFIED_SWAMP_GRASS), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.DEAD_GRASS)), new SurfaceType[0]),
    DIRT((List<Predicate<IBlockState>>)ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SWAMP_DIRT), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.PURIFIED_SWAMP_DIRT), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.DUG_SWAMP_DIRT), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150346_d), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.MUD), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.COMPACTED_MUD), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SLUDGY_DIRT), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.PEAT), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.COARSE_SWAMP_DIRT), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SPREADING_SLUDGY_DIRT)), new SurfaceType[0]),
    SAND((List<Predicate<IBlockState>>)ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)Blocks.field_150354_m), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SILT)), new SurfaceType[0]),
    WATER((List<Predicate<IBlockState>>)ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SWAMP_WATER), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150355_j), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150358_i)), new SurfaceType[0]),
    PEAT((List<Predicate<IBlockState>>)ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)BlockRegistry.PEAT)), new SurfaceType[0]),
    MIXED_GROUND((List<Predicate<IBlockState>>)ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)BlockRegistry.CRAGROCK)), GRASS, DIRT, SAND, PEAT),
    UNDERGROUND((List<Predicate<IBlockState>>)ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)BlockRegistry.BETWEENSTONE), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.PITSTONE), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.LIMESTONE), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.OCTINE_ORE), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SCABYST_ORE), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SLIMY_BONE_ORE), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SULFUR_ORE), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.SYRMORITE_ORE), (Object)BlockMatcher.func_177642_a((Block)BlockRegistry.VALONITE_ORE)), new SurfaceType[0]),
    GRASS_AND_DIRT(GRASS, DIRT),
    MIXED_GROUND_AND_UNDERGROUND(MIXED_GROUND, UNDERGROUND),
    MIXED_GROUND_OR_REPLACEABLE((List<Predicate<IBlockState>>)ImmutableList.of(state -> state.func_185904_a().func_76222_j()), MIXED_GROUND),
    CRAGROCK_MOSSY((List<Predicate<IBlockState>>)ImmutableList.of(state -> state.func_177230_c() == BlockRegistry.CRAGROCK && state.func_177229_b(BlockCragrock.VARIANT) != BlockCragrock.EnumCragrockType.DEFAULT), new SurfaceType[0]),
    PLANT_DECORATION_SOIL((List<Predicate<IBlockState>>)ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)BlockRegistry.GIANT_ROOT)), GRASS_AND_DIRT, CRAGROCK_MOSSY);

    private final List<Predicate<IBlockState>> matchers;
    private final SurfaceType[] types;

    private SurfaceType(List<Predicate<IBlockState>> matchers, SurfaceType ... types) {
        this.matchers = matchers;
        this.types = types;
    }

    private SurfaceType(SurfaceType ... types) {
        this((List<Predicate<IBlockState>>)null, types);
    }

    public boolean apply(IBlockState input) {
        if (input == null) {
            return false;
        }
        if (this.types != null && this.types.length > 0) {
            for (SurfaceType type : this.types) {
                if (!type.apply(input)) continue;
                return true;
            }
        }
        if (this.matchers != null) {
            for (Predicate predicate : this.matchers) {
                if (!predicate.apply((Object)input)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(World world, BlockPos pos) {
        return world.func_175667_e(pos) && this.apply(world.func_180495_p(pos));
    }

    public boolean matches(IBlockState state) {
        return this.apply(state);
    }
}

