/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome;

public class BiomeWeights {
    private final float[] weights = new float[256];

    public BiomeWeights(float[] weights) {
        for (int i = 0; i < weights.length; ++i) {
            this.weights[i] = weights[i];
        }
    }

    public float get(int x, int z) {
        return this.weights[x * 16 + z];
    }

    public float get(int x, int z, float min, float max) {
        float blockDst = this.get(x, z) * 34.0f;
        if (blockDst >= min && blockDst <= max) {
            return (blockDst - min) / (max - min);
        }
        if (blockDst < min) {
            return 0.0f;
        }
        return 1.0f;
    }
}

