/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.sky.RiftVariant;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.network.clientbound.MessageRiftSound;
import thebetweenlands.common.network.datamanager.GenericDataManager;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventRift
extends TimedEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "rift");
    private static final int MAX_ACTIVATION_TICKS = 350;
    protected static final DataParameter<RiftConfiguration> RIFT_CONFIGURATION = GenericDataManager.createKey(EventRift.class, RiftConfiguration::write, RiftConfiguration::new);
    protected static final DataParameter<Integer> ACTIVATION_TICKS = GenericDataManager.createKey(EventRift.class, DataSerializers.field_187192_b);
    protected static final ResourceLocation[] VISION_TEXTURES = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/events/rift.png")};
    protected int lastActivationTicks;
    protected int soundTicks;
    protected boolean playRiftOpenSound = true;

    public EventRift(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    protected void initDataParameters() {
        super.initDataParameters();
        this.dataManager.register(ACTIVATION_TICKS, 10, 0);
        this.dataManager.register(RIFT_CONFIGURATION, new RiftConfiguration(0, 0.0f, 0.0f, 0.0f, 1.0f, false, false));
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        if (this.getRegistry().isDisabled()) {
            this.lastActivationTicks = 0;
            this.dataManager.set(ACTIVATION_TICKS, 0).syncImmediately();
        } else {
            this.playRiftOpenSound = false;
            this.setRandomConfiguration();
            this.setActive(true);
            this.playRiftOpenSound = true;
            this.lastActivationTicks = 350;
            this.dataManager.set(ACTIVATION_TICKS, 350).syncImmediately();
        }
    }

    @Override
    public int getOffTime(Random rnd) {
        return 12000 + rnd.nextInt(6000);
    }

    @Override
    public int getOnTime(Random rnd) {
        return 28800 + rnd.nextInt(7200);
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public void setActive(boolean active) {
        if (!this.getWorld().field_72995_K && active && !this.isActive() && this.getActivationTicks() == 0) {
            this.setRandomConfiguration();
            if (this.playRiftOpenSound) {
                TheBetweenlands.networkWrapper.sendToDimension((IMessage)new MessageRiftSound(MessageRiftSound.RiftSoundType.OPEN), BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
            }
        }
        super.setActive(active);
    }

    protected void setRandomConfiguration() {
        this.dataManager.set(RIFT_CONFIGURATION, new RiftConfiguration(this.getWorld().field_73012_v.nextInt(Integer.MAX_VALUE), this.getWorld().field_73012_v.nextFloat(), this.getWorld().field_73012_v.nextFloat(), this.getWorld().field_73012_v.nextFloat(), this.getWorld().field_73012_v.nextFloat(), this.getWorld().field_73012_v.nextBoolean(), this.getWorld().field_73012_v.nextBoolean()));
    }

    @Override
    public void update(World world) {
        super.update(world);
        this.lastActivationTicks = this.getActivationTicks();
        if (this.isActive()) {
            if (this.getActivationTicks() < 350) {
                if (this.getActivationTicks() == 108) {
                    this.dataManager.set(ACTIVATION_TICKS, this.getActivationTicks() + 180).syncImmediately();
                }
                this.dataManager.set(ACTIVATION_TICKS, this.getActivationTicks() + 1);
            } else if (this.getActivationTicks() != 350) {
                this.dataManager.set(ACTIVATION_TICKS, 350).syncImmediately();
            }
        } else {
            if (this.getActivationTicks() > 0) {
                this.dataManager.set(ACTIVATION_TICKS, this.getActivationTicks() - 4);
            }
            if (this.getActivationTicks() < 0) {
                this.dataManager.set(ACTIVATION_TICKS, 0).syncImmediately();
            }
        }
        if (!this.getWorld().field_72995_K) {
            int remainingTicks = this.getTicks();
            if ((!this.isActive() && remainingTicks < 1800 && remainingTicks > 80 || this.isActive() && remainingTicks < 1800 && remainingTicks > 80) && this.soundTicks-- <= 0) {
                TheBetweenlands.networkWrapper.sendToDimension((IMessage)new MessageRiftSound(MessageRiftSound.RiftSoundType.CREAK), BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
                this.soundTicks = this.getWorld().field_73012_v.nextInt(150) + 100;
            }
        }
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        NBTTagCompound nbt = this.getData();
        nbt.func_74768_a("riftTicks", this.getActivationTicks());
        this.getRiftConfiguration().writeToNBT(nbt);
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        NBTTagCompound nbt = this.getData();
        this.dataManager.set(ACTIVATION_TICKS, nbt.func_74762_e("riftTicks")).syncImmediately();
        this.dataManager.set(RIFT_CONFIGURATION, new RiftConfiguration(nbt));
    }

    public float getVisibility(float partialTicks) {
        return ((float)this.lastActivationTicks + (float)(this.getActivationTicks() - this.lastActivationTicks) * partialTicks) / 350.0f;
    }

    public int getActivationTicks() {
        return this.dataManager.get(ACTIVATION_TICKS);
    }

    public RiftConfiguration getRiftConfiguration() {
        return this.dataManager.get(RIFT_CONFIGURATION);
    }

    @SideOnly(value=Side.CLIENT)
    public RiftVariant getVariant() {
        List<RiftVariant> availableVariants = TheBetweenlands.proxy.getRiftVariants();
        if (availableVariants.isEmpty()) {
            return RiftVariant.DEFAULT;
        }
        return availableVariants.get(this.getRiftConfiguration().riftSeed % availableVariants.size());
    }

    @SideOnly(value=Side.CLIENT)
    public float getRiftScale(float partialTicks) {
        RiftVariant variant = this.getVariant();
        return variant.getMinScale() + this.getRiftConfiguration().scaleComponent * (variant.getMaxScale() - variant.getMinScale());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getRiftMirrorU() {
        return this.getRiftConfiguration().mirrorU && this.getVariant().getMirrorU();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getRiftMirrorV() {
        return this.getRiftConfiguration().mirrorV && this.getVariant().getMirrorV();
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getRiftAngles(float partialTicks) {
        RiftVariant variant = this.getVariant();
        RiftConfiguration configuration = this.getRiftConfiguration();
        return new float[]{variant.getMinYaw() + configuration.yawComponent * (variant.getMaxYaw() - variant.getMinYaw()), variant.getMinPitch() + configuration.pitchComponent * (variant.getMaxPitch() - variant.getMinPitch()), variant.getMinRoll() + configuration.rollComponent * (variant.getMaxRoll() - variant.getMinRoll())};
    }

    @Override
    public ResourceLocation[] getVisionTextures() {
        return VISION_TEXTURES;
    }

    @Override
    public SoundEvent getChimesSound() {
        return SoundRegistry.CHIMES_RIFT;
    }

    public static class RiftConfiguration {
        public final int riftSeed;
        public final float yawComponent;
        public final float pitchComponent;
        public final float rollComponent;
        public final float scaleComponent;
        public final boolean mirrorU;
        public final boolean mirrorV;

        public RiftConfiguration(int riftSeed, float yawComponent, float pitchComponent, float rollComponent, float scaleComponent, boolean mirrorU, boolean mirrorV) {
            this.riftSeed = riftSeed;
            this.yawComponent = yawComponent;
            this.pitchComponent = pitchComponent;
            this.rollComponent = rollComponent;
            this.scaleComponent = scaleComponent;
            this.mirrorU = mirrorU;
            this.mirrorV = mirrorV;
        }

        public RiftConfiguration(PacketBuffer buf) {
            this.riftSeed = buf.readInt();
            this.yawComponent = buf.readFloat();
            this.pitchComponent = buf.readFloat();
            this.rollComponent = buf.readFloat();
            this.scaleComponent = buf.readFloat();
            this.mirrorU = buf.readBoolean();
            this.mirrorV = buf.readBoolean();
        }

        public RiftConfiguration(NBTTagCompound nbt) {
            this.yawComponent = nbt.func_74760_g("yaw");
            this.pitchComponent = nbt.func_74760_g("pitch");
            this.rollComponent = nbt.func_74760_g("roll");
            this.riftSeed = Math.max(nbt.func_74762_e("riftSeed"), 0);
            this.mirrorU = nbt.func_74767_n("mirrorU");
            this.mirrorV = nbt.func_74767_n("mirrorV");
            this.scaleComponent = nbt.func_74760_g("scale");
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74776_a("yaw", this.yawComponent);
            nbt.func_74776_a("pitch", this.pitchComponent);
            nbt.func_74776_a("roll", this.rollComponent);
            nbt.func_74768_a("riftSeed", this.riftSeed);
            nbt.func_74757_a("mirrorU", this.mirrorU);
            nbt.func_74757_a("mirrorV", this.mirrorV);
            nbt.func_74776_a("scale", this.scaleComponent);
            return nbt;
        }

        public static void write(PacketBuffer buf, RiftConfiguration configuration) {
            buf.writeInt(configuration.riftSeed);
            buf.writeFloat(configuration.yawComponent);
            buf.writeFloat(configuration.pitchComponent);
            buf.writeFloat(configuration.rollComponent);
            buf.writeFloat(configuration.scaleComponent);
            buf.writeBoolean(configuration.mirrorU);
            buf.writeBoolean(configuration.mirrorV);
        }
    }
}

