/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventBloodSky
extends TimedEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "blood_sky");
    protected static final ResourceLocation[] VISION_TEXTURES = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/events/blood_sky.png")};
    private boolean soundPlayed = true;
    private float skyTransparency = 0.0f;
    private float lastSkyTransparency = 0.0f;

    public EventBloodSky(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    public void setSkyTransparency(float transparency) {
        this.lastSkyTransparency = this.skyTransparency;
        this.skyTransparency = transparency;
    }

    public float getSkyTransparency(float partialTicks) {
        return this.skyTransparency + (this.skyTransparency - this.lastSkyTransparency) * partialTicks;
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(400000) + 500000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(8000) + 20000;
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (world.field_72995_K) {
            if (this.isActive()) {
                if (this.skyTransparency < 1.0f) {
                    this.setSkyTransparency(this.skyTransparency + 0.003f);
                }
                if (this.skyTransparency > 1.0f) {
                    this.setSkyTransparency(1.0f);
                }
            } else {
                if (this.skyTransparency > 0.0f) {
                    this.setSkyTransparency(this.skyTransparency - 0.003f);
                }
                if (this.skyTransparency < 0.0f) {
                    this.setSkyTransparency(0.0f);
                }
            }
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            World world = TheBetweenlands.proxy.getClientWorld();
            if (world != null && world.field_72995_K && !this.soundPlayed) {
                world.func_184134_a(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v, (SoundEvent)SoundRegistry.AMBIENT_BLOOD_SKY_ROAR, SoundCategory.AMBIENT, 100.0f, 1.0f, false);
            }
            this.soundPlayed = true;
        } else {
            this.soundPlayed = false;
        }
    }

    @Override
    public ResourceLocation[] getVisionTextures() {
        return VISION_TEXTURES;
    }

    @Override
    public SoundEvent getChimesSound() {
        return SoundRegistry.CHIMES_BLOOD_SKY;
    }
}

