/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning.spawners;

import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.world.biome.spawning.AreaMobSpawner;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class PitstoneCaveSpawnEntry
extends AreaMobSpawner.BLSpawnEntry {
    protected boolean canSpawnOnWater = false;
    protected boolean canSpawnInWater = false;
    protected boolean constantWeight = false;

    public PitstoneCaveSpawnEntry(int id, Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor) {
        super(id, entityType, entityCtor);
    }

    public PitstoneCaveSpawnEntry(int id, Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor, short baseWeight) {
        super(id, entityType, entityCtor, baseWeight);
    }

    public PitstoneCaveSpawnEntry setCanSpawnOnWater(boolean spawnOnWater) {
        this.canSpawnOnWater = spawnOnWater;
        return this;
    }

    public PitstoneCaveSpawnEntry setCanSpawnInWater(boolean spawnInWater) {
        this.canSpawnInWater = spawnInWater;
        return this;
    }

    public PitstoneCaveSpawnEntry setConstantWeight(boolean constant) {
        this.constantWeight = constant;
        return this;
    }

    @Override
    public void update(World world, BlockPos pos) {
        short spawnWeight;
        int surfaceHeight = 45;
        if (pos.func_177956_o() < surfaceHeight) {
            if (this.constantWeight) {
                spawnWeight = this.getBaseWeight();
            } else {
                double percentage = 1.0 - (double)(surfaceHeight - pos.func_177956_o()) / (double)surfaceHeight;
                spawnWeight = (short)MathHelper.func_76143_f((double)((double)this.getBaseWeight() / (2.0 * percentage + 1.0)));
            }
        } else {
            spawnWeight = 0;
        }
        this.setWeight(spawnWeight);
    }

    @Override
    public boolean canSpawn(World world, Chunk chunk, BlockPos pos, IBlockState spawnBlockState, IBlockState surfaceBlockState) {
        return !spawnBlockState.func_185915_l() && (SurfaceType.MIXED_GROUND_AND_UNDERGROUND.matches(surfaceBlockState) && !spawnBlockState.func_185904_a().func_76224_d() || this.canSpawnInWater && spawnBlockState.func_185904_a().func_76224_d() || this.canSpawnOnWater && surfaceBlockState.func_185904_a().func_76224_d() && !spawnBlockState.func_185904_a().func_76224_d());
    }
}

