/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntriesProvider;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.api.entity.spawning.IWeightProvider;
import thebetweenlands.api.event.InitializeBetweenlandsBiomeEvent;
import thebetweenlands.common.entity.EntityCCGroundSpawner;
import thebetweenlands.common.entity.EntityWormGroundSpawner;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityPeatMummy;
import thebetweenlands.common.entity.mobs.EntityPyrad;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.spawning.spawners.ConditionalSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.LocationSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.WallSpawnEntry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;
import thebetweenlands.common.world.storage.location.EnumLocationType;

public class BiomeBetweenlands
extends Biome
implements IWeightProvider,
ICustomSpawnEntriesProvider {
    private final List<ICustomSpawnEntry> blSpawnEntries = new ArrayList<ICustomSpawnEntry>();
    private int grassColor = -1;
    private int foliageColor = -1;
    private int secondaryGrassColor = -1;
    private int secondaryFoliageColor = -1;
    private short biomeWeight;
    private BiomeGenerator biomeGenerator;
    private int[] fogColorRGB = new int[]{255, 255, 255};

    public BiomeBetweenlands(ResourceLocation registryName, Biome.BiomeProperties properties) {
        super(properties);
        this.setRegistryName(registryName);
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.biomeWeight = (short)100;
        this.field_76752_A = BlockRegistry.SWAMP_GRASS.func_176223_P();
        this.field_76753_B = BlockRegistry.SWAMP_DIRT.func_176223_P();
        this.biomeGenerator = new BiomeGenerator(this);
        this.setFogColor(10, 30, 22);
        ArrayList<ICustomSpawnEntry> spawnEntries = new ArrayList<ICustomSpawnEntry>();
        this.addSpawnEntries(spawnEntries);
        MinecraftForge.EVENT_BUS.post((Event)new InitializeBetweenlandsBiomeEvent(this, spawnEntries));
        this.blSpawnEntries.addAll(spawnEntries);
    }

    protected void addSpawnEntries(List<ICustomSpawnEntry> entries) {
        BiPredicate<World, BlockPos> bloodSkyPredicate = ConditionalSpawnEntry.createEventPredicate(new ResourceLocation("thebetweenlands", "blood_sky"));
        BiPredicate<World, BlockPos> heavyRainPredictate = ConditionalSpawnEntry.createEventPredicate(new ResourceLocation("thebetweenlands", "heavy_rain"));
        entries.add(new ConditionalSpawnEntry(800, new SurfaceSpawnEntry(-1, EntityFirefly.class, EntityFirefly::new, 280), bloodSkyPredicate).setSpawnCheckRadius(16.0).setGroupSize(1, 4));
        entries.add(new ConditionalSpawnEntry(801, new SurfaceSpawnEntry(-1, EntitySwampHag.class, EntitySwampHag::new, 250), bloodSkyPredicate){

            @Override
            public EntityLiving createEntity(World world) {
                EntityLiving entity = super.createEntity(world);
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
                entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
                return entity;
            }
        }.setHostile(true));
        entries.add(new ConditionalSpawnEntry(802, new SurfaceSpawnEntry(-1, EntityPeatMummy.class, EntityPeatMummy::new, 65), bloodSkyPredicate){

            @Override
            public EntityLiving createEntity(World world) {
                EntityLiving entity = super.createEntity(world);
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27500000298023225);
                entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
                return entity;
            }
        }.setHostile(true).setSpawnCheckRadius(20.0));
        entries.add(new ConditionalSpawnEntry(804, new WallSpawnEntry(-1, EntityCCGroundSpawner.class, EntityCCGroundSpawner::new, 120), bloodSkyPredicate).setSpawnCheckRadius(32.0).setGroupSize(1, 1).setHostile(true));
        entries.add(new ConditionalSpawnEntry(805, new WallSpawnEntry(-1, EntityWormGroundSpawner.class, EntityWormGroundSpawner::new, 120), heavyRainPredictate).setSpawnCheckRadius(32.0).setGroupSize(1, 1).setHostile(true));
        entries.add(new LocationSpawnEntry(803, EntityPyrad.class, EntityPyrad::new, 120, EnumLocationType.GIANT_TREE){

            @Override
            public boolean canSpawn(World world, Chunk chunk, BlockPos pos, IBlockState blockState, IBlockState surfaceBlockState) {
                return !blockState.func_185915_l() && SurfaceType.MIXED_GROUND.matches(surfaceBlockState);
            }
        }.setHostile(true).setSpawnCheckRadius(50.0).setSpawningInterval(5000));
    }

    protected final BiomeBetweenlands setBiomeGenerator(BiomeGenerator generator) {
        if (generator.getBiome() != this) {
            throw new RuntimeException("Generator was assigned to a different biome!");
        }
        this.biomeGenerator = generator;
        return this;
    }

    public final BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public final List<ICustomSpawnEntry> getCustomSpawnEntries() {
        return Collections.unmodifiableList(this.blSpawnEntries);
    }

    protected final BiomeBetweenlands setWeight(int weight) {
        this.biomeWeight = (short)weight;
        return this;
    }

    public final BiomeBetweenlands setFoliageColors(int grassColor, int foliageColor) {
        this.grassColor = grassColor;
        this.foliageColor = foliageColor;
        return this;
    }

    public final BiomeBetweenlands setSecondaryFoliageColors(int grassColor, int foliageColor) {
        this.secondaryGrassColor = grassColor;
        this.secondaryFoliageColor = foliageColor;
        return this;
    }

    public final BiomeBetweenlands setFogColor(int red, int green, int blue) {
        this.fogColorRGB[0] = red;
        this.fogColorRGB[1] = green;
        this.fogColorRGB[2] = blue;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        if (this.secondaryGrassColor < 0) {
            if (this.grassColor < 0) {
                return super.func_180627_b(pos);
            }
            return this.grassColor;
        }
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        if (noise < -0.1) {
            if (this.grassColor < 0) {
                return super.func_180627_b(pos);
            }
            return this.grassColor;
        }
        if (this.secondaryGrassColor < 0) {
            return super.func_180627_b(pos);
        }
        return this.secondaryGrassColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        if (this.secondaryFoliageColor < 0) {
            if (this.foliageColor < 0) {
                return super.func_180627_b(pos);
            }
            return this.foliageColor;
        }
        double noise = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        if (noise < -0.1) {
            if (this.foliageColor < 0) {
                return super.func_180627_b(pos);
            }
            return this.foliageColor;
        }
        if (this.secondaryFoliageColor < 0) {
            return super.func_180627_b(pos);
        }
        return this.secondaryFoliageColor;
    }

    @Override
    public final short getWeight() {
        return this.biomeWeight;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFogStart(float farPlaneDistance, int mode) {
        return mode == -1 ? 0.0f : farPlaneDistance * 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFogEnd(float farPlaneDistance, int mode) {
        return farPlaneDistance;
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getFogRGB() {
        return this.fogColorRGB;
    }

    public void updateFog() {
    }

    public void addTypes() {
    }
}

