/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.FluidTankTile;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityWaterFilter
extends TileEntityBasicInventory
implements ITickable {
    public FluidTankTile tank = new FluidTankTile(4000);
    private IItemHandler itemHandler;
    public boolean showFluidAnimation;

    public TileEntityWaterFilter() {
        super(5, "container.bl.water_filter");
        this.tank.setTileEntity(this);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.func_145831_w().func_82737_E() % 10L == 0L) {
            IFluidHandler recepticle;
            IFluidTankProperties[] tankProperties;
            EnumFacing facing = EnumFacing.DOWN;
            TileEntity tileToFill = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tileToFill != null && tileToFill.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) && (tankProperties = (recepticle = (IFluidHandler)tileToFill.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())).getTankProperties()) != null) {
                for (IFluidTankProperties properties : tankProperties) {
                    if (properties == null || !properties.canFill() && properties.getCapacity() <= 0) continue;
                    FluidStack tankFluid = this.tank.drain(20, false);
                    if (tankFluid != null) {
                        int filled = recepticle.fill(this.getResultFluid(tankFluid), true);
                        FluidStack drained = this.tank.drain(filled, true);
                        if (drained != null && this.hasFilter()) {
                            if (drained.amount >= 20) {
                                this.addByProductRandom(this.func_145831_w().field_73012_v, drained.getFluid());
                            }
                            this.damageFilter(1);
                        }
                        if (!this.getFluidAnimation()) {
                            this.setFluidAnimation(true);
                        }
                        this.markForUpdate();
                        continue;
                    }
                    if (tankFluid != null && tankFluid.amount != 0 || !this.getFluidAnimation()) continue;
                    this.setFluidAnimation(false);
                    this.markForUpdate();
                }
            }
        }
        if (!this.func_145831_w().field_72995_K && this.tank.getFluid() == null && this.getFluidAnimation()) {
            this.setFluidAnimation(false);
            this.markForUpdate();
        }
    }

    public FluidStack getResultFluid(FluidStack fluid) {
        if (this.hasFilter()) {
            if (fluid.getFluid() == FluidRegistry.STAGNANT_WATER) {
                return new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, fluid.amount);
            }
            if (fluid.getFluid() == FluidRegistry.SWAMP_WATER) {
                return new FluidStack(FluidRegistry.CLEAN_WATER, fluid.amount);
            }
        }
        return fluid.copy();
    }

    public void setFluidAnimation(boolean showFluid) {
        this.showFluidAnimation = showFluid;
    }

    public boolean getFluidAnimation() {
        return this.showFluidAnimation;
    }

    private void addByProductRandom(Random rand, Fluid fluid) {
        if (rand.nextInt(50) == 0) {
            ItemStack stack = ItemStack.field_190927_a;
            if (fluid == FluidRegistry.STAGNANT_WATER) {
                stack = this.chooseRandomItemFromLootTable(this.getStagnantWaterLootTable());
            }
            if (fluid == FluidRegistry.SWAMP_WATER) {
                stack = this.chooseRandomItemFromLootTable(this.getSwampWaterLootTable());
            }
            for (int slot = 1; slot < 5 && !this.inventoryHandler.insertItem(slot, stack, false).func_190926_b(); ++slot) {
            }
        }
    }

    protected ResourceLocation getStagnantWaterLootTable() {
        return LootTableRegistry.FILTERED_STAGNANT_WATER;
    }

    protected ResourceLocation getSwampWaterLootTable() {
        return LootTableRegistry.FILTERED_SWAMP_WATER;
    }

    public ItemStack chooseRandomItemFromLootTable(ResourceLocation resourceLocation) {
        LootContext.Builder lootBuilder;
        List loot;
        LootTable lootTable = this.func_145831_w().func_184146_ak().func_186521_a(resourceLocation);
        if (lootTable != null && !(loot = lootTable.func_186462_a(this.field_145850_b.field_73012_v, (lootBuilder = new LootContext.Builder((WorldServer)this.field_145850_b)).func_186471_a())).isEmpty()) {
            Collections.shuffle(loot);
            return (ItemStack)loot.get(0);
        }
        return new ItemStack(ItemRegistry.GLUE);
    }

    private void damageFilter(int damage) {
        ItemStack mesh = this.func_70301_a(0);
        if (!mesh.func_190926_b()) {
            mesh.func_77964_b(mesh.func_77952_i() + 1);
            if (mesh.func_77952_i() > mesh.func_77958_k()) {
                mesh.func_190918_g(1);
                this.func_145831_w().func_175718_b(2001, this.func_174877_v(), Block.func_149682_b((Block)BlockRegistry.WEEDWOOD_PLANKS));
            }
        }
    }

    public boolean hasFilter() {
        return this.hasMossFilter() || this.hasSilkFilter();
    }

    public boolean hasMossFilter() {
        return !this.func_70301_a(0).func_190926_b() && this.func_70301_a(0).func_77973_b() == ItemRegistry.MOSS_FILTER;
    }

    public boolean hasSilkFilter() {
        return !this.func_70301_a(0).func_190926_b() && this.func_70301_a(0).func_77973_b() == ItemRegistry.SILK_FILTER;
    }

    public int getTankFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readPacketNbt(packet.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writePacketNbt(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writePacketNbt(tag);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.readPacketNbt(nbt);
    }

    protected NBTTagCompound writePacketNbt(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("showFluidAnimation", this.showFluidAnimation);
        this.writeInventoryNBT(nbt);
        return nbt;
    }

    protected void readPacketNbt(NBTTagCompound nbt) {
        NBTTagCompound compound = nbt;
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.setFluidAnimation(compound.func_74767_n("showFluidAnimation"));
        this.readInventoryNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.setFluidAnimation(tagCompound.func_74767_n("showFluidAnimation"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        tagCompound.func_74757_a("showFluidAnimation", this.showFluidAnimation);
        return tagCompound;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        int[] SLOTS = new int[this.func_70302_i_()];
        for (int index = 0; index < SLOTS.length; ++index) {
            SLOTS[index] = index;
        }
        return SLOTS;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }
}

