/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thebetweenlands.common.item.EnumBLDrinkableBrew;
import thebetweenlands.common.item.EnumBLDyeColor;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.SteepingPotRecipes;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntitySteepingPot
extends TileEntityBasicInventory
implements ITickable {
    public FluidTank tank = new FluidTank(null, 1000);
    public int tempFluidColour;
    private IItemHandler itemHandler;
    public boolean hasCraftResult = false;
    private int heatProgress = 0;
    private boolean heated = false;
    private NonNullList<ItemStack> inventoryBundle;
    public int itemRotate = 0;
    public int prevItemRotate = 0;
    public int prevItemBob = 0;
    public int itemBob = 0;
    private boolean countUp = true;

    public TileEntitySteepingPot() {
        super(1, "container.bl.boiling_pot");
        this.tank.setTileEntity((TileEntity)this);
    }

    public void func_73660_a() {
        this.prevItemRotate = this.itemRotate;
        this.prevItemBob = this.itemBob;
        if (this.func_145831_w().field_72995_K) {
            if (this.countUp && this.itemBob <= 20) {
                ++this.itemBob;
                if (this.itemBob == 20) {
                    this.countUp = false;
                }
            }
            if (!this.countUp && this.itemBob >= -20) {
                --this.itemBob;
                if (this.itemBob == -20) {
                    this.countUp = true;
                }
            }
            if (this.getHeatProgress() > 80 && this.hasBundle()) {
                if (this.itemRotate < 180) {
                    ++this.itemRotate;
                }
                if (this.itemRotate >= 180) {
                    this.itemRotate = 0;
                    this.prevItemRotate = 0;
                }
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            int outputFluidMeta;
            FluidStack fluidWithTag;
            FluidStack outputFluid;
            if (this.getTankFluidAmount() >= 1000 && !this.hasCraftResult) {
                if (this.hasBundle()) {
                    SteepingPotRecipes recipe = this.getCraftResult(this.tank, (ItemStack)this.getBundleItems().get(0), (ItemStack)this.getBundleItems().get(1), (ItemStack)this.getBundleItems().get(2), (ItemStack)this.getBundleItems().get(3));
                    outputFluid = null;
                    fluidWithTag = null;
                    outputFluidMeta = 0;
                    if (recipe != null) {
                        outputFluid = recipe.getOutputFluidStack();
                        outputFluidMeta = recipe.getOutputFluidMeta();
                        if (outputFluid != null) {
                            if (outputFluid.getFluid() == FluidRegistry.DYE_FLUID) {
                                this.setTempFluidColour(EnumBLDyeColor.byMetadata(outputFluidMeta).getColorValue() | 0xFF000000);
                            }
                            if (outputFluid.getFluid() == FluidRegistry.DRINKABLE_BREW) {
                                this.setTempFluidColour(EnumBLDrinkableBrew.byMetadata(outputFluidMeta).getColorValue() | 0xFF000000);
                            }
                            this.hasCraftResult = true;
                        }
                    }
                } else {
                    this.setTempFluidColour(this.tank.getFluid().getFluid().getColor());
                    this.hasCraftResult = true;
                }
                this.markForUpdate();
            }
            if (this.isHeatSource(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()))) {
                if (this.getHeatProgress() < 100 && this.getTankFluidAmount() > 0) {
                    if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                        this.setHeatProgress(this.getHeatProgress() + 1);
                        this.markForUpdate();
                    }
                } else if (this.tank.getFluid() == null && this.getHeatProgress() != 0) {
                    this.setHeatProgress(0);
                    this.markForUpdate();
                }
            }
            if (!this.isHeatSource(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())) && this.getHeatProgress() > 0) {
                if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                    this.setHeatProgress(this.getHeatProgress() - 1);
                    this.markForUpdate();
                } else if (this.tank.getFluid() == null && this.getHeatProgress() != 0) {
                    this.setHeatProgress(0);
                    this.markForUpdate();
                }
            }
            if (this.getTankFluidAmount() >= 1000 && this.getHeatProgress() >= 100 && this.hasBundle()) {
                ItemStack output = ItemStack.field_190927_a;
                outputFluid = null;
                fluidWithTag = null;
                outputFluidMeta = 0;
                SteepingPotRecipes recipe = this.getCraftResult(this.tank, (ItemStack)this.getBundleItems().get(0), (ItemStack)this.getBundleItems().get(1), (ItemStack)this.getBundleItems().get(2), (ItemStack)this.getBundleItems().get(3));
                if (recipe == null) {
                    this.setHeatProgress(0);
                    if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                        this.func_70299_a(0, ItemMisc.EnumItemMisc.SILK_BUNDLE_DIRTY.create(1));
                    }
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.3f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f);
                    this.tank.drain(1000, true);
                    return;
                }
                if (recipe != null) {
                    output = recipe.getOutputItem();
                    outputFluid = recipe.getOutputFluidStack();
                    outputFluidMeta = recipe.getOutputFluidMeta();
                    if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                        this.func_70299_a(0, ItemMisc.EnumItemMisc.SILK_BUNDLE_DIRTY.create(1));
                    }
                    this.tank.drain(1000, true);
                    if (outputFluid != null) {
                        if (outputFluid.getFluid() == FluidRegistry.DYE_FLUID || outputFluid.getFluid() == FluidRegistry.DRINKABLE_BREW) {
                            NBTTagCompound nbt = new NBTTagCompound();
                            nbt.func_74768_a("type", outputFluidMeta);
                            fluidWithTag = new FluidStack(outputFluid.getFluid(), 1000, nbt);
                            this.tank.fill(fluidWithTag, true);
                        } else {
                            this.tank.fill(outputFluid, true);
                        }
                    } else {
                        TileEntitySteepingPot.spawnItemStack(this.func_145831_w(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                    }
                    EntityXPOrb orb = new EntityXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1);
                    this.field_145850_b.func_72838_d((Entity)orb);
                    this.hasCraftResult = false;
                    this.markForUpdate();
                }
            }
        }
    }

    private void setTempFluidColour(int type) {
        this.tempFluidColour = type;
    }

    public SteepingPotRecipes getCraftResult(FluidTank tank, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
        return SteepingPotRecipes.getRecipe((IFluidTank)tank, stack1, stack2, stack3, stack4);
    }

    public boolean hasBundle() {
        ItemStack bundle = this.func_70301_a(0);
        return !bundle.func_190926_b() && bundle.func_77973_b() == ItemRegistry.SILK_BUNDLE && bundle.func_77942_o() && bundle.func_77978_p().func_74764_b("Items");
    }

    private NonNullList<ItemStack> getBundleItems() {
        ItemStack bundle = this.func_70301_a(0);
        this.inventoryBundle = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        if (!bundle.func_190926_b() && bundle.func_77973_b() == ItemRegistry.SILK_BUNDLE && bundle.func_77942_o() && bundle.func_77978_p().func_74764_b("Items")) {
            ItemStackHelper.func_191283_b((NBTTagCompound)bundle.func_77978_p(), this.inventoryBundle);
        }
        return this.inventoryBundle;
    }

    public static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        EntityItem entityitem = new EntityItem(world, x, y, z, stack);
        entityitem.field_70159_w = 0.0;
        entityitem.field_70181_x = 0.0;
        entityitem.field_70179_y = 0.0;
        entityitem.func_174867_a(20);
        world.func_72838_d((Entity)entityitem);
    }

    private boolean isHeatSource(IBlockState state) {
        return state.func_177230_c() == BlockRegistry.PEAT_SMOULDERING || state.func_177230_c().func_149688_o(state) == Material.field_151581_o;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void setHeatProgress(int heat) {
        this.heatProgress = heat;
    }

    public int getHeatProgress() {
        return this.heatProgress;
    }

    public int getTankFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readPacketNbt(packet.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writePacketNbt(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writePacketNbt(tag);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.readPacketNbt(nbt);
    }

    protected NBTTagCompound writePacketNbt(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("heatProgress", this.getHeatProgress());
        nbt.func_74768_a("tempFluidColour", this.tempFluidColour);
        this.writeInventoryNBT(nbt);
        return nbt;
    }

    protected void readPacketNbt(NBTTagCompound nbt) {
        NBTTagCompound compound = nbt;
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.setHeatProgress(nbt.func_74762_e("heatProgress"));
        this.setTempFluidColour(nbt.func_74762_e("tempFluidColour"));
        this.readInventoryNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.setHeatProgress(tagCompound.func_74762_e("heatProgress"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        tagCompound.func_74768_a("heatProgress", this.getHeatProgress());
        return tagCompound;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        int[] SLOTS = new int[this.func_70302_i_()];
        for (int index = 0; index < SLOTS.length; ++index) {
            SLOTS[index] = index;
        }
        return SLOTS;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }
}

