/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IBlessingCapability;
import thebetweenlands.api.capability.ILastKilledCapability;
import thebetweenlands.client.handler.FogHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.EntityBLLightningBolt;
import thebetweenlands.common.entity.EntityFalseXPOrb;
import thebetweenlands.common.entity.EntityResurrection;
import thebetweenlands.common.handler.PlayerRespawnHandler;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityOfferingTable;
import thebetweenlands.common.tile.TileEntityRepeller;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.util.PlayerUtil;

public class TileEntitySimulacrum
extends TileEntityRepeller
implements ITickable {
    private static final Method m_getAmbientSound = ReflectionHelper.findMethod(EntityLiving.class, (String)"getAmbientSound", (String)"func_184639_G", (Class[])new Class[0]);
    private static final Method m_getDeathSound;
    private static final Method m_getHurtSound;
    private final MobSpawnerLogicBetweenlands mireSnailSpawner = new MobSpawnerLogicBetweenlands(){
        {
            this.setNextEntityName("thebetweenlands:mire_snail");
            this.setDelayRange(600, 1200);
            this.setSpawnInAir(false);
            this.setParticles(false);
            this.setCheckRange(24.0);
            this.setMaxSpawnCount(1);
        }

        @Override
        public void broadcastEvent(int eventID) {
        }

        @Override
        public World getSpawnerWorld() {
            return TileEntitySimulacrum.this.field_145850_b;
        }

        @Override
        public int getSpawnerX() {
            return TileEntitySimulacrum.this.func_174877_v().func_177958_n();
        }

        @Override
        public int getSpawnerY() {
            return TileEntitySimulacrum.this.func_174877_v().func_177956_o();
        }

        @Override
        public int getSpawnerZ() {
            return TileEntitySimulacrum.this.func_174877_v().func_177952_p();
        }

        @Override
        protected void spawnParticles() {
        }

        @Override
        public MobSpawnerLogicBetweenlands setNextEntityName(String name) {
            super.setNextEntityName(name);
            TileEntitySimulacrum te = TileEntitySimulacrum.this;
            if (te != null && te.field_145850_b != null) {
                IBlockState blockState = te.field_145850_b.func_180495_p(te.field_174879_c);
                te.field_145850_b.func_184138_a(te.field_174879_c, blockState, blockState, 3);
            }
            return this;
        }

        @Override
        public MobSpawnerLogicBetweenlands setNextEntity(String name) {
            super.setNextEntity(name);
            TileEntitySimulacrum te = TileEntitySimulacrum.this;
            if (te != null && te.field_145850_b != null) {
                IBlockState blockState = te.field_145850_b.func_180495_p(te.field_174879_c);
                te.field_145850_b.func_184138_a(te.field_174879_c, blockState, blockState, 3);
            }
            return this;
        }

        @Override
        public MobSpawnerLogicBetweenlands setNextEntity(WeightedSpawnerEntity entity) {
            super.setNextEntity(entity);
            TileEntitySimulacrum te = TileEntitySimulacrum.this;
            if (te != null && te.field_145850_b != null) {
                IBlockState blockState = te.field_145850_b.func_180495_p(te.field_174879_c);
                te.field_145850_b.func_184138_a(te.field_174879_c, blockState, blockState, 3);
            }
            return this;
        }

        @Override
        public MobSpawnerLogicBetweenlands setEntitySpawnList(List<WeightedSpawnerEntity> entitySpawnList) {
            super.setEntitySpawnList(entitySpawnList);
            TileEntitySimulacrum te = TileEntitySimulacrum.this;
            if (te != null && te.field_145850_b != null) {
                IBlockState blockState = te.field_145850_b.func_180495_p(te.field_174879_c);
                te.field_145850_b.func_184138_a(te.field_174879_c, blockState, blockState, 3);
            }
            return this;
        }
    };
    private Effect effect = Effect.NONE;
    private Effect secondaryEffect = Effect.NONE;
    private boolean isActive = false;
    private String customName = "";
    private int soundCooldown = 0;
    private TileEntityRepeller sourceRepeller;
    private boolean readFromNbt = false;

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        if (!this.readFromNbt) {
            this.mireSnailSpawner.resetTimer();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void func_73660_a() {
        if (this.isActive()) {
            this.updateEffects(this.effect);
            this.updateEffects(this.secondaryEffect);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("effectId", this.effect.id);
        compound.func_74768_a("secondaryEffectId", this.secondaryEffect.id);
        compound.func_74757_a("isActive", this.isActive);
        compound.func_74778_a("customName", this.customName);
        this.mireSnailSpawner.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readFromNbt = true;
        this.effect = Effect.byId(compound.func_74762_e("effectId"));
        this.secondaryEffect = Effect.byId(compound.func_74762_e("secondaryEffectId"));
        this.isActive = compound.func_74767_n("isActive");
        this.customName = compound.func_74779_i("customName");
        this.mireSnailSpawner.readFromNBT(compound);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74768_a("effectId", this.effect.id);
        nbt.func_74768_a("secondaryEffectId", this.secondaryEffect.id);
        nbt.func_74757_a("isActive", this.isActive);
        nbt.func_74778_a("customName", this.customName);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.effect = Effect.byId(tag.func_74762_e("effectId"));
        this.secondaryEffect = Effect.byId(tag.func_74762_e("secondaryEffectId"));
        this.isActive = tag.func_74767_n("isActive");
        this.customName = tag.func_74779_i("customName");
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.effect = Effect.byId(nbt.func_74762_e("effectId"));
        this.secondaryEffect = Effect.byId(nbt.func_74762_e("secondaryEffectId"));
    }

    public void func_70296_d() {
        super.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public void setActive(boolean active) {
        this.isActive = active;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public String getCustomName() {
        return this.customName;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
        this.setSecondaryEffect(Effect.NONE);
        this.func_70296_d();
    }

    public Effect getSecondaryEffect() {
        return this.secondaryEffect;
    }

    public void setSecondaryEffect(Effect effect) {
        this.secondaryEffect = effect;
        this.func_70296_d();
    }

    private void updateEffects(Effect effect) {
        switch (effect) {
            case RANDOM: {
                if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L || this.field_145850_b.field_73012_v.nextInt(200) != 0) break;
                this.setSecondaryEffect(Effect.values()[this.field_145850_b.field_73012_v.nextInt(Effect.values().length)]);
                break;
            }
            case THEM: {
                if (!this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L || this.field_145850_b.field_73012_v.nextInt(5) != 0) break;
                this.spawnThem();
                break;
            }
            case IMITATION: {
                if (!this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L || --this.soundCooldown > 0) break;
                this.soundCooldown = this.field_145850_b.field_73012_v.nextInt(30) + 30;
                this.playImitationSound();
                break;
            }
            case SANCTUARY: {
                this.setRadiusState(3);
                TileEntityRepeller repeller = TileEntitySimulacrum.getClosestActiveTile(TileEntityRepeller.class, this, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 18.0, null, null);
                if (repeller != null && repeller.func_145835_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > (double)(repeller.getRadius(1.0f) * repeller.getRadius(1.0f))) {
                    repeller = null;
                }
                this.sourceRepeller = repeller instanceof TileEntitySimulacrum ? (repeller = ((TileEntitySimulacrum)repeller).sourceRepeller) : repeller;
                if (this.sourceRepeller != null && (this.sourceRepeller.func_145837_r() || !this.field_145850_b.func_175667_e(this.sourceRepeller.func_174877_v()))) {
                    this.sourceRepeller = null;
                    if (repeller == this.sourceRepeller) {
                        repeller = null;
                    }
                }
                int prevFuel = 0;
                if (repeller != null) {
                    this.running = repeller.running;
                    this.hasShimmerstone = repeller.hasShimmerstone;
                    prevFuel = this.fuel = repeller.fuel;
                } else {
                    this.running = false;
                    this.hasShimmerstone = false;
                    this.fuel = 0;
                }
                super.func_73660_a();
                if (repeller == null) break;
                if (this.fuel < prevFuel) {
                    repeller.fuel -= prevFuel - this.fuel;
                    repeller.func_70296_d();
                    this.func_70296_d();
                }
                this.running = repeller.running;
                this.hasShimmerstone = repeller.hasShimmerstone;
                this.fuel = repeller.fuel;
                break;
            }
            case FERTILITY: {
                if (this.field_145850_b.field_72995_K || !BetweenlandsWorldStorage.forWorld((World)this.field_145850_b).getEnvironmentEventRegistry().heavyRain.isActive()) break;
                this.mireSnailSpawner.updateSpawner();
                break;
            }
            case WISP: {
                if (this.field_145850_b.field_72995_K || !this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a()) || this.field_145850_b.func_82737_E() % 200L != 0L || !BetweenlandsWorldStorage.forWorld((World)this.field_145850_b).getEnvironmentEventRegistry().auroras.isActive()) break;
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), BlockRegistry.WISP.func_176223_P());
                break;
            }
            case WISDOM: {
                int xp;
                EntityPlayer player;
                if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 160L != 0L || !this.field_145850_b.func_72872_a(EntityFalseXPOrb.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(16.0)).isEmpty() || (player = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 8.0, false)) == null || (xp = this.field_145850_b.field_73012_v.nextInt((int)Math.min(Math.abs(this.field_145850_b.field_73012_v.nextGaussian() * (double)Math.min(player.field_71067_cb, 1200)), 2400.0) + 1)) >= player.field_71067_cb) break;
                UUID playerUuid = player.func_110124_au();
                int negativeXp = xp;
                float multiplier = 1.0f + MathHelper.func_76131_a((float)((float)this.field_145850_b.field_73012_v.nextGaussian()), (float)-0.5f, (float)0.5f) - 0.025f;
                xp = (int)((float)xp * multiplier);
                ArrayList<EntityFalseXPOrb> orbs = new ArrayList<EntityFalseXPOrb>();
                for (int i = 0; i < 32; ++i) {
                    int negativeOrbXp = 0;
                    if (negativeXp > 0) {
                        if (i != 31) {
                            negativeOrbXp = this.field_145850_b.field_73012_v.nextInt(negativeXp / 8 + 1) + 1;
                            negativeXp -= negativeOrbXp;
                        } else {
                            negativeOrbXp = negativeXp;
                        }
                    }
                    int orbXp = 0;
                    if (xp > 0) {
                        if (i != 31) {
                            orbXp = this.field_145850_b.field_73012_v.nextInt(xp / 8 + 1) + 1;
                            xp -= orbXp;
                        } else {
                            orbXp = xp;
                        }
                    }
                    EntityFalseXPOrb negativeOrb = null;
                    EntityFalseXPOrb orb = null;
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        if (negativeOrbXp > 0) {
                            negativeOrb = new EntityFalseXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, -negativeOrbXp, playerUuid);
                        }
                        if (orbXp > 0) {
                            orb = new EntityFalseXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, orbXp, playerUuid);
                        }
                    } else {
                        orb = new EntityFalseXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, orbXp, playerUuid);
                        if (orbXp > 0 && negativeOrbXp > 0) {
                            negativeOrb = new EntityFalseXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, -negativeOrbXp, playerUuid);
                        }
                    }
                    if (orb != null) {
                        orbs.add(orb);
                    }
                    if (negativeOrb == null) continue;
                    orbs.add(negativeOrb);
                }
                Collections.shuffle(orbs);
                float stepH = (float)Math.PI * 2 / (float)orbs.size() * 6.0f;
                float stepV = (float)Math.PI * 2 / (float)orbs.size() / 4.0f;
                for (int i = 0; i < orbs.size(); ++i) {
                    double hc = Math.cos(stepH * (float)i);
                    double hs = Math.sin(stepH * (float)i);
                    double vc = Math.cos(stepV * (float)i);
                    double vs = Math.sin(stepV * (float)i);
                    double dx = hs * vc;
                    double dy = vs;
                    double dz = hc * vc;
                    Entity orb = (Entity)orbs.get(i);
                    orb.field_70159_w = dx * 0.25;
                    orb.field_70181_x = (double)0.1f + dy * (double)0.35f;
                    orb.field_70179_y = dz * 0.25;
                    orb.func_70012_b(orb.field_70165_t + dx * (double)0.65f, orb.field_70163_u + dy * 2.0, orb.field_70161_v + dz * (double)0.65f, 0.0f, 0.0f);
                    this.field_145850_b.func_72838_d(orb);
                }
                break;
            }
            case BLESSING: {
                TileEntityOfferingTable offering;
                EntityPlayer player;
                if (this.field_145850_b.func_82737_E() % 4L != 0L || (player = this.field_145850_b.func_190525_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 4.0, e -> {
                    EntityPlayer p = (EntityPlayer)e;
                    if (!p.func_175149_v()) {
                        IBlessingCapability cap = (IBlessingCapability)p.getCapability(CapabilityRegistry.CAPABILITY_BLESSING, null);
                        return cap != null && (!cap.isBlessed() || cap.getBlessingDimension() != p.field_71093_bK || !this.field_174879_c.equals((Object)cap.getBlessingLocation()));
                    }
                    return false;
                })) == null || (offering = TileEntitySimulacrum.getClosestActiveTile(TileEntityOfferingTable.class, null, this.field_145850_b, player.field_70165_t, player.field_70163_u, player.field_70161_v, 2.5, null, stack -> !stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.SPIRIT_FRUIT)) == null) break;
                if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(40) == 0) {
                    IBlessingCapability cap = (IBlessingCapability)player.getCapability(CapabilityRegistry.CAPABILITY_BLESSING, null);
                    if (cap == null) break;
                    ItemStack stack2 = offering.getStack();
                    stack2.func_190918_g(1);
                    offering.setStack(stack2);
                    cap.setBlessed(player.field_71093_bK, this.field_174879_c);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.simulacrum.blessed", new Object[0]), true);
                    break;
                }
                if (!this.field_145850_b.field_72995_K) break;
                this.spawnBlessingParticles((float)this.field_145850_b.func_82737_E() * 0.025f, (float)offering.func_174877_v().func_177958_n() + 0.5f, (float)offering.func_174877_v().func_177956_o() + 0.4f, (float)offering.func_174877_v().func_177952_p() + 0.5f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBlessingParticles(float rot, float x, float y, float z) {
        float step = 0.31415927f;
        for (int i = 0; i < 20; ++i) {
            float dx = (float)Math.cos(rot + step * (float)i);
            float dz = (float)Math.sin(rot + step * (float)i);
            BLParticles.CORRUPTED.spawn(this.field_145850_b, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(dx * 0.05f, 0.2f, dz * 0.05f)).withData(80, true, Float.valueOf(0.1f), true));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnThem() {
        BlockPos pos;
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        if (viewer != null && this.field_174879_c.func_177954_c(viewer.field_70165_t, viewer.field_70163_u, viewer.field_70161_v) < 256.0 && FogHandler.hasDenseFog(this.field_145850_b) && (FogHandler.getCurrentFogEnd() + FogHandler.getCurrentFogStart()) / 2.0f < 65.0f && (SurfaceType.MIXED_GROUND_AND_UNDERGROUND.matches(this.field_145850_b.func_180495_p((pos = viewer.func_180425_c()).func_177977_b())) || SurfaceType.MIXED_GROUND_AND_UNDERGROUND.matches(this.field_145850_b.func_180495_p(pos.func_177979_c(2))) || SurfaceType.MIXED_GROUND_AND_UNDERGROUND.matches(this.field_145850_b.func_180495_p(pos.func_177979_c(3))))) {
            double xOff = this.field_145850_b.field_73012_v.nextInt(50) - 25;
            double zOff = this.field_145850_b.field_73012_v.nextInt(50) - 25;
            double sx = viewer.field_70165_t + xOff;
            double sz = viewer.field_70161_v + zOff;
            double sy = (float)pos.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() * 0.75f;
            BLParticles.THEM.spawn(this.field_145850_b, sx, sy, sz);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playImitationSound() {
        Entity entity;
        ResourceLocation key;
        ILastKilledCapability cap;
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        if (viewer != null && this.field_174879_c.func_177954_c(viewer.field_70165_t, viewer.field_70163_u, viewer.field_70161_v) < 256.0 && (cap = (ILastKilledCapability)viewer.getCapability(CapabilityRegistry.CAPABILITY_LAST_KILLED, null)) != null && (key = cap.getLastKilled()) != null && (entity = EntityList.func_188429_b((ResourceLocation)key, (World)viewer.field_70170_p)) != null) {
            SoundEvent sound;
            int r = viewer.field_70170_p.field_73012_v.nextInt(20);
            try {
                sound = r <= 15 ? (SoundEvent)m_getAmbientSound.invoke((Object)entity, new Object[0]) : (r <= 19 ? (SoundEvent)m_getHurtSound.invoke((Object)entity, DamageSource.field_76377_j) : (SoundEvent)m_getDeathSound.invoke((Object)entity, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (sound != null) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, sound, SoundCategory.BLOCKS, 0.75f, 0.9f, false);
            }
            entity.func_70106_y();
        }
    }

    @Nullable
    public static <T extends TileEntity> T getClosestActiveTile(Class<T> tileCls, @Nullable TileEntity exclude, World world, double x, double y, double z, double range, @Nullable Effect effect, @Nullable Predicate<ItemStack> offeringPredicate) {
        int sx = MathHelper.func_76128_c((double)(x - range)) >> 4;
        int sz = MathHelper.func_76128_c((double)(z - range)) >> 4;
        int ex = MathHelper.func_76128_c((double)(x + range)) >> 4;
        int ez = MathHelper.func_76128_c((double)(z + range)) >> 4;
        TileEntity closest = null;
        for (int cx = sx; cx <= ex; ++cx) {
            for (int cz = sz; cz <= ez; ++cz) {
                Chunk chunk = world.func_72863_F().func_186026_b(cx, cz);
                if (chunk == null) continue;
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    double dstSq;
                    TileEntity tile = (TileEntity)entry.getValue();
                    if (tile == exclude || !tileCls.isInstance(tile) || !((dstSq = ((BlockPos)entry.getKey()).func_177954_c(x, y, z)) <= range * range) || closest != null && !(dstSq <= closest.func_174877_v().func_177954_c(x, y, z)) || effect != null && tile instanceof TileEntitySimulacrum && (((TileEntitySimulacrum)tile).getEffect() != effect || !((TileEntitySimulacrum)tile).isActive()) || offeringPredicate != null && tile instanceof TileEntityOfferingTable && !offeringPredicate.test(((TileEntityOfferingTable)tile).getStack())) continue;
                    closest = tile;
                }
            }
        }
        return (T)closest;
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        TileEntitySimulacrum simulacrum = TileEntitySimulacrum.getClosestActiveTile(TileEntitySimulacrum.class, null, player.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 16.0, Effect.WEAKNESS, null);
        if (simulacrum != null) {
            double dst = simulacrum.func_145835_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            float multiplier = (float)((double)0.075f + (double)0.925f * dst / 256.0);
            event.setNewSpeed(event.getNewSpeed() * multiplier);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeathFirst(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            BlockPos location;
            EntityPlayer player = (EntityPlayer)entity;
            IBlessingCapability cap = (IBlessingCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_BLESSING, null);
            if (cap != null && cap.isBlessed() && (location = cap.getBlessingLocation()) != null && cap.getBlessingDimension() == entity.field_71093_bK) {
                int xp;
                event.setCanceled(true);
                entity.func_70606_j(entity.func_110138_aP() * 0.5f);
                player.field_71106_cc = 0.0f;
                player.field_71068_ca = 0;
                player.field_71067_cb = 0;
                for (int droppedExperience = player.field_71067_cb / 3; droppedExperience > 0; droppedExperience -= xp) {
                    xp = EntityXPOrb.func_70527_a((int)droppedExperience);
                    EntityXPOrb xpOrb = new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, xp);
                    xpOrb.field_70532_c = 40;
                    player.field_70170_p.func_72838_d((Entity)xpOrb);
                }
                if (entity.field_70170_p.field_73012_v.nextBoolean()) {
                    BlockPos spawnPoint = PlayerRespawnHandler.getSpawnPointNearPos(entity.field_70170_p, location, 8, false, 4, 0);
                    if (spawnPoint != null) {
                        if (entity.func_174818_b(spawnPoint) > 24.0) {
                            TileEntitySimulacrum.playThunderSounds(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                            entity.field_70170_p.func_72838_d((Entity)new EntityBLLightningBolt(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1, false, true));
                        }
                        PlayerUtil.teleport((Entity)entity, (double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5);
                        TileEntitySimulacrum.playThunderSounds(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        entity.field_70170_p.func_72838_d((Entity)new EntityBLLightningBolt(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1, false, true));
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 1));
                    } else if (entity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)entity).func_146105_b((ITextComponent)new TextComponentTranslation("chat.simulacrum.obstructed", new Object[0]), true);
                    }
                } else {
                    TileEntitySimulacrum.playThunderSounds(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_72838_d((Entity)new EntityBLLightningBolt(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1, false, true));
                }
                if (player instanceof EntityPlayerMP) {
                    AdvancementCriterionRegistry.REVIVED_BLESSED.trigger((EntityPlayerMP)player);
                }
                cap.clearBlessed();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeathLast(LivingDeathEvent event) {
        TileEntitySimulacrum simulacrum;
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K && !(entity instanceof EntityPlayer) && entity.field_70170_p.field_73012_v.nextInt(4) == 0 && (simulacrum = TileEntitySimulacrum.getClosestActiveTile(TileEntitySimulacrum.class, null, entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 16.0, Effect.RESURRECTION, null)) != null) {
            entity.func_184174_b(false);
            NBTTagCompound nbt = new NBTTagCompound();
            if (entity.func_184198_c(nbt)) {
                EntityResurrection resurrection = new EntityResurrection(entity.field_70170_p, nbt, () -> !entity.field_70128_L ? entity.func_174791_d() : null, 60 + entity.field_70170_p.field_73012_v.nextInt(60));
                resurrection.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                entity.field_70170_p.func_72838_d((Entity)resurrection);
            }
        }
    }

    protected static void playThunderSounds(World world, double x, double y, double z) {
        world.func_184148_a(null, x, y, z, (SoundEvent)SoundRegistry.RIFT_CREAK, SoundCategory.PLAYERS, 2.0f, 1.0f);
        world.func_184148_a(null, x, y, z, SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.75f, 0.75f);
    }

    static {
        m_getAmbientSound.setAccessible(true);
        m_getDeathSound = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"getDeathSound", (String)"func_184615_bR", (Class[])new Class[0]);
        m_getDeathSound.setAccessible(true);
        m_getHurtSound = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"getHurtSound", (String)"func_184601_bQ", (Class[])new Class[]{DamageSource.class});
        m_getHurtSound.setAccessible(true);
    }

    public static enum Effect {
        NONE("none", 0),
        RANDOM("random", 1),
        THEM("them", 2),
        IMITATION("imitation", 3),
        WEAKNESS("weakness", 4),
        RESURRECTION("resurrection", 5),
        SANCTUARY("sanctuary", 6),
        FERTILITY("fertility", 7),
        ATTRACTION("attraction", 8),
        WISP("wisp", 9),
        WISDOM("wisdom", 10),
        BLESSING("blessing", 11);

        public final String name;
        public final int id;

        private Effect(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public static Effect byId(int id) {
            for (Effect effect : Effect.values()) {
                if (effect.id != id) continue;
                return effect;
            }
            return NONE;
        }
    }
}

