/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.block.misc.BlockOfferingTable;
import thebetweenlands.common.handler.PlayerRespawnHandler;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.item.misc.ItemBoneWayfinder;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityGroundItem;
import thebetweenlands.util.PlayerUtil;
import thebetweenlands.util.StatePropertyHelper;

public class TileEntityOfferingTable
extends TileEntityGroundItem
implements ITickable {
    private Map<EntityPlayer, Integer> teleportTicks = new WeakHashMap<EntityPlayer, Integer>();

    public void func_73660_a() {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.BONE_WAYFINDER) {
            double radius = 2.5;
            AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v()).func_186662_g(radius);
            HashSet<EntityPlayer> teleportingPlayers = null;
            for (EntityPlayer player : this.field_145850_b.func_175647_a(EntityPlayer.class, aabb, p -> p.func_70093_af() && p.func_70092_e((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f)) <= radius * radius)) {
                if (teleportingPlayers == null) {
                    teleportingPlayers = new HashSet<EntityPlayer>();
                }
                teleportingPlayers.add(player);
                int ticks = this.teleportTicks.getOrDefault(player, 0);
                if (ticks >= 0 && !this.updateTeleport(player, ticks, stack)) {
                    this.teleportTicks.put(player, -100);
                } else {
                    this.teleportTicks.put(player, ticks + 1);
                }
                this.setStack(stack);
            }
            if (teleportingPlayers == null) {
                this.teleportTicks.clear();
            } else if (!this.teleportTicks.isEmpty()) {
                Iterator<EntityPlayer> it = this.teleportTicks.keySet().iterator();
                while (it.hasNext()) {
                    EntityPlayer player;
                    player = it.next();
                    if (teleportingPlayers.contains(player)) continue;
                    it.remove();
                }
            }
        } else {
            this.teleportTicks.clear();
        }
    }

    private boolean updateTeleport(EntityPlayer entity, int ticks, ItemStack stack) {
        if (ticks >= 100) {
            BlockPos waystone;
            if (!entity.field_70170_p.field_72995_K && stack.func_77952_i() < stack.func_77958_k() && (waystone = ((ItemBoneWayfinder)stack.func_77973_b()).getBoundWaystone(stack)) != null) {
                BlockPos spawnPoint = PlayerRespawnHandler.getSpawnPointNearPos(entity.field_70170_p, waystone, 8, false, 4, 0);
                if (spawnPoint != null) {
                    if (entity.func_174818_b(spawnPoint) > 24.0) {
                        this.playThunderSounds(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    }
                    PlayerUtil.teleport((Entity)entity, (double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5);
                    this.playThunderSounds(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 1));
                    stack.func_77972_a(1, (EntityLivingBase)entity);
                } else if (entity instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity).func_146105_b((ITextComponent)new TextComponentTranslation("chat.waystone.obstructed", new Object[0]), true);
                }
            }
        } else if (stack.func_77952_i() < stack.func_77958_k()) {
            if (!entity.field_70170_p.field_72995_K) {
                if (ticks >= 40) {
                    int removed;
                    int count = ticks - 40;
                    if (entity.field_70737_aN > 0) {
                        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    if (entity instanceof EntityPlayer && !entity.func_184812_l_() && count < 60 && entity.field_70173_aa % 3 == 0 && (removed = ItemRing.removeXp(entity, 1)) == 0) {
                        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        return false;
                    }
                }
                if (ticks >= 15 && ticks < 90 && (ticks - 15) % 20 == 0) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundRegistry.PORTAL_TRAVEL, SoundCategory.PLAYERS, 0.05f + 0.4f * (float)MathHelper.func_76125_a((int)(80 - ticks), (int)1, (int)80) / 80.0f, 0.9f + entity.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                }
            } else {
                if (ticks >= 15 && ticks % 4 == 0) {
                    this.spawnChargingParticles((float)this.field_145850_b.func_82737_E() * 0.035f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.4f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                }
                Random rand = entity.field_70170_p.field_73012_v;
                for (int i = 0; i < MathHelper.func_76125_a((int)(60 - ticks), (int)1, (int)60); ++i) {
                    entity.field_70170_p.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, entity.field_70165_t + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 6.0, entity.field_70163_u + (double)(rand.nextFloat() * 4.0f) - 2.0, entity.field_70161_v + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 6.0, 0.0, 0.2, 0.0, new int[0]);
                }
            }
        } else if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    private void playThunderSounds(World world, double x, double y, double z) {
        world.func_184148_a(null, x, y, z, (SoundEvent)SoundRegistry.RIFT_CREAK, SoundCategory.PLAYERS, 2.0f, 1.0f);
        world.func_184148_a(null, x, y, z, SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.75f, 0.75f);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnChargingParticles(float rot, float x, float y, float z) {
        float step = 0.31415927f;
        for (int i = 0; i < 20; ++i) {
            float dx = (float)Math.cos(rot + step * (float)i);
            float dz = (float)Math.sin(rot + step * (float)i);
            BLParticles.CORRUPTED.spawn(this.field_145850_b, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(dx * 0.075f, 0.15f, dz * 0.075f)).withData(80, true, Float.valueOf(0.1f), true));
        }
    }

    @Override
    public boolean hasRandomOffset() {
        return false;
    }

    @Override
    public float getYOffset() {
        return 0.5f;
    }

    @Override
    public boolean isItemUpsideDown() {
        return false;
    }

    @Override
    public float getYRotation(float randomRotation) {
        EnumFacing facing = StatePropertyHelper.getStatePropertySafely(this, BlockOfferingTable.class, BlockOfferingTable.FACING, EnumFacing.NORTH);
        return -facing.func_185119_l();
    }

    @Override
    public float getTiltRotation() {
        return 0.0f;
    }

    @Override
    public float getItemScale() {
        return 0.5f;
    }
}

