/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.misc.BlockLantern;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityMothHouse
extends TileEntityBasicInventory
implements ITickable {
    public static final int SLOT_GRUBS = 0;
    public static final int SLOT_SILK = 1;
    protected static final int MAX_GRUBS = 6;
    protected static final int MAX_SILK_PER_GRUB = 3;
    protected static final int BASE_TICKS_PER_SILK = 160;
    private int productionTime = 0;
    private float productionEfficiency = 0.0f;
    private boolean isWorking = false;
    private EntityPlayer placer;
    private UUID placerUUID;

    public TileEntityMothHouse() {
        super("container.bl.moth_house", (NonNullList<ItemStack>)NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a), (te, inv) -> new ItemStackHandler((NonNullList)inv, (NonNullList)inv, (TileEntityBasicInventory)((Object)te)){
            final /* synthetic */ NonNullList val$inv;
            final /* synthetic */ TileEntityBasicInventory val$te;
            {
                this.val$inv = nonNullList;
                this.val$te = tileEntityBasicInventory;
                super(x0);
            }

            public void setSize(int size) {
                if (size != this.val$inv.size()) {
                    throw new UnsupportedOperationException("Can't resize this inventory");
                }
            }

            protected void onContentsChanged(int slot) {
                if (this.val$te.func_145830_o()) {
                    this.val$te.func_70296_d();
                }
            }

            public void setStackInSlot(int slot, ItemStack stack) {
                if (slot == 1) {
                    ItemStack prevStack = this.getStackInSlot(slot).func_77946_l();
                    super.setStackInSlot(slot, stack);
                    ItemStack newStack = this.getStackInSlot(slot);
                    if (newStack.func_190916_E() < prevStack.func_190916_E()) {
                        ((TileEntityMothHouse)this.val$te).onSilkRemoved(prevStack.func_190916_E() - newStack.func_190916_E());
                    }
                } else {
                    super.setStackInSlot(slot, stack);
                }
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 1 && !simulate) {
                    ItemStack extracted = super.extractItem(slot, amount, false);
                    if (extracted.func_190916_E() > 0) {
                        ((TileEntityMothHouse)this.val$te).onSilkRemoved(extracted.func_190916_E());
                    }
                    return extracted;
                }
                return super.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return 6;
                }
                return super.getSlotLimit(slot);
            }
        });
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.updatePlacerFromUUID();
    }

    private boolean updatePlacerFromUUID() {
        EntityPlayer player;
        if (this.placerUUID != null && (player = this.field_145850_b.func_152378_a(this.placerUUID)) != null && player != this.getPlacer()) {
            this.setPlacer(player);
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.isWorking) {
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                double px = (double)this.field_174879_c.func_177958_n() + 0.5;
                double py = (double)this.field_174879_c.func_177956_o() + 0.3;
                double pz = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.spawnSilkMothParticle(px, py, pz);
            }
            this.updateEfficiency();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.placerUUID != null && this.getPlacer() == null && this.field_145850_b.func_82737_E() % 20L == 0L && this.updatePlacerFromUUID()) {
                this.markForUpdate();
            }
            ItemStack grubs = this.func_70301_a(0);
            boolean wasWorking = this.isWorking;
            if (grubs == ItemStack.field_190927_a || grubs.func_190916_E() == 0 || this.func_70301_a(1).func_190916_E() == this.func_70301_a(1).func_77976_d() || this.func_70301_a(1).func_190916_E() >= this.func_70301_a(0).func_190916_E() * 3) {
                this.isWorking = false;
            } else {
                if (!this.isWorking) {
                    this.updateEfficiency();
                    this.resetProductionTime();
                }
                --this.productionTime;
                this.isWorking = true;
                if (this.productionTime <= 0) {
                    ItemStack silkStack = this.func_70301_a(1);
                    if (silkStack == ItemStack.field_190927_a) {
                        silkStack = ItemMisc.EnumItemMisc.SILK_THREAD.create(1);
                        super.func_70299_a(1, silkStack);
                    } else if (ItemMisc.EnumItemMisc.SILK_THREAD.isItemOf(silkStack)) {
                        silkStack.func_190917_f(1);
                    }
                    this.markForUpdate();
                    this.resetProductionTime();
                    this.func_70296_d();
                }
            }
            if (wasWorking != this.isWorking) {
                this.markForUpdate();
                this.func_70296_d();
            }
        }
    }

    protected void resetProductionTime() {
        float efficiencyMultiplier = 1.0f / (0.1f + this.productionEfficiency * 0.9f);
        this.productionTime = (int)(160.0 * Math.pow(3.0, this.getSilkProductionStage()) * (double)efficiencyMultiplier);
    }

    public int getSilkProductionStage() {
        ItemStack grubStack = this.func_70301_a(0);
        ItemStack silkStack = this.func_70301_a(1);
        return grubStack.func_190916_E() > 0 ? silkStack.func_190916_E() / grubStack.func_190916_E() : 0;
    }

    public boolean isSilkProductionFinished() {
        ItemStack grubStack = this.func_70301_a(0);
        ItemStack silkStack = this.func_70301_a(1);
        return silkStack.func_190916_E() >= Math.min(6, grubStack.func_190916_E()) * 3;
    }

    public int getSilkRenderStage() {
        ItemStack silkStack = this.func_70301_a(1);
        return MathHelper.func_76123_f((float)(Math.min(1.0f, (float)silkStack.func_190916_E() / (float)Math.min(this.inventoryHandler.getSlotLimit(1), 18)) * 3.0f));
    }

    private void updateEfficiency() {
        AxisAlignedBB axisalignedbb = this.extendRangeBox();
        int minX = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)axisalignedbb.field_72336_d);
        int minY = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)axisalignedbb.field_72334_f);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int lanternsNearby = 0;
        int maxLanterns = 3;
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    IBlockState state = this.func_145831_w().func_180495_p((BlockPos)mutablePos.func_181079_c(x, y, z));
                    if (lanternsNearby >= maxLanterns || !(state.func_177230_c() instanceof BlockLantern)) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        if (!(this.placer instanceof EntityPlayerMP) || ++lanternsNearby != maxLanterns) continue;
                        AdvancementCriterionRegistry.MOTH_HOUSE_MAXED.trigger((EntityPlayerMP)this.placer);
                        continue;
                    }
                    if (this.field_145850_b.field_73012_v.nextInt(16) != 0) continue;
                    double px = (double)mutablePos.func_177958_n() + 0.5;
                    double py = (double)mutablePos.func_177956_o() + 0.7;
                    double pz = (double)mutablePos.func_177952_p() + 0.5;
                    this.spawnSilkMothParticle(px, py, pz);
                }
            }
        }
        this.productionEfficiency = (float)lanternsNearby / 3.0f;
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnSilkMothParticle(double x, double y, double z) {
        BLParticles.SILK_MOTH.spawn(this.field_145850_b, x, y, z);
    }

    public int addGrubs(ItemStack stack) {
        int count = stack.func_190916_E();
        int grubsAdded = count - this.inventoryHandler.insertItem(0, stack.func_77946_l(), false).func_190916_E();
        this.func_70296_d();
        return grubsAdded;
    }

    protected void onSilkRemoved(int count) {
        int grubsToRemove = MathHelper.func_76123_f((float)((float)count / 3.0f));
        ItemStack grubsStack = this.func_70301_a(0);
        grubsStack.func_190918_g(grubsToRemove);
        this.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.markForUpdate();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("OwnerUUID", 8)) {
            this.placerUUID = nbt.func_186857_a("OwnerUUID");
        }
        this.productionTime = nbt.func_74762_e("productionTime");
        this.productionEfficiency = nbt.func_74760_g("productionEfficiency");
        this.isWorking = nbt.func_74767_n("isWorking");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        EntityPlayer placer = this.getPlacer();
        if (placer != null) {
            nbt.func_186854_a("OwnerUUID", placer.func_110124_au());
        }
        nbt.func_74768_a("productionTime", this.productionTime);
        nbt.func_74776_a("productionEfficiency", this.productionEfficiency);
        nbt.func_74757_a("isWorking", this.isWorking);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public AxisAlignedBB extendRangeBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b(3.0, 3.0, 3.0);
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return super.func_180462_a(slot, stack, side) && slot == 0 && stack.func_77973_b() == ItemRegistry.SILK_GRUB;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1;
    }

    public void setPlacer(EntityPlayer player) {
        this.placer = player;
    }

    private EntityPlayer getPlacer() {
        return this.placer;
    }
}

