/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.mobs.EntityBubblerCrab;
import thebetweenlands.common.entity.mobs.EntitySiltCrab;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.ItemRegistry;

public class TileEntityFishTrimmingTable
extends TileEntity
implements ISidedInventory {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasAnadia() {
        ItemStack stack = (ItemStack)this.getItems().get(0);
        return !stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.ANADIA && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10);
    }

    private boolean isAnadiaRotten() {
        long rottingTime;
        ItemStack stack = (ItemStack)this.getItems().get(0);
        return stack.func_77978_p().func_74775_l("Entity").func_74764_b("rottingTime") && stack.func_77978_p().func_74775_l("Entity").func_74771_c("fishColour") != 0 && (rottingTime = stack.func_77978_p().func_74775_l("Entity").func_74763_f("rottingTime")) - this.func_145831_w().func_82737_E() <= 0L;
    }

    public boolean hasSiltCrab() {
        ItemStack stack = (ItemStack)this.getItems().get(0);
        return !stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.SILT_CRAB && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10);
    }

    public boolean hasBubblerCrab() {
        ItemStack stack = (ItemStack)this.getItems().get(0);
        return !stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.BUBBLER_CRAB && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10);
    }

    public boolean hasChopper() {
        ItemStack stack = (ItemStack)this.getItems().get(5);
        return !stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.BONE_AXE;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loadFromNbt(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return this.saveToNbt(nbt);
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (nbt.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.inventory);
        }
    }

    public NBTTagCompound saveToNbt(NBTTagCompound nbt) {
        ItemStackHelper.func_191281_a((NBTTagCompound)nbt, this.inventory, (boolean)false);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public String func_70005_c_() {
        return new TextComponentTranslation("tile.thebetweenlands.fish_trimming_table.name", new Object[0]).func_150254_d();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public Entity getInputEntity() {
        ItemStack stack = (ItemStack)this.getItems().get(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMob && ((ItemMob)stack.func_77973_b()).hasEntityData(stack)) {
            return ((ItemMob)stack.func_77973_b()).createCapturedEntity(this.field_145850_b, 0.0, 0.0, 0.0, stack, false);
        }
        return null;
    }

    public ItemStack getSlotResult(int slot, int numItems) {
        if (this.hasAnadia()) {
            switch (slot) {
                case 0: {
                    return ItemStack.field_190927_a;
                }
                case 1: {
                    return !this.isAnadiaRotten() ? ((EntityAnadia)this.getInputEntity()).getHeadItem() : ItemMisc.EnumItemMisc.ANADIA_REMAINS.create(1);
                }
                case 2: {
                    return !this.isAnadiaRotten() ? ((EntityAnadia)this.getInputEntity()).getBodyItem() : ItemMisc.EnumItemMisc.ANADIA_REMAINS.create(1);
                }
                case 3: {
                    return !this.isAnadiaRotten() ? ((EntityAnadia)this.getInputEntity()).getTailItem() : ItemMisc.EnumItemMisc.ANADIA_REMAINS.create(1);
                }
                case 4: {
                    return ItemMisc.EnumItemMisc.ANADIA_REMAINS.create(numItems);
                }
            }
        }
        if (this.hasSiltCrab()) {
            switch (slot) {
                case 0: {
                    return ItemStack.field_190927_a;
                }
                case 1: {
                    return ((EntitySiltCrab)this.getInputEntity()).getItem1();
                }
                case 2: {
                    return ((EntitySiltCrab)this.getInputEntity()).getItem2();
                }
                case 3: {
                    return ((EntitySiltCrab)this.getInputEntity()).getItem3();
                }
                case 4: {
                    return ItemStack.field_190927_a;
                }
            }
        }
        if (this.hasBubblerCrab()) {
            switch (slot) {
                case 0: {
                    return ItemStack.field_190927_a;
                }
                case 1: {
                    return ((EntityBubblerCrab)this.getInputEntity()).getItem1();
                }
                case 2: {
                    return ((EntityBubblerCrab)this.getInputEntity()).getItem2();
                }
                case 3: {
                    return ((EntityBubblerCrab)this.getInputEntity()).getItem3();
                }
                case 4: {
                    return ItemStack.field_190927_a;
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean allResultSlotsEmpty() {
        return ((ItemStack)this.getItems().get(1)).func_190926_b() && ((ItemStack)this.getItems().get(2)).func_190926_b() && ((ItemStack)this.getItems().get(3)).func_190926_b() && ((ItemStack)this.getItems().get(4)).func_190926_b();
    }
}

