/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityBasicInventory
extends TileEntity
implements ISidedInventory {
    protected static final BiFunction<TileEntityBasicInventory, NonNullList<ItemStack>, ItemStackHandler> DEFAULT_HANDLER = (te, inv) -> new ItemStackHandler((NonNullList)inv, (NonNullList)inv, (TileEntityBasicInventory)((Object)te)){
        final /* synthetic */ NonNullList val$inv;
        final /* synthetic */ TileEntityBasicInventory val$te;
        {
            this.val$inv = nonNullList;
            this.val$te = tileEntityBasicInventory;
            super(x0);
        }

        public void setSize(int size) {
            if (size != this.val$inv.size()) {
                throw new UnsupportedOperationException("Can't resize this inventory");
            }
        }

        protected void onContentsChanged(int slot) {
            if (this.val$te.func_145830_o()) {
                this.val$te.func_70296_d();
            }
        }
    };
    private final String name;
    protected NonNullList<ItemStack> inventory;
    protected final ItemStackHandler inventoryHandler;
    private final IItemHandler handlerUp;
    private final IItemHandler handlerDown;
    private final IItemHandler handlerNorth;
    private final IItemHandler handlerSouth;
    private final IItemHandler handlerEast;
    private final IItemHandler handlerWest;
    private final IItemHandler handlerNull;

    public TileEntityBasicInventory(int invSize, String name) {
        this(name, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)invSize, (Object)ItemStack.field_190927_a), DEFAULT_HANDLER);
    }

    public TileEntityBasicInventory(String name, NonNullList<ItemStack> inventory, BiFunction<TileEntityBasicInventory, NonNullList<ItemStack>, ItemStackHandler> handler) {
        this.inventoryHandler = handler.apply(this, inventory);
        this.inventory = inventory;
        this.name = name;
        this.handlerUp = new ISHSidedInvWrapper(this, EnumFacing.UP, this.inventoryHandler);
        this.handlerDown = new ISHSidedInvWrapper(this, EnumFacing.DOWN, this.inventoryHandler);
        this.handlerNorth = new ISHSidedInvWrapper(this, EnumFacing.NORTH, this.inventoryHandler);
        this.handlerSouth = new ISHSidedInvWrapper(this, EnumFacing.SOUTH, this.inventoryHandler);
        this.handlerEast = new ISHSidedInvWrapper(this, EnumFacing.EAST, this.inventoryHandler);
        this.handlerWest = new ISHSidedInvWrapper(this, EnumFacing.WEST, this.inventoryHandler);
        this.handlerNull = new InvWrapper((IInventory)this){

            public int getSlotLimit(int slot) {
                return Math.min(super.getSlotLimit(slot), TileEntityBasicInventory.this.inventoryHandler.getSlotLimit(slot));
            }
        };
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readInventoryNBT(nbt);
    }

    protected void readInventoryNBT(NBTTagCompound nbt) {
        this.func_174888_l();
        if (nbt.func_150297_b("Inventory", 10)) {
            this.inventoryHandler.deserializeNBT(nbt.func_74775_l("Inventory"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeInventoryNBT(nbt);
        return nbt;
    }

    protected void writeInventoryNBT(NBTTagCompound nbt) {
        NBTTagCompound inventoryNbt = this.inventoryHandler.serializeNBT();
        nbt.func_74782_a("Inventory", (NBTBase)inventoryNbt);
    }

    public int func_70302_i_() {
        return this.inventoryHandler.getSlots();
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    @MethodsReturnNonnullByDefault
    public ItemStack func_70301_a(int slot) {
        this.accessSlot(slot);
        return this.inventoryHandler.getStackInSlot(slot);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] slots = new int[this.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        this.accessSlot(slot);
        return this.func_94041_b(slot, stack) && this.func_70301_a(slot).func_190916_E() + stack.func_190916_E() <= this.inventoryHandler.getSlotLimit(slot);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        this.accessSlot(slot);
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public ItemStack func_70298_a(int index, int count) {
        this.accessSlot(index);
        return this.inventoryHandler.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        this.accessSlot(index);
        return this.inventoryHandler.extractItem(index, !this.inventoryHandler.getStackInSlot(index).func_190926_b() ? this.inventoryHandler.getStackInSlot(index).func_190916_E() : 0, false);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.accessSlot(index);
        this.inventoryHandler.setStackInSlot(index, stack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventoryHandler.getSlots(); ++i) {
            this.inventoryHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    protected void accessSlot(int slot) {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.handlerNull;
            }
            switch (facing) {
                case DOWN: {
                    return (T)this.handlerDown;
                }
                case UP: {
                    return (T)this.handlerUp;
                }
                case NORTH: {
                    return (T)this.handlerNorth;
                }
                case SOUTH: {
                    return (T)this.handlerSouth;
                }
                case WEST: {
                    return (T)this.handlerWest;
                }
                case EAST: {
                    return (T)this.handlerEast;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    private static class ISHSidedInvWrapper
    extends SidedInvWrapper {
        private final ItemStackHandler handler;

        public ISHSidedInvWrapper(ISidedInventory inv, EnumFacing side, ItemStackHandler handler) {
            super(inv, side);
            this.handler = handler;
        }

        public int getSlotLimit(int slot) {
            return Math.min(super.getSlotLimit(slot), this.handler.getSlotLimit(slot));
        }
    }
}

