/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.api.storage.IDeferredStorageOperation;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.world.storage.SharedLootPoolStorage;
import thebetweenlands.common.world.storage.location.LocationChiromawMatriarchNest;
import thebetweenlands.common.world.storage.location.LocationCragrockTower;
import thebetweenlands.common.world.storage.location.LocationGuarded;
import thebetweenlands.common.world.storage.location.LocationPortal;
import thebetweenlands.common.world.storage.location.LocationSludgeWormDungeon;
import thebetweenlands.common.world.storage.location.LocationSpiritTree;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlands.common.world.storage.location.LocationTokenBucket;
import thebetweenlands.common.world.storage.operation.DeferredLinkOperation;

public class StorageRegistry {
    private static final BiMap<ResourceLocation, Class<? extends ILocalStorage>> STORAGE_MAP = HashBiMap.create();
    private static final Map<ResourceLocation, Factory<?>> FACTORIES = new HashMap();
    private static final BiMap<ResourceLocation, Class<? extends IDeferredStorageOperation>> DEFERRED_MAP = HashBiMap.create();
    private static final Map<ResourceLocation, Supplier<? extends IDeferredStorageOperation>> DEFERRED_FACTORIES = new HashMap<ResourceLocation, Supplier<? extends IDeferredStorageOperation>>();

    public static void preInit() {
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "shared_loot_pool_storage"), SharedLootPoolStorage.class, SharedLootPoolStorage::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "location_storage"), LocationStorage.class, LocationStorage::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "cragrock_tower"), LocationCragrockTower.class, LocationCragrockTower::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "location_guarded"), LocationGuarded.class, LocationGuarded::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "portal"), LocationPortal.class, LocationPortal::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "spirit_tree"), LocationSpiritTree.class, LocationSpiritTree::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "sludge_worm_dungeon"), LocationSludgeWormDungeon.class, LocationSludgeWormDungeon::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "chiromaw_matriarch_nest"), LocationChiromawMatriarchNest.class, LocationChiromawMatriarchNest::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "token_bucket"), LocationTokenBucket.class, LocationTokenBucket::new);
        StorageRegistry.register(new ResourceLocation("thebetweenlands", "deferred_link"), DeferredLinkOperation.class, DeferredLinkOperation::new);
    }

    public static <T extends ILocalStorage> void register(ResourceLocation id, Class<T> cls, Factory<T> factory) {
        STORAGE_MAP.put((Object)id, cls);
        FACTORIES.put(id, factory);
    }

    public static Class<? extends ILocalStorage> getStorageType(ResourceLocation id) {
        return (Class)STORAGE_MAP.get((Object)id);
    }

    public static Factory<? extends ILocalStorage> getStorageFactory(ResourceLocation id) {
        return FACTORIES.get(id);
    }

    public static ResourceLocation getStorageId(Class<? extends ILocalStorage> storage) {
        return (ResourceLocation)STORAGE_MAP.inverse().get(storage);
    }

    public static <T extends IDeferredStorageOperation> void register(ResourceLocation id, Class<T> cls, Supplier<T> factory) {
        DEFERRED_MAP.put((Object)id, cls);
        DEFERRED_FACTORIES.put(id, factory);
    }

    public static Class<? extends IDeferredStorageOperation> getDeferredOperationType(ResourceLocation id) {
        return (Class)DEFERRED_MAP.get((Object)id);
    }

    public static Supplier<? extends IDeferredStorageOperation> getDeferredOperationFactory(ResourceLocation id) {
        return DEFERRED_FACTORIES.get(id);
    }

    public static ResourceLocation getDeferredOperationId(Class<? extends IDeferredStorageOperation> operation) {
        return (ResourceLocation)DEFERRED_MAP.inverse().get(operation);
    }

    public static interface Factory<T extends ILocalStorage> {
        public T create(IWorldStorage var1, StorageID var2, @Nullable LocalRegion var3);
    }
}

