/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.network.bidirectional.MessageUpdateDraetonPhysicsPart;
import thebetweenlands.common.network.clientbound.MessageAddLocalStorage;
import thebetweenlands.common.network.clientbound.MessageAmateMap;
import thebetweenlands.common.network.clientbound.MessageBlockGuardData;
import thebetweenlands.common.network.clientbound.MessageBlockGuardSectionChange;
import thebetweenlands.common.network.clientbound.MessageClearBlockGuard;
import thebetweenlands.common.network.clientbound.MessageCureDecayParticles;
import thebetweenlands.common.network.clientbound.MessageDamageReductionParticle;
import thebetweenlands.common.network.clientbound.MessageDruidAltarProgress;
import thebetweenlands.common.network.clientbound.MessageDruidTeleportParticles;
import thebetweenlands.common.network.clientbound.MessageGemProc;
import thebetweenlands.common.network.clientbound.MessageInfestWeedwoodBush;
import thebetweenlands.common.network.clientbound.MessageLivingWeedwoodShieldSpit;
import thebetweenlands.common.network.clientbound.MessageMireSnailEggHatching;
import thebetweenlands.common.network.clientbound.MessagePlayEntityIdle;
import thebetweenlands.common.network.clientbound.MessagePowerRingParticles;
import thebetweenlands.common.network.clientbound.MessageRemoveLocalStorage;
import thebetweenlands.common.network.clientbound.MessageRiftSound;
import thebetweenlands.common.network.clientbound.MessageShockArrowHit;
import thebetweenlands.common.network.clientbound.MessageShockParticle;
import thebetweenlands.common.network.clientbound.MessageShowFoodSicknessLine;
import thebetweenlands.common.network.clientbound.MessageSoundRipple;
import thebetweenlands.common.network.clientbound.MessageSummonPeatMummyParticles;
import thebetweenlands.common.network.clientbound.MessageSyncChunkStorage;
import thebetweenlands.common.network.clientbound.MessageSyncDraetonLeakages;
import thebetweenlands.common.network.clientbound.MessageSyncEntityCapabilities;
import thebetweenlands.common.network.clientbound.MessageSyncEnvironmentEventData;
import thebetweenlands.common.network.clientbound.MessageSyncGameRules;
import thebetweenlands.common.network.clientbound.MessageSyncLocalStorageData;
import thebetweenlands.common.network.clientbound.MessageSyncLocalStorageReferences;
import thebetweenlands.common.network.clientbound.MessageSyncStaticAspects;
import thebetweenlands.common.network.clientbound.MessageWeedwoodBushRustle;
import thebetweenlands.common.network.clientbound.MessageWightVolatileParticles;
import thebetweenlands.common.network.serverbound.MessageButcherFish;
import thebetweenlands.common.network.serverbound.MessageChiromawDoubleJump;
import thebetweenlands.common.network.serverbound.MessageConnectCavingRope;
import thebetweenlands.common.network.serverbound.MessageEquipItem;
import thebetweenlands.common.network.serverbound.MessageExtendedReach;
import thebetweenlands.common.network.serverbound.MessageFlightState;
import thebetweenlands.common.network.serverbound.MessageItemNaming;
import thebetweenlands.common.network.serverbound.MessageOpenPouch;
import thebetweenlands.common.network.serverbound.MessagePurgeDraetonBurner;
import thebetweenlands.common.network.serverbound.MessageRow;
import thebetweenlands.common.network.serverbound.MessageSetDraetonAnchorPos;
import thebetweenlands.common.network.serverbound.MessageSetGalleryUrl;
import thebetweenlands.common.network.serverbound.MessageUpdatePuppeteerState;
import thebetweenlands.common.network.serverbound.MessageUpdateRingKeybindState;

public class MessageRegistry {
    private static byte nextMessageId = 0;

    private MessageRegistry() {
    }

    public static void preInit() {
        MessageRegistry.registerMessage(MessageDruidAltarProgress.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSyncEnvironmentEventData.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageWeedwoodBushRustle.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSyncEntityCapabilities.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSyncStaticAspects.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageDruidTeleportParticles.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageWightVolatileParticles.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageGemProc.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageMireSnailEggHatching.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageBlockGuardSectionChange.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageBlockGuardData.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageClearBlockGuard.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessagePlayEntityIdle.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessagePowerRingParticles.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageRemoveLocalStorage.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageAddLocalStorage.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSyncLocalStorageData.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSyncChunkStorage.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSyncLocalStorageReferences.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSummonPeatMummyParticles.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageShowFoodSicknessLine.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageDamageReductionParticle.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageRiftSound.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageLivingWeedwoodShieldSpit.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageAmateMap.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSoundRipple.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSyncGameRules.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageCureDecayParticles.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageUpdateDraetonPhysicsPart.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageSyncDraetonLeakages.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageShockArrowHit.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageShockParticle.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageInfestWeedwoodBush.class, Side.CLIENT);
        MessageRegistry.registerMessage(MessageEquipItem.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageOpenPouch.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageItemNaming.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageFlightState.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageUpdatePuppeteerState.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageUpdateRingKeybindState.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageRow.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageConnectCavingRope.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageExtendedReach.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageSetGalleryUrl.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageUpdateDraetonPhysicsPart.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageSetDraetonAnchorPos.class, Side.SERVER);
        MessageRegistry.registerMessage(MessagePurgeDraetonBurner.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageChiromawDoubleJump.class, Side.SERVER);
        MessageRegistry.registerMessage(MessageButcherFish.class, Side.SERVER);
    }

    private static void registerMessage(Class<? extends MessageBase> messageType, Side toSide) {
        byte by = nextMessageId;
        nextMessageId = (byte)(by + 1);
        TheBetweenlands.networkWrapper.registerMessage(MessageRegistry.getHandler(messageType, toSide), messageType, (int)by, toSide);
    }

    private static IMessageHandler<MessageBase, IMessage> getHandler(Class<? extends MessageBase> messageType, Side toSide) {
        if (toSide == Side.CLIENT) {
            return new ClientboundHandler();
        }
        return new ServerboundHandler();
    }

    private static class ClientboundHandler
    implements IMessageHandler<MessageBase, IMessage> {
        private ClientboundHandler() {
        }

        public IMessage onMessage(MessageBase message, MessageContext ctx) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            try {
                mc.func_152343_a(() -> message.process(ctx));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class ServerboundHandler
    implements IMessageHandler<MessageBase, IMessage> {
        private ServerboundHandler() {
        }

        public IMessage onMessage(MessageBase message, MessageContext ctx) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            try {
                server.func_175586_a(() -> message.process(ctx));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

