/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;
import thebetweenlands.api.recipes.ISteepingPotRecipe;
import thebetweenlands.common.inventory.container.ContainerSilkBundle;

public class SteepingPotRecipes
implements ISteepingPotRecipe {
    private static final List<SteepingPotRecipes> recipes = new ArrayList<SteepingPotRecipes>();
    private final ItemStack output;
    private final FluidStack fluidStackIn;
    private final FluidStack fluidStackOut;
    private final int fluidMeta;
    private final Object[] input;

    public static void addRecipe(ISteepingPotRecipe recipe) {
        if (recipe.getOutputFluidStack() != null) {
            SteepingPotRecipes.addRecipe(recipe.getOutputFluidStack(), recipe.getOutputFluidMeta(), recipe.getInputFluidStack(), recipe.getInputs());
        } else {
            SteepingPotRecipes.addRecipe(recipe.getOutputItem(), recipe.getInputFluidStack(), recipe.getInputs());
        }
    }

    public static void removeRecipe(ISteepingPotRecipe recipe) {
        if (recipe.getOutputFluidStack() != null) {
            recipes.removeIf(r -> r.getOutputFluidStack() == recipe.getOutputFluidStack() && r.getInputFluidStack() == recipe.getInputFluidStack());
        } else {
            recipes.removeIf(r -> r.getOutputItem() == recipe.getOutputItem() && r.getInputFluidStack() == recipe.getInputFluidStack());
        }
    }

    public static void addRecipe(ItemStack output, Fluid fluid, Object ... input) {
        SteepingPotRecipes.addRecipe(output, new FluidStack(fluid, 1000), input);
    }

    public static void addRecipe(Fluid output, int outputFluidMeta, Fluid fluid, Object ... input) {
        SteepingPotRecipes.addRecipe(new FluidStack(output, 1000), outputFluidMeta, new FluidStack(fluid, 1000), input);
    }

    public static void addRecipe(ItemStack output, FluidStack fluid, Object ... input) {
        SteepingPotRecipes.whitelistIngredient(input);
        recipes.add(new SteepingPotRecipes(output, fluid, input));
    }

    public static void addRecipe(FluidStack output, int outputFluidMeta, FluidStack fluid, Object ... input) {
        SteepingPotRecipes.whitelistIngredient(input);
        recipes.add(new SteepingPotRecipes(output, outputFluidMeta, fluid, input));
    }

    private static void whitelistIngredient(Object ... input) {
        for (int i = 0; i < input.length; ++i) {
            if (input[i] instanceof ItemStack) {
                ContainerSilkBundle.acceptedItems.add(((ItemStack)input[i]).func_77946_l());
                continue;
            }
            if (!(input[i] instanceof String)) continue;
            ContainerSilkBundle.acceptedItems.add((ItemStack)OreDictionary.getOres((String)((String)input[i])).get(0));
        }
    }

    public static ItemStack getOutputItem(IFluidTank tank, ItemStack ... input) {
        SteepingPotRecipes recipe = SteepingPotRecipes.getRecipe(tank, input);
        return recipe != null ? recipe.getOutputItem() : ItemStack.field_190927_a;
    }

    public static FluidStack getOutputFluid(IFluidTank tank, ItemStack ... input) {
        SteepingPotRecipes recipe = SteepingPotRecipes.getRecipe(tank, input);
        return recipe != null ? recipe.getOutputFluidStack() : null;
    }

    public static SteepingPotRecipes getRecipe(IFluidTank tank, ItemStack ... input) {
        for (SteepingPotRecipes recipe : recipes) {
            if (!recipe.matches(tank, input)) continue;
            return recipe;
        }
        return null;
    }

    public static SteepingPotRecipes getRecipeForInputStack(ItemStack stack) {
        for (SteepingPotRecipes recipe : recipes) {
            if (!recipe.containsInput(stack)) continue;
            return recipe;
        }
        return null;
    }

    public static List<SteepingPotRecipes> getRecipeList() {
        return Collections.unmodifiableList(recipes);
    }

    public SteepingPotRecipes(ItemStack output, FluidStack fluidIn, Object ... input) {
        this.output = output.func_77946_l();
        this.fluidStackOut = null;
        this.fluidMeta = 0;
        this.fluidStackIn = fluidIn;
        this.input = new Object[4];
        if (input.length > 4) {
            throw new IllegalArgumentException("Input must be 1 to 4.");
        }
        for (int c = 0; c < input.length; ++c) {
            if (input[c] instanceof ItemStack) {
                this.input[c] = ((ItemStack)input[c]).func_77946_l();
                continue;
            }
            if (input[c] instanceof String) {
                this.input[c] = OreDictionary.getOres((String)((String)input[c]));
                continue;
            }
            throw new IllegalArgumentException("Input must be an ItemStack or an OreDictionary name");
        }
        for (int i = input.length; i < 4; ++i) {
            this.input[i] = ItemStack.field_190927_a.func_77946_l();
        }
    }

    public SteepingPotRecipes(FluidStack fluidOut, int outputFluidMeta, FluidStack fluidIn, Object ... input) {
        this.output = ItemStack.field_190927_a;
        this.fluidStackOut = fluidOut.copy();
        this.fluidMeta = outputFluidMeta;
        this.fluidStackIn = fluidIn;
        this.input = new Object[4];
        if (input.length > 4) {
            throw new IllegalArgumentException("Input must be 1 to 4.");
        }
        for (int c = 0; c < input.length; ++c) {
            if (input[c] instanceof ItemStack) {
                this.input[c] = ((ItemStack)input[c]).func_77946_l();
                continue;
            }
            if (input[c] instanceof String) {
                this.input[c] = OreDictionary.getOres((String)((String)input[c]));
                continue;
            }
            throw new IllegalArgumentException("Input must be an ItemStack or an OreDictionary name");
        }
        for (int i = input.length; i < 4; ++i) {
            this.input[i] = ItemStack.field_190927_a.func_77946_l();
        }
    }

    @Override
    public Object[] getInputs() {
        return this.input;
    }

    @Override
    public List<ItemStack> getInputAsStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int c = 0; c < this.getInputs().length; ++c) {
            if (this.getInputs()[c] instanceof ItemStack) {
                stacks.add((ItemStack)this.getInputs()[c]);
                continue;
            }
            stacks.add(ItemStack.field_190927_a);
        }
        return stacks;
    }

    @Override
    public FluidStack getInputFluidStack() {
        return this.fluidStackIn;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.output.func_77946_l();
    }

    @Override
    public FluidStack getOutputFluidStack() {
        return this.fluidStackOut == null ? null : this.fluidStackOut.copy();
    }

    @Override
    public int getOutputFluidMeta() {
        return this.fluidMeta;
    }

    @Override
    public boolean matches(IFluidTank tankIn, ItemStack ... stacks) {
        if (tankIn.getFluid() == null || !tankIn.getFluid().isFluidEqual(this.getInputFluidStack())) {
            return false;
        }
        if (tankIn.getFluidAmount() < this.getInputFluidStack().amount) {
            return false;
        }
        ArrayList inputList = Lists.newArrayList();
        for (Object inputIt : this.input) {
            inputList.add((ItemStack)inputIt);
        }
        ArrayList stackList = Lists.newArrayList();
        for (ItemStack stackIt : stacks) {
            stackList.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stackIt}));
        }
        return RecipeMatcher.findMatches((List)inputList, (List)stackList) != null;
    }

    @Override
    public boolean containsInput(ItemStack stack) {
        for (Object inputIt : this.input) {
            if (!(inputIt instanceof ItemStack) || !Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)inputIt}).apply(stack)) continue;
            return true;
        }
        return false;
    }
}

