/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.recipes.ISmokingRackRecipe;
import thebetweenlands.common.recipe.custom.CustomRecipes;
import thebetweenlands.common.recipe.misc.SmokingRackRecipe;

public class CustomSmokingRackRecipes
extends CustomRecipes<ISmokingRackRecipe> {
    public CustomSmokingRackRecipes() {
        super("smoking_rack", (Map<String, CustomRecipes.RecipeArg<?>>)ImmutableMap.of((Object)"input/item", CustomRecipes.RecipeArg.ITEM_INPUT, (Object)"input/smoking_time", CustomRecipes.RecipeArg.INT, (Object)"output/item", CustomRecipes.RecipeArg.ITEM_OUTPUT), (Map<String, CustomRecipes.RecipeArg<?>>)ImmutableMap.of());
    }

    @Override
    public ISmokingRackRecipe load() {
        ItemStack input = (ItemStack)((CustomRecipes.IRecipeEntry)this.get("input/item", CustomRecipes.RecipeArg.ITEM_INPUT).get()).create();
        int smokingTime = (Integer)((CustomRecipes.IRecipeEntry)this.get("input/smoking_time", CustomRecipes.RecipeArg.INT).get()).create();
        ItemStack output = (ItemStack)((CustomRecipes.IRecipeEntry)this.get("output/item", CustomRecipes.RecipeArg.ITEM_OUTPUT).get()).create();
        return new SmokingRackRecipe(output, smokingTime, input);
    }

    @Override
    public CustomRecipes.IRecipeRegistrar<ISmokingRackRecipe> createRegistrar() {
        return new CustomRecipes.IRecipeRegistrar<ISmokingRackRecipe>(){

            @Override
            public boolean register(ISmokingRackRecipe recipe) {
                SmokingRackRecipe.addRecipe(recipe);
                return true;
            }

            @Override
            public boolean unregister(ISmokingRackRecipe recipe) {
                SmokingRackRecipe.removeRecipe(recipe);
                return true;
            }
        };
    }
}

